/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.SingleBuildModelRepository;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.DefaultModelProvider;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildsJob;

public class DefaultGradleBuild
implements GradleBuild {
    private final FixedRequestAttributes attributes;

    public DefaultGradleBuild(FixedRequestAttributes attributes) {
        this.attributes = (FixedRequestAttributes)Preconditions.checkNotNull((Object)attributes);
    }

    @Override
    public void create(NewProjectHandler newProjectHandler, AsyncHandler initializer) {
        Preconditions.checkArgument((initializer != AsyncHandler.NO_OP ? 1 : 0) != 0, (Object)"Can't create projects with a no-op initializer");
        Preconditions.checkArgument((newProjectHandler != NewProjectHandler.NO_OP ? 1 : 0) != 0, (Object)"Can't import projects with a no-op handler");
        new SynchronizeGradleBuildsJob((Set<FixedRequestAttributes>)ImmutableSet.of((Object)this.attributes), newProjectHandler, initializer).schedule();
    }

    @Override
    public void synchronize(NewProjectHandler newProjectHandler) {
        new SynchronizeGradleBuildsJob((Set<FixedRequestAttributes>)ImmutableSet.of((Object)this.attributes), newProjectHandler, AsyncHandler.NO_OP).schedule();
    }

    @Override
    public ModelProvider getModelProvider() {
        SingleBuildModelRepository modelRepository = CorePlugin.modelRepositoryProvider().getModelRepository(this.attributes);
        return new DefaultModelProvider(modelRepository);
    }
}

