/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal.deduplication;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.gradleware.tooling.toolingclient.internal.deduplication.NameDeduplicationAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HierarchicalElementDeduplicator<T> {
    private final NameDeduplicationAdapter<T> adapter;

    public HierarchicalElementDeduplicator(NameDeduplicationAdapter<T> adapter) {
        this.adapter = adapter;
    }

    public Map<T, String> deduplicate(Collection<T> elements) {
        return new StatefulDeduplicator(elements).getNewNames();
    }

    private class StatefulDeduplicator {
        private final List<T> elements;
        private final Multimap<String, T> elementsByName;
        private final Map<T, String> newNames;
        private final Map<T, T> prefixes;

        public StatefulDeduplicator(Collection<T> elements) {
            this.elements = Lists.newArrayList(elements);
            this.elementsByName = LinkedHashMultimap.create();
            this.newNames = Maps.newHashMap();
            this.prefixes = Maps.newHashMap();
        }

        public Map<T, String> getNewNames() {
            if (!this.elements.isEmpty() && this.newNames.isEmpty()) {
                this.calculateNewNames();
            }
            return ImmutableMap.copyOf(this.newNames);
        }

        private void calculateNewNames() {
            this.sortElementsByDepth();
            for (Object element : this.elements) {
                this.elementsByName.put((Object)this.getOriginalName(element), element);
                this.prefixes.put(element, this.getParent(element));
            }
            while (!this.getDuplicateNames().isEmpty()) {
                this.deduplicate();
            }
            this.simplifyNames();
        }

        private void deduplicate() {
            for (String duplicateName : this.getDuplicateNames()) {
                Collection elementsToRename = this.elementsByName.get((Object)duplicateName);
                ImmutableSet reservedNames = ImmutableSet.copyOf((Collection)this.elementsByName.keySet());
                Set notYetRenamed = this.getNotYetRenamedElements(elementsToRename);
                boolean deduplicationSuccessful = false;
                for (Object element : notYetRenamed) {
                    boolean elementRenamed = true;
                    while (elementRenamed && reservedNames.contains(this.getCurrentlyAssignedName(element))) {
                        elementRenamed = this.renameUsingParentPrefix(element);
                        deduplicationSuccessful |= elementRenamed;
                    }
                }
                if (deduplicationSuccessful) continue;
                throw new IllegalArgumentException("Duplicate root element " + duplicateName);
            }
        }

        private boolean renameUsingParentPrefix(T element) {
            Object prefixElement = this.prefixes.get(element);
            if (prefixElement != null) {
                this.renameTo(element, this.getCurrentlyAssignedName(prefixElement) + "-" + this.getCurrentlyAssignedName(element));
                this.prefixes.put(element, this.getParent(prefixElement));
                return true;
            }
            return false;
        }

        private void renameTo(T element, String newName) {
            this.elementsByName.remove((Object)this.getCurrentlyAssignedName(element), element);
            this.elementsByName.put((Object)newName, element);
            this.newNames.put(element, newName);
        }

        private void simplifyNames() {
            Set deduplicatedNames = this.elementsByName.keySet();
            for (Object element : this.elements) {
                String simplifiedName = this.removeDuplicateWordsFromPrefix(this.getCurrentlyAssignedName(element), this.getOriginalName(element));
                if (deduplicatedNames.contains(simplifiedName)) continue;
                this.renameTo(element, simplifiedName);
            }
        }

        private String removeDuplicateWordsFromPrefix(String deduplicatedName, String originalName) {
            String prefix = deduplicatedName.substring(0, deduplicatedName.lastIndexOf(originalName));
            if (prefix.isEmpty()) {
                return deduplicatedName;
            }
            Splitter splitter = Splitter.on((char)'-').omitEmptyStrings();
            ArrayList prefixParts = Lists.newArrayList((Iterable)splitter.split((CharSequence)prefix));
            ArrayList postfixParts = Lists.newArrayList((Iterable)splitter.split((CharSequence)originalName));
            ArrayList words = Lists.newArrayList();
            if (postfixParts.size() > 1) {
                String postfixHead = (String)postfixParts.get(0);
                prefixParts.add(postfixHead);
                postfixParts.remove(postfixHead);
            }
            for (String prefixPart : prefixParts) {
                if (prefixPart.equals(Iterables.getLast((Iterable)words, null))) continue;
                words.add(prefixPart);
            }
            words.addAll(postfixParts);
            return Joiner.on((char)'-').join((Iterable)words);
        }

        private Set<String> getDuplicateNames() {
            LinkedHashSet duplicates = Sets.newLinkedHashSet();
            for (Map.Entry entry : this.elementsByName.asMap().entrySet()) {
                if (((Collection)entry.getValue()).size() <= 1) continue;
                duplicates.add(entry.getKey());
            }
            return duplicates;
        }

        private Set<T> getNotYetRenamedElements(Collection<T> elementsToRename) {
            LinkedHashSet notYetRenamed = Sets.newLinkedHashSet();
            for (Object element : elementsToRename) {
                if (this.hasBeenRenamed(element)) continue;
                notYetRenamed.add(element);
            }
            return notYetRenamed;
        }

        private String getOriginalName(T element) {
            return HierarchicalElementDeduplicator.this.adapter.getName(element);
        }

        private String getCurrentlyAssignedName(T element) {
            if (this.hasBeenRenamed(element)) {
                return this.newNames.get(element);
            }
            return this.getOriginalName(element);
        }

        private T getParent(T parent) {
            return HierarchicalElementDeduplicator.this.adapter.getParent(parent);
        }

        private boolean hasBeenRenamed(T element) {
            return this.newNames.containsKey(element);
        }

        private void sortElementsByDepth() {
            Collections.sort(this.elements, new Comparator<T>(){

                @Override
                public int compare(T left, T right) {
                    return Ints.compare((int)this.getDepth(left), (int)this.getDepth(right));
                }

                private int getDepth(T element) {
                    int depth = 0;
                    Object parent = element;
                    while (parent != null) {
                        ++depth;
                        parent = StatefulDeduplicator.this.getParent(parent);
                    }
                    return depth;
                }
            });
        }
    }
}

