/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.gradleware.tooling.toolingclient.CompositeBuildModelRequest;
import com.gradleware.tooling.toolingclient.CompositeBuildRequest;
import com.gradleware.tooling.toolingclient.Consumer;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.ToolingClient;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.CompositeBuildModelRepository;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseConverter;
import com.gradleware.tooling.toolingmodel.repository.internal.BaseModelRepository;
import com.gradleware.tooling.toolingmodel.repository.internal.Converter;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.internal.EmptyModelResults;
import com.gradleware.tooling.toolingmodel.repository.internal.ModelResultsConverter;
import java.util.HashMap;
import java.util.Set;
import org.gradle.tooling.connection.ModelResults;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;

public class DefaultCompositeModelRepository
extends BaseModelRepository
implements CompositeBuildModelRepository {
    private final ImmutableSet<FixedRequestAttributes> requestAttributes;

    public DefaultCompositeModelRepository(Set<FixedRequestAttributes> requestAttributes, ToolingClient toolingClient, EventBus eventBus) {
        super(toolingClient, eventBus);
        this.requestAttributes = ImmutableSet.copyOf(requestAttributes);
    }

    @Override
    public ModelResults<OmniEclipseProject> fetchEclipseProjects(TransientRequestAttributes transientAttributes, FetchStrategy fetchStrategy) {
        CompositeBuildModelRequest<EclipseProject> modelRequest = this.createModelRequest((Class)EclipseProject.class, (Set<FixedRequestAttributes>)this.requestAttributes, transientAttributes);
        final HashMap knownEclipseProjects = Maps.newHashMap();
        final HashMap knownGradleProjects = Maps.newHashMap();
        BaseConverter<EclipseProject, OmniEclipseProject> converter = new BaseConverter<EclipseProject, OmniEclipseProject>(){

            @Override
            public OmniEclipseProject apply(EclipseProject eclipseProject) {
                return DefaultOmniEclipseProject.from(eclipseProject, knownEclipseProjects, knownGradleProjects);
            }
        };
        return this.executeRequest((Request)modelRequest, fetchStrategy, OmniEclipseProject.class, (Converter)converter);
    }

    @Override
    public ModelResults<OmniBuildEnvironment> fetchBuildEnvironments(TransientRequestAttributes transientAttributes, FetchStrategy fetchStrategy) {
        CompositeBuildModelRequest<BuildEnvironment> modelRequest = this.createModelRequest((Class)BuildEnvironment.class, (Set<FixedRequestAttributes>)this.requestAttributes, transientAttributes);
        BaseConverter<BuildEnvironment, OmniBuildEnvironment> converter = new BaseConverter<BuildEnvironment, OmniBuildEnvironment>(){

            @Override
            public OmniBuildEnvironment apply(BuildEnvironment buildEnvironment) {
                return DefaultOmniBuildEnvironment.from(buildEnvironment);
            }
        };
        return this.executeRequest((Request)modelRequest, fetchStrategy, OmniBuildEnvironment.class, (Converter)converter);
    }

    private <T> CompositeBuildModelRequest<T> createModelRequest(Class<T> model, Set<FixedRequestAttributes> fixedAttributes, TransientRequestAttributes transientAttributes) {
        CompositeBuildModelRequest request = this.getToolingClient().newCompositeModelRequest(model);
        for (FixedRequestAttributes fixedRequestAttribute : fixedAttributes) {
            fixedRequestAttribute.apply((CompositeBuildRequest<?>)request);
        }
        transientAttributes.apply((Request<?>)request);
        return request;
    }

    protected <T, U> ModelResults<U> executeRequest(Request<ModelResults<T>> request, FetchStrategy fetchStrategy, Class<?> cacheKey, Converter<T, U> resultConverter) {
        if (this.requestAttributes.isEmpty()) {
            return new EmptyModelResults();
        }
        Consumer dontSendEvents = new Consumer<ModelResults<U>>(){

            public void accept(ModelResults<U> input) {
            }
        };
        return (ModelResults)super.executeRequest(request, dontSendEvents, fetchStrategy, cacheKey, new ModelResultsConverter<T, U>(resultConverter));
    }
}

