/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniClasspathAttribute;
import com.gradleware.tooling.toolingmodel.OmniClasspathEntry;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniClasspathAttribute;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.eclipse.ClasspathAttribute;
import org.gradle.tooling.model.eclipse.EclipseClasspathEntry;

abstract class AbstractOmniClasspathEntry
implements OmniClasspathEntry {
    private List<OmniClasspathAttribute> classpathAttributes;

    AbstractOmniClasspathEntry(List<OmniClasspathAttribute> classpathAttributes) {
        this.classpathAttributes = ImmutableList.copyOf(classpathAttributes);
    }

    @Override
    public List<OmniClasspathAttribute> getClasspathAttributes() {
        return this.classpathAttributes;
    }

    protected static List<OmniClasspathAttribute> getClasspathAttributes(EclipseClasspathEntry entry) {
        DomainObjectSet attributes;
        try {
            attributes = entry.getClasspathAttributes();
        }
        catch (UnsupportedMethodException e) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ClasspathAttribute attribute : attributes) {
            builder.add((Object)DefaultOmniClasspathAttribute.from(attribute));
        }
        return builder.build();
    }
}

