/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.exceptions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.api.GradleException;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.MultiCauseException;

public class DefaultMultiCauseException
extends GradleException
implements MultiCauseException {
    private final List<Throwable> causes = new CopyOnWriteArrayList<Throwable>();
    private transient ThreadLocal<Boolean> hideCause = this.threadLocal();
    private transient Factory<String> messageFactory;
    private String message;

    public DefaultMultiCauseException(String message) {
        super(message);
        this.message = message;
    }

    public DefaultMultiCauseException(String message, Throwable ... causes) {
        super(message);
        this.message = message;
        this.causes.addAll(Arrays.asList(causes));
    }

    public DefaultMultiCauseException(String message, Iterable<? extends Throwable> causes) {
        super(message);
        this.message = message;
        this.initCauses(causes);
    }

    public DefaultMultiCauseException(Factory<String> messageFactory) {
        this.messageFactory = messageFactory;
    }

    public DefaultMultiCauseException(Factory<String> messageFactory, Throwable ... causes) {
        this(messageFactory);
        this.causes.addAll(Arrays.asList(causes));
    }

    public DefaultMultiCauseException(Factory<String> messageFactory, Iterable<? extends Throwable> causes) {
        this(messageFactory);
        this.initCauses(causes);
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.hideCause = this.threadLocal();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getMessage();
        out.defaultWriteObject();
    }

    private ThreadLocal<Boolean> threadLocal() {
        return new HideStacktrace();
    }

    @Override
    public List<? extends Throwable> getCauses() {
        return this.causes;
    }

    @Override
    public Throwable initCause(Throwable throwable) {
        this.causes.clear();
        this.causes.add(throwable);
        return null;
    }

    public void initCauses(Iterable<? extends Throwable> causes) {
        this.causes.clear();
        for (Throwable throwable : causes) {
            this.causes.add(throwable);
        }
    }

    @Override
    public Throwable getCause() {
        if (this.hideCause.get().booleanValue()) {
            return null;
        }
        return this.causes.isEmpty() ? null : this.causes.get(0);
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintWriter writer = new PrintWriter(printStream);
        this.printStackTrace(writer);
        writer.flush();
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        if (this.causes.isEmpty()) {
            super.printStackTrace(printWriter);
            return;
        }
        this.hideCause.set(true);
        try {
            super.printStackTrace(printWriter);
            if (this.causes.size() == 1) {
                this.printSingleCauseStackTrace(printWriter);
            } else {
                this.printMultiCauseStackTrace(printWriter);
            }
        }
        finally {
            this.hideCause.set(false);
        }
    }

    private void printSingleCauseStackTrace(PrintWriter printWriter) {
        Throwable cause = this.causes.get(0);
        printWriter.print("Caused by: ");
        cause.printStackTrace(printWriter);
    }

    private void printMultiCauseStackTrace(PrintWriter printWriter) {
        for (int i = 0; i < this.causes.size(); ++i) {
            Throwable cause = this.causes.get(i);
            printWriter.format("Cause %s: ", i + 1);
            cause.printStackTrace(printWriter);
        }
    }

    @Override
    public String getMessage() {
        if (this.messageFactory != null) {
            this.message = this.messageFactory.create();
            this.messageFactory = null;
            return this.message;
        }
        return this.message;
    }

    private static class HideStacktrace
    extends ThreadLocal<Boolean> {
        private HideStacktrace() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }
    }
}

