/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.task;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import org.eclipse.buildship.core.internal.util.gradle.Path;
import org.eclipse.buildship.ui.internal.view.task.BaseProjectNode;
import org.eclipse.buildship.ui.internal.view.task.BuildInvocations;
import org.eclipse.buildship.ui.internal.view.task.BuildNode;
import org.eclipse.core.resources.IProject;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.eclipse.EclipseProject;

public final class ProjectNode
extends BaseProjectNode {
    private final ProjectNode parentProjectNode;
    private final EclipseProject eclipseProject;
    private final BuildInvocations buildInvocations;
    private final BuildNode buildNode;

    public ProjectNode(ProjectNode parentProjectNode, BuildNode buildNode, Optional<IProject> workspaceProject, EclipseProject eclipseProject) {
        super(workspaceProject);
        this.parentProjectNode = parentProjectNode;
        this.eclipseProject = eclipseProject;
        this.buildInvocations = buildNode.buildInvocationsFor(Path.from((String)eclipseProject.getGradleProject().getPath()));
        this.buildNode = buildNode;
    }

    public String getDisplayName() {
        Optional<IProject> workspaceProject = this.getWorkspaceProject();
        String name = workspaceProject.isPresent() ? ((IProject)workspaceProject.get()).getName() : this.getEclipseProject().getName();
        return name;
    }

    public ProjectNode getRootProjectNode() {
        ProjectNode root = this;
        while (root.getParentProjectNode() != null) {
            root = root.getParentProjectNode();
        }
        return root;
    }

    public ProjectNode getParentProjectNode() {
        return this.parentProjectNode;
    }

    public EclipseProject getEclipseProject() {
        return this.eclipseProject;
    }

    public GradleProject getGradleProject() {
        return this.eclipseProject.getGradleProject();
    }

    public BuildInvocations getInvocations() {
        return this.buildInvocations;
    }

    public BuildNode getBuildNode() {
        return this.buildNode;
    }

    public String toString() {
        return this.eclipseProject.getGradleProject().getName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProjectNode that = (ProjectNode)other;
        return Objects.equal(this.getWorkspaceProject(), that.getWorkspaceProject()) && Objects.equal((Object)this.parentProjectNode, (Object)that.parentProjectNode) && Objects.equal((Object)this.eclipseProject, (Object)that.eclipseProject) && Objects.equal((Object)this.buildInvocations, (Object)that.buildInvocations) && Objects.equal((Object)this.buildNode, (Object)that.buildNode);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getWorkspaceProject(), this.parentProjectNode, this.eclipseProject, this.buildInvocations, this.buildNode});
    }
}

