/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.gradle.internal.impldep.javax.inject.Inject;
import org.gradle.internal.service.ServiceValidationException;
import org.gradle.internal.service.TypeStringFormatter;

final class InjectUtil {
    static Constructor<?> selectConstructor(Class<?> type) {
        if (InjectUtil.isInnerClass(type)) {
            throw new ServiceValidationException(String.format("Unable to select constructor for non-static inner class %s.", InjectUtil.format(type)));
        }
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        if (constructors.length == 1) {
            Constructor<?> constructor = constructors[0];
            if (InjectUtil.isPublicOrPackageScoped(constructor)) {
                return constructor;
            }
            if (constructor.getAnnotation(Inject.class) != null) {
                return constructor;
            }
        }
        Constructor<?> match = null;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            if (match != null) {
                throw new ServiceValidationException(String.format("Multiple constructor annotated with @Inject for %s.", InjectUtil.format(type)));
            }
            match = constructor;
        }
        if (match == null) {
            throw new ServiceValidationException(String.format("Expected a single non-private constructor, or one constructor annotated with @Inject for %s.", InjectUtil.format(type)));
        }
        return match;
    }

    private static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }

    private static boolean isPublicOrPackageScoped(Constructor<?> constructor) {
        return Modifier.isPublic(constructor.getModifiers()) || InjectUtil.isPackagePrivate(constructor.getModifiers());
    }

    static boolean isPackagePrivate(int modifiers) {
        return !Modifier.isPrivate(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPublic(modifiers);
    }

    private static String format(Type type) {
        return TypeStringFormatter.format(type);
    }

    private InjectUtil() {
    }
}

