/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.gradle;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.util.Pair;
import java.util.List;
import org.gradle.util.GradleVersion;

public final class MissingFeatures {
    private final GradleVersion targetVersion;

    public MissingFeatures(GradleVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public List<Pair<GradleVersion, String>> getMissingFeatures() {
        ImmutableList.Builder missingFeatures = ImmutableList.builder();
        this.addIfNeeded("2.1", "Cancellation support", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.4", "Test progress visualization", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.5", "Build/task progress visualization", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.5", "Transitive dependency managament", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.6", "Tests can be run from the Executions View", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.6", "Failed tests can be re-run from the Executions View", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.7", "Test classes and methods can be run from the Editor", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.9", "Custom project natures and build commands are added", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.10", "Language source level is set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.11", "Target bytecode version is set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.11", "Java runtime is set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.13", "Improved performance when loading models", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.14", "Attributes defined for Java classpath entries", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("2.14", "WTP deployment attributes defined for web projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("3.0", "Output location, classpath containers, source folder excludes-includes and JRE name are set on Java projects", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        this.addIfNeeded("3.0", "Java classpath customization done in 'eclipse.classpath.file.whenMerged' is synchronized", (ImmutableList.Builder<Pair<GradleVersion, String>>)missingFeatures);
        return missingFeatures.build();
    }

    private void addIfNeeded(String version, String missingFeature, ImmutableList.Builder<Pair<GradleVersion, String>> missingFeatures) {
        GradleVersion gradleVersion = GradleVersion.version((String)version);
        if (this.targetVersion.getBaseVersion().compareTo(gradleVersion) < 0) {
            missingFeatures.add(this.createLimitation(gradleVersion, missingFeature));
        }
    }

    private Pair<GradleVersion, String> createLimitation(GradleVersion version, String missingFeature) {
        return new Pair((Object)version, (Object)(missingFeature + " since " + version + "."));
    }
}

