/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.CancellationToken;
import org.gradle.tooling.GradleConnector;

final class DefaultModelProvider
implements ModelProvider {
    private final ModelRepository modelRepository;

    public DefaultModelProvider(ModelRepository singleModelRepository) {
        this.modelRepository = (ModelRepository)Preconditions.checkNotNull((Object)singleModelRepository);
    }

    @Override
    public OmniBuildEnvironment fetchBuildEnvironment(FetchStrategy fetchStrategy, CancellationToken token, IProgressMonitor monitor) {
        return this.modelRepository.fetchBuildEnvironment(this.getTransientRequestAttributes(token, monitor), fetchStrategy);
    }

    @Override
    public OmniGradleBuild fetchGradleBuild(FetchStrategy fetchStrategy, CancellationToken token, IProgressMonitor monitor) {
        return this.modelRepository.fetchGradleBuild(this.getTransientRequestAttributes(token, monitor), fetchStrategy);
    }

    @Override
    public Set<OmniGradleProject> fetchGradleProjects(FetchStrategy fetchStrategy, CancellationToken token, IProgressMonitor monitor) {
        return this.modelRepository.fetchGradleProjects(this.getTransientRequestAttributes(token, monitor), fetchStrategy);
    }

    @Override
    public Set<OmniEclipseProject> fetchEclipseGradleProjects(FetchStrategy fetchStrategy, CancellationToken token, IProgressMonitor monitor) {
        return this.modelRepository.fetchEclipseGradleProjects(this.getTransientRequestAttributes(token, monitor), fetchStrategy);
    }

    private final TransientRequestAttributes getTransientRequestAttributes(CancellationToken token, IProgressMonitor monitor) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList progressListeners = ImmutableList.of((Object)DelegatingProgressListener.withoutDuplicateLifecycleEvents(monitor));
        ImmutableList noEventListeners = ImmutableList.of();
        if (token == null) {
            token = GradleConnector.newCancellationTokenSource().token();
        }
        return new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), streams.getInput(), (List)progressListeners, (List)noEventListeners, token);
    }
}

