/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.launch.JavaElementResolver;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;

public final class EditorJavaElementResolver
extends JavaElementResolver {
    private final IEditorPart editorPart;

    public EditorJavaElementResolver(IEditorPart editorPart) {
        this.editorPart = (IEditorPart)Preconditions.checkNotNull((Object)editorPart);
    }

    @Override
    public Collection<IJavaElement> findJavaElements() {
        try {
            ITypeRoot typeRoot = JavaUI.getEditorInputTypeRoot((IEditorInput)this.editorPart.getEditorInput());
            if (typeRoot == null) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)this.findSelectedJavaElements(typeRoot));
        }
        catch (JavaModelException e) {
            UiPlugin.logger().warn("Failed find selected method in Java editor", (Throwable)e);
            return ImmutableList.of();
        }
    }

    private IJavaElement findSelectedJavaElements(ITypeRoot typeRoot) throws JavaModelException {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPartSite editorSite = this.editorPart.getSite();
        if (editorSite != null && (selectionProvider = editorSite.getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof TextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            return SelectionConverter.getElementAtOffset((ITypeRoot)typeRoot, (ITextSelection)textSelection);
        }
        return typeRoot;
    }

    public static EditorJavaElementResolver from(IEditorPart editorPart) {
        return new EditorJavaElementResolver(editorPart);
    }
}

