/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.operation;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.operation.BaseToolingApiOperation;
import org.eclipse.buildship.core.internal.operation.ToolingApiJobResultHandler;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;

public abstract class ToolingApiJob<T>
extends Job {
    private final CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();
    private ToolingApiJobResultHandler<T> resultHandler = new DefaultResultHandler();

    public ToolingApiJob(String name) {
        super(name);
    }

    public void setResultHandler(ToolingApiJobResultHandler<T> resultHandler) {
        this.resultHandler = (ToolingApiJobResultHandler)Preconditions.checkNotNull(resultHandler);
    }

    protected IStatus run(IProgressMonitor monitor) {
        BaseToolingApiOperation operation = new BaseToolingApiOperation(this.getName()){

            @Override
            public void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
                Object result = ToolingApiJob.this.runInToolingApi(tokenSource, monitor);
                ToolingApiJob.this.resultHandler.onSuccess(result);
            }

            @Override
            public ISchedulingRule getRule() {
                return ToolingApiJob.this.getRule();
            }
        };
        try {
            CorePlugin.operationManager().run(operation, this.tokenSource, monitor);
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status instanceof ToolingApiStatus) {
                this.resultHandler.onFailure((ToolingApiStatus)status);
            }
            return status;
        }
        return Status.OK_STATUS;
    }

    public abstract T runInToolingApi(CancellationTokenSource var1, IProgressMonitor var2) throws Exception;

    public boolean belongsTo(Object family) {
        return "org.eclipse.buildship.core.jobs".equals(family);
    }

    protected void canceling() {
        this.tokenSource.cancel();
    }

    private static final class DefaultResultHandler<T>
    implements ToolingApiJobResultHandler<T> {
        @Override
        public void onSuccess(T result) {
        }

        @Override
        public void onFailure(ToolingApiStatus status) {
            status.log();
        }
    }
}

