/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.UnsupportedConfigurationException;
import org.eclipse.buildship.core.internal.util.gradle.GradleVersion;
import org.eclipse.buildship.core.internal.util.gradle.IdeFriendlyClassLoading;
import org.eclipse.buildship.core.internal.util.gradle.SimpleIntermediateResultHandler;
import org.eclipse.buildship.core.internal.workspace.BuildActionSequence;
import org.eclipse.buildship.core.internal.workspace.CompositeModelQuery;
import org.eclipse.buildship.core.internal.workspace.DefaultEclipseWorkspace;
import org.eclipse.buildship.core.internal.workspace.DefaultEclipseWorkspaceProject;
import org.eclipse.buildship.core.internal.workspace.EclipseRuntimeConfigurer;
import org.eclipse.buildship.core.internal.workspace.TellGradleToRunSynchronizationTasks;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseRuntime;
import org.gradle.tooling.model.eclipse.EclipseWorkspaceProject;
import org.gradle.tooling.model.eclipse.RunClosedProjectBuildDependencies;

public final class EclipseModelUtils {
    private static final String EXCEPTION_DUPLICATE_ROOT_ELEMENT_TEXT = "Duplicate root element ";

    private EclipseModelUtils() {
    }

    public static Map<String, EclipseProject> queryModels(ProjectConnection connection) {
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        GradleVersion gradleVersion = GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
        if (gradleVersion.supportsSendingReservedProjects()) {
            return EclipseModelUtils.queryCompositeModelWithRuntimInfo(connection, gradleVersion);
        }
        if (gradleVersion.supportsCompositeBuilds()) {
            return EclipseModelUtils.queryCompositeModel(EclipseProject.class, connection);
        }
        return ImmutableMap.of((Object)":", (Object)EclipseModelUtils.queryModel(EclipseProject.class, connection));
    }

    public static Map<String, EclipseProject> runTasksAndQueryModels(ProjectConnection connection) {
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        GradleVersion gradleVersion = GradleVersion.version(buildEnvironment.getGradle().getGradleVersion());
        if (gradleVersion.supportsSendingReservedProjects()) {
            return EclipseModelUtils.runTasksAndQueryCompositeModelWithRuntimInfo(connection, gradleVersion);
        }
        if (gradleVersion.supportsSyncTasksInEclipsePluginConfig()) {
            return EclipseModelUtils.runTasksAndQueryCompositeModel(connection, gradleVersion);
        }
        if (gradleVersion.supportsCompositeBuilds()) {
            return EclipseModelUtils.queryCompositeModel(EclipseProject.class, connection);
        }
        return ImmutableMap.of((Object)":", (Object)EclipseModelUtils.queryModel(EclipseProject.class, connection));
    }

    public static EclipseRuntimeConfigurer buildEclipseRuntimeConfigurer() {
        ImmutableList<IProject> allWorkspaceProjects = CorePlugin.workspaceOperations().getAllProjects();
        List<EclipseWorkspaceProject> projects = allWorkspaceProjects.stream().map(p -> new DefaultEclipseWorkspaceProject(p.getName(), p.getLocation().toFile(), p.isOpen())).collect(Collectors.toList());
        return new EclipseRuntimeConfigurer(new DefaultEclipseWorkspace(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), projects));
    }

    private static Map<String, EclipseProject> runTasksAndQueryCompositeModelWithRuntimInfo(ProjectConnection connection, GradleVersion gradleVersion) {
        EclipseRuntimeConfigurer buildEclipseRuntimeConfigurer = EclipseModelUtils.buildEclipseRuntimeConfigurer();
        try {
            BuildAction runSyncTasksAction = IdeFriendlyClassLoading.loadClass(TellGradleToRunSynchronizationTasks.class);
            if (gradleVersion.supportsClosedProjectDependencySubstitution()) {
                CompositeModelQuery<RunClosedProjectBuildDependencies, EclipseRuntime> runClosedProjectTasksAction = new CompositeModelQuery<RunClosedProjectBuildDependencies, EclipseRuntime>(RunClosedProjectBuildDependencies.class, EclipseRuntime.class, buildEclipseRuntimeConfigurer);
                BuildActionSequence projectsLoadedAction = new BuildActionSequence(runSyncTasksAction, runClosedProjectTasksAction);
                return EclipseModelUtils.runPhasedModelQuery(connection, gradleVersion, projectsLoadedAction, IdeFriendlyClassLoading.loadCompositeModelQuery(EclipseProject.class, EclipseRuntime.class, buildEclipseRuntimeConfigurer));
            }
            return EclipseModelUtils.runPhasedModelQuery(connection, gradleVersion, (BuildAction<Void>)runSyncTasksAction, IdeFriendlyClassLoading.loadCompositeModelQuery(EclipseProject.class, EclipseRuntime.class, buildEclipseRuntimeConfigurer));
        }
        catch (BuildActionFailureException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IllegalArgumentException && cause.getMessage().startsWith(EXCEPTION_DUPLICATE_ROOT_ELEMENT_TEXT)) {
                String projectName = cause.getMessage().substring(EXCEPTION_DUPLICATE_ROOT_ELEMENT_TEXT.length());
                String message = String.format("A project with the name %s already exists.", projectName);
                throw new UnsupportedConfigurationException(message, e);
            }
            throw e;
        }
    }

    private static Map<String, EclipseProject> runTasksAndQueryCompositeModel(ProjectConnection connection, GradleVersion gradleVersion) {
        return EclipseModelUtils.runPhasedModelQuery(connection, gradleVersion, (BuildAction<Void>)((BuildAction)IdeFriendlyClassLoading.loadClass(TellGradleToRunSynchronizationTasks.class)), IdeFriendlyClassLoading.loadCompositeModelQuery(EclipseProject.class));
    }

    private static Map<String, EclipseProject> runPhasedModelQuery(ProjectConnection connection, GradleVersion gradleVersion, BuildAction<Void> projectsLoadedAction, BuildAction<Map<String, EclipseProject>> query) {
        SimpleIntermediateResultHandler resultHandler = new SimpleIntermediateResultHandler();
        connection.action().projectsLoaded(projectsLoadedAction, new SimpleIntermediateResultHandler()).buildFinished(query, resultHandler).build().forTasks(new String[0]).run();
        return (Map)resultHandler.getValue();
    }

    private static Map<String, EclipseProject> queryCompositeModelWithRuntimInfo(ProjectConnection connection, GradleVersion gradleVersion) {
        BuildAction<Map<String, EclipseProject>> query = IdeFriendlyClassLoading.loadCompositeModelQuery(EclipseProject.class, EclipseRuntime.class, EclipseModelUtils.buildEclipseRuntimeConfigurer());
        return (Map)connection.action(query).run();
    }

    private static <T> Map<String, T> queryCompositeModel(Class<T> model, ProjectConnection connection) {
        BuildAction<Map<String, T>> query = IdeFriendlyClassLoading.loadCompositeModelQuery(model);
        return (Map)connection.action(query).run();
    }

    private static <T> T queryModel(Class<T> model, ProjectConnection connection) {
        return (T)connection.getModel(model);
    }
}

