/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import java.util.Map;
import java.util.Optional;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.GradleProjectMarker;
import org.eclipse.buildship.core.internal.configuration.GradleProjectValidationResourceDeltaVisitor;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.gradle.IdeFriendlyClassLoading;
import org.eclipse.buildship.core.internal.workspace.TellGradleToRunAutoSyncTasks;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.IntermediateResultHandler;

public final class DefaultGradleProjectBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (kind == 6) {
            this.fullBuild(project);
        } else if (kind == 9) {
            this.runAutoBuild(monitor, project);
        } else {
            IResourceDelta delta = this.getDelta(project);
            if (delta == null) {
                this.fullBuild(project);
            } else {
                this.incrementalBuild(delta, project);
            }
        }
        return null;
    }

    private void fullBuild(IProject project) throws CoreException {
        new GradleProjectValidationResourceDeltaVisitor(project).validate();
    }

    private void incrementalBuild(IResourceDelta delta, IProject project) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new GradleProjectValidationResourceDeltaVisitor(project));
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        GradleProjectMarker.INSTANCE.removeMarkerFromResourceRecursively((IResource)this.getProject());
    }

    private void runAutoBuild(IProgressMonitor monitor, IProject project) {
        Optional<GradleBuild> gradleBuild;
        PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
        if (model.isPresent() && model.hasAutoBuildTasks() && (gradleBuild = GradleCore.getWorkspace().getBuild(project)).isPresent()) {
            try {
                gradleBuild.get().withConnection(connection -> (Void)connection.action().projectsLoaded((BuildAction)IdeFriendlyClassLoading.loadClass(TellGradleToRunAutoSyncTasks.class), NoOpResultHandler.newInstance()).build().forTasks(new String[0]).run(), monitor);
            }
            catch (Exception e) {
                CorePlugin.logger().warn("Can't run auto-build tasks", e);
            }
        }
    }

    private static final class NoOpResultHandler<T>
    implements IntermediateResultHandler<T> {
        private NoOpResultHandler() {
        }

        public void onComplete(T result) {
        }

        static <T> NoOpResultHandler<T> newInstance() {
            return new NoOpResultHandler<T>();
        }
    }
}

