/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.ui.launch.JavaElementResolver;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public final class SelectionJavaElementResolver
extends JavaElementResolver {
    private final Collection<?> adaptables;

    private SelectionJavaElementResolver(Collection<?> adaptables) {
        this.adaptables = ImmutableList.copyOf(adaptables);
    }

    @Override
    protected Collection<IJavaElement> findJavaElements() {
        return FluentIterable.from(this.adaptables).transform((Function)new Function<Object, IJavaElement>(){

            public IJavaElement apply(Object input) {
                return (IJavaElement)Platform.getAdapterManager().getAdapter(input, IJavaElement.class);
            }
        }).filter(Predicates.notNull()).toList();
    }

    public static SelectionJavaElementResolver from(ISelection selection) {
        List adaptables = selection instanceof IStructuredSelection ? ((StructuredSelection)selection).toList() : Collections.emptyList();
        return new SelectionJavaElementResolver(adaptables);
    }

    public static SelectionJavaElementResolver from(Collection<?> adaptables) {
        return new SelectionJavaElementResolver(adaptables);
    }
}

