/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.console;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.console.GradleConsole;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;

public final class CancelBuildExecutionAction
extends Action {
    private final GradleConsole gradleConsole;

    public CancelBuildExecutionAction(GradleConsole gradleConsole) {
        this.gradleConsole = (GradleConsole)((Object)Preconditions.checkNotNull((Object)((Object)gradleConsole)));
        this.setToolTipText(UiMessages.Action_CancelExecution_Tooltip);
        this.setImageDescriptor(PluginImages.CANCEL_BUILD_EXECUTION.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.CANCEL_BUILD_EXECUTION.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
    }

    private void registerJobChangeListener() {
        Optional job = this.gradleConsole.getProcessDescription().getJob();
        if (job.isPresent()) {
            ((Job)job.get()).addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    CancelBuildExecutionAction.this.setEnabled(event.getJob().getState() != 0);
                }
            });
            this.setEnabled(((Job)job.get()).getState() != 0);
        } else {
            this.setEnabled(false);
        }
    }

    public void run() {
        ((Job)this.gradleConsole.getProcessDescription().getJob().get()).cancel();
    }

    public void dispose() {
    }
}

