/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.gradleware.tooling.toolingmodel.OmniJavaSourceSettings;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.workspace.internal.EclipseVmUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

final class JavaSourceSettingsUpdater {
    private static final ImmutableList<String> availableJavaVersions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(IJavaProject project, OmniJavaSourceSettings sourceSettings, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Update Java source settings", 2);
        try {
            String complianceVersion = sourceSettings.getTargetRuntime().getJavaVersion().getName();
            String sourceVersion = sourceSettings.getSourceLanguageLevel().getName();
            String targetVersion = sourceSettings.getTargetBytecodeLevel().getName();
            File vmLocation = sourceSettings.getTargetRuntime().getHomeDirectory();
            IVMInstall vm = EclipseVmUtil.findOrRegisterVM(vmLocation, complianceVersion);
            JavaSourceSettingsUpdater.addVmToClasspath(project, vm, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!JavaSourceSettingsUpdater.eclipseRuntimeSupportsJavaVersion(complianceVersion)) {
                complianceVersion = (String)availableJavaVersions.get(availableJavaVersions.size() - 1);
            }
            if (!JavaSourceSettingsUpdater.eclipseRuntimeSupportsJavaVersion(targetVersion) || targetVersion.compareTo(complianceVersion) > 0) {
                targetVersion = complianceVersion;
            }
            if (!JavaSourceSettingsUpdater.eclipseRuntimeSupportsJavaVersion(sourceVersion) || sourceVersion.compareTo(targetVersion) > 0) {
                sourceVersion = targetVersion;
            }
            boolean compilerOptionChanged = false;
            compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.compliance", complianceVersion);
            compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.source", sourceVersion);
            if (compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.codegen.targetPlatform", targetVersion)) {
                project.getProject().build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static void addVmToClasspath(IJavaProject project, IVMInstall vm, IProgressMonitor monitor) throws JavaModelException {
        Path containerPath = new Path(JavaRuntime.JRE_CONTAINER);
        IPath vmPath = containerPath.append(vm.getVMInstallType().getId()).append(vm.getName());
        Object[] classpath = project.getRawClasspath();
        for (int i = 0; i < classpath.length; ++i) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() != 5) continue;
            if (entry.getPath().equals(vmPath)) {
                return;
            }
            if (!containerPath.isPrefixOf(entry.getPath())) continue;
            IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)vmPath);
            classpath[i] = newContainerEntry;
            project.setRawClasspath((IClasspathEntry[])classpath, monitor);
            return;
        }
        IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)vmPath);
        classpath = (IClasspathEntry[])ObjectArrays.concat((Object[])classpath, (Object)newContainerEntry);
        project.setRawClasspath((IClasspathEntry[])classpath, monitor);
    }

    private static boolean eclipseRuntimeSupportsJavaVersion(String javaSourceVersion) {
        return availableJavaVersions.contains((Object)javaSourceVersion);
    }

    private static boolean updateJavaProjectOptionIfNeeded(IJavaProject project, String optionKey, String newValue) {
        String currentValue = project.getOption(optionKey, true);
        if (currentValue == null || !currentValue.equals(newValue)) {
            project.setOption(optionKey, newValue);
            return true;
        }
        return false;
    }

    private JavaSourceSettingsUpdater() {
    }

    static {
        ArrayList<String> versions = new ArrayList<String>();
        for (Field field : JavaCore.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(String.class) || !field.getName().matches("VERSION_\\d+_\\d+")) continue;
            try {
                versions.add((String)field.get(null));
            }
            catch (Exception e) {
                CorePlugin.logger().error("Cannot retrieve supported Java versions from JavaCore.", e);
            }
        }
        Collections.sort(versions);
        availableJavaVersions = ImmutableList.copyOf(versions);
    }
}

