/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniClasspathEntry;
import com.gradleware.tooling.toolingmodel.OmniEclipseClasspathContainer;
import com.gradleware.tooling.toolingmodel.OmniJavaSourceSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.util.classpath.ClasspathUtils;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.workspace.internal.EclipseVmUtil;
import org.eclipse.buildship.core.workspace.internal.StringSetProjectProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;

final class ClasspathContainerUpdater {
    private static final String PROJECT_PROPERTY_KEY_GRADLE_CONTAINERS = "containers";
    private static final IPath DEFAULT_JRE_PATH = JavaRuntime.newDefaultJREContainerPath();
    private final IJavaProject project;
    private final boolean gradleSupportsContainers;
    private final List<OmniEclipseClasspathContainer> containers;
    private final Set<String> containerPaths;
    private final OmniJavaSourceSettings sourceSettings;

    private ClasspathContainerUpdater(IJavaProject project, Optional<List<OmniEclipseClasspathContainer>> containers, OmniJavaSourceSettings sourceSettings) {
        this.project = project;
        this.gradleSupportsContainers = containers.isPresent();
        this.containers = (List)containers.or(Collections.emptyList());
        this.containerPaths = new HashSet<String>();
        this.sourceSettings = sourceSettings;
        for (OmniEclipseClasspathContainer container : this.containers) {
            this.containerPaths.add(container.getPath());
        }
    }

    private void updateContainers(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(3);
        LinkedHashMap<IPath, IClasspathEntry> containersToAdd = this.collectContainersToAdd(progress.newChild(1));
        boolean containersToAddHasJreDefinition = ClasspathContainerUpdater.containsJrePath(containersToAdd.keySet());
        LinkedHashSet<IPath> containersToRemove = this.collectContainersToRemove(containersToAddHasJreDefinition, progress.newChild(1));
        this.updateProjectClasspath(containersToRemove, containersToAdd, progress.newChild(1));
    }

    private LinkedHashMap<IPath, IClasspathEntry> collectContainersToAdd(SubMonitor progress) throws JavaModelException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (!this.gradleSupportsContainers) {
            IPath path = this.getJrePathFromSourceSettings();
            IClasspathEntry entry = ClasspathContainerUpdater.createContainerEntry(path);
            result.put(path, entry);
        } else {
            for (OmniEclipseClasspathContainer container : this.containers) {
                IClasspathEntry entry = ClasspathContainerUpdater.createContainerEntry(container);
                result.put(entry.getPath(), entry);
            }
        }
        if (!result.keySet().contains(GradleClasspathContainer.CONTAINER_PATH)) {
            result.put(GradleClasspathContainer.CONTAINER_PATH, ClasspathContainerUpdater.createContainerEntry((IPath)GradleClasspathContainer.CONTAINER_PATH));
        }
        return result;
    }

    private IPath getJrePathFromSourceSettings() {
        String targetVersion = this.sourceSettings.getTargetBytecodeLevel().getName();
        File vmLocation = this.sourceSettings.getTargetRuntime().getHomeDirectory();
        IVMInstall vm = EclipseVmUtil.findOrRegisterStandardVM(targetVersion, vmLocation);
        Optional<IExecutionEnvironment> executionEnvironment = EclipseVmUtil.findExecutionEnvironment(targetVersion);
        return executionEnvironment.isPresent() ? JavaRuntime.newJREContainerPath((IExecutionEnvironment)((IExecutionEnvironment)executionEnvironment.get())) : JavaRuntime.newJREContainerPath((IVMInstall)vm);
    }

    private static boolean containsJrePath(Collection<IPath> containers) {
        for (IPath container : containers) {
            if (!DEFAULT_JRE_PATH.isPrefixOf(container)) continue;
            return true;
        }
        return false;
    }

    private LinkedHashSet<IPath> collectContainersToRemove(boolean includeJreContainers, SubMonitor progress) throws JavaModelException {
        StringSetProjectProperty previousPaths = StringSetProjectProperty.from(this.project.getProject(), PROJECT_PROPERTY_KEY_GRADLE_CONTAINERS);
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (String previousPath : previousPaths.get()) {
            if (this.containerPaths.contains(previousPath)) continue;
            result.add(new Path(previousPath));
        }
        if (includeJreContainers) {
            for (IClasspathEntry entry : this.project.getRawClasspath()) {
                if (entry.getEntryKind() != 5 || !DEFAULT_JRE_PATH.isPrefixOf(entry.getPath())) continue;
                result.add(entry.getPath());
            }
        }
        return result;
    }

    private void updateProjectClasspath(LinkedHashSet<IPath> containersToRemove, LinkedHashMap<IPath, IClasspathEntry> containersToAdd, SubMonitor progress) throws JavaModelException {
        StringSetProjectProperty containerPaths = StringSetProjectProperty.from(this.project.getProject(), PROJECT_PROPERTY_KEY_GRADLE_CONTAINERS);
        containerPaths.set(this.containerPaths);
        this.updateClasspathContainerEntries(containersToRemove, containersToAdd, progress);
    }

    private void updateClasspathContainerEntries(Set<IPath> containersToRemove, Map<IPath, IClasspathEntry> containersToAdd, SubMonitor progress) throws JavaModelException {
        ArrayList classpath = Lists.newArrayList((Object[])this.project.getRawClasspath());
        ListIterator iterator = classpath.listIterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iterator.next();
            if (entry.getEntryKind() != 5) continue;
            IPath entryPath = entry.getPath();
            if (containersToRemove.contains(entryPath)) {
                containersToRemove.remove(entryPath);
                iterator.remove();
                continue;
            }
            if (!containersToAdd.containsKey(entryPath)) continue;
            iterator.remove();
        }
        classpath.addAll(this.indexOfNewContainers(classpath), containersToAdd.values());
        this.project.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), (IProgressMonitor)progress);
    }

    private int indexOfNewContainers(List<IClasspathEntry> classpath) {
        int index = 0;
        for (int i = 0; i < classpath.size(); ++i) {
            if (classpath.get(i).getEntryKind() != 3) continue;
            index = i + 1;
        }
        return index;
    }

    private static IClasspathEntry createContainerEntry(OmniEclipseClasspathContainer container) {
        Path containerPath = new Path(container.getPath());
        boolean isExported = container.isExported();
        IAccessRule[] accessRules = ClasspathUtils.createAccessRules((OmniClasspathEntry)container);
        IClasspathAttribute[] attributes = ClasspathUtils.createClasspathAttributes((OmniClasspathEntry)container);
        return JavaCore.newContainerEntry((IPath)containerPath, (IAccessRule[])accessRules, (IClasspathAttribute[])attributes, (boolean)isExported);
    }

    private static IClasspathEntry createContainerEntry(IPath path) {
        return JavaCore.newContainerEntry((IPath)path);
    }

    public static void update(IJavaProject project, Optional<List<OmniEclipseClasspathContainer>> containers, OmniJavaSourceSettings omniJavaSourceSettings, IProgressMonitor monitor) throws CoreException {
        new ClasspathContainerUpdater(project, containers, omniJavaSourceSettings).updateContainers(monitor);
    }
}

