/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.ui.external.viewer.FilteredTree;
import org.eclipse.buildship.ui.external.viewer.PatternFilter;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelectionProvider;
import org.eclipse.buildship.ui.util.nodeselection.SelectionHistoryManager;
import org.eclipse.buildship.ui.view.task.TaskDescriptionLabelProvider;
import org.eclipse.buildship.ui.view.task.TaskNameLabelProvider;
import org.eclipse.buildship.ui.view.task.TaskNodeViewerFilter;
import org.eclipse.buildship.ui.view.task.TaskNodeViewerSorter;
import org.eclipse.buildship.ui.view.task.TaskViewContent;
import org.eclipse.buildship.ui.view.task.TaskViewContentProvider;
import org.eclipse.buildship.ui.view.task.TaskViewMessages;
import org.eclipse.buildship.ui.view.task.TaskViewState;
import org.eclipse.buildship.ui.view.task.UiContributionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public final class TaskView
extends ViewPart
implements NodeSelectionProvider {
    public static final String ID = "org.eclipse.buildship.ui.views.taskview";
    private TaskViewState state;
    private UiContributionManager uiContributionManager;
    private SelectionHistoryManager selectionHistoryManager;
    private PageBook pages;
    private Label emptyInputPage;
    private Label errorInputPage;
    private Composite nonEmptyInputPage;
    private TreeViewer treeViewer;
    private FilteredTree filteredTree;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.state = new TaskViewState();
        this.state.load();
    }

    public void createPartControl(Composite parent) {
        this.pages = new PageBook(parent, 0);
        this.emptyInputPage = new Label((Composite)this.pages, 0);
        this.emptyInputPage.setText(TaskViewMessages.Label_No_Gradle_Projects);
        this.errorInputPage = new Label((Composite)this.pages, 0);
        this.errorInputPage.setText(TaskViewMessages.Label_Reload_Error);
        this.errorInputPage.setForeground(parent.getDisplay().getSystemColor(3));
        this.nonEmptyInputPage = new Composite((Composite)this.pages, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.nonEmptyInputPage.setLayout((Layout)gridLayout);
        this.filteredTree = new FilteredTree(this.nonEmptyInputPage, 770, new PatternFilter(true));
        this.filteredTree.setShowFilterControls(false);
        this.treeViewer = this.filteredTree.getViewer();
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.addFilter(TaskNodeViewerFilter.createFor(this.getState()));
        this.treeViewer.setComparator((ViewerComparator)TaskNodeViewerSorter.createFor(this.state));
        this.treeViewer.setContentProvider((IContentProvider)new TaskViewContentProvider(this));
        TreeViewerColumn treeViewerNameColumn = new TreeViewerColumn(this.treeViewer, 16384);
        treeViewerNameColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TaskNameLabelProvider()));
        final TreeColumn taskNameColumn = treeViewerNameColumn.getColumn();
        taskNameColumn.setText(TaskViewMessages.Tree_Column_Name_Text);
        taskNameColumn.setWidth(this.state.getHeaderNameColumnWidth());
        TreeViewerColumn treeViewerDescriptionColumn = new TreeViewerColumn(this.treeViewer, 16384);
        treeViewerDescriptionColumn.setLabelProvider((CellLabelProvider)new TaskDescriptionLabelProvider());
        final TreeColumn taskDescriptionColumn = treeViewerDescriptionColumn.getColumn();
        taskDescriptionColumn.setText(TaskViewMessages.Tree_Column_Description_Text);
        taskDescriptionColumn.setWidth(this.state.getHeaderDescriptionColumnWidth());
        taskNameColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TaskView.this.state.setHeaderNameColumnWidth(taskNameColumn.getWidth());
            }
        });
        taskDescriptionColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TaskView.this.state.setHeaderDescriptionColumnWidth(taskDescriptionColumn.getWidth());
            }
        });
        this.selectionHistoryManager = new SelectionHistoryManager(this.treeViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionHistoryManager);
        this.uiContributionManager = new UiContributionManager(this);
        this.uiContributionManager.wire();
        this.reload(FetchStrategy.LOAD_IF_NOT_CACHED);
    }

    public void refresh() {
        if (!this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.refresh(true);
        }
    }

    public void reload(FetchStrategy modelFetchStrategy) {
        try {
            ImmutableSet rootProjectConfigs = CorePlugin.projectConfigurationManager().getRootProjectConfigurations();
            this.pages.showPage((Control)(rootProjectConfigs.isEmpty() ? this.emptyInputPage : this.nonEmptyInputPage));
            this.treeViewer.setInput((Object)new TaskViewContent((Set<ProjectConfiguration>)rootProjectConfigs, modelFetchStrategy));
        }
        catch (RuntimeException e) {
            CorePlugin.logger().error("Failed to reload task view content.", (Throwable)e);
            this.pages.showPage((Control)this.errorInputPage);
        }
    }

    public void handleProjectAdditions(Set<IProject> projects) {
        this.reload(FetchStrategy.LOAD_IF_NOT_CACHED);
    }

    public void handleProjectRemovals(Set<IProject> projects) {
        this.reload(FetchStrategy.LOAD_IF_NOT_CACHED);
    }

    public void setFocus() {
        this.pages.setFocus();
    }

    public TaskViewState getState() {
        return this.state;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public FilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    @Override
    public NodeSelection getSelection() {
        return this.selectionHistoryManager.getSelectionHistory();
    }

    public void dispose() {
        if (this.state != null) {
            this.state.dispose();
        }
        if (this.selectionHistoryManager != null) {
            this.selectionHistoryManager.dispose();
        }
        if (this.uiContributionManager != null) {
            this.uiContributionManager.dispose();
        }
        super.dispose();
    }
}

