/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.gradle.internal.UncheckedException;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ResultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockingResultHandler<T>
implements ResultHandler<T> {
    private final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
    private final Class<T> resultType;
    private static final Object NULL = new Object();

    public BlockingResultHandler(Class<T> resultType) {
        this.resultType = resultType;
    }

    public T getResult() {
        Object result;
        try {
            result = this.queue.take();
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        if (result instanceof Throwable) {
            throw UncheckedException.throwAsUncheckedException(this.attachCallerThreadStackTrace((Throwable)result));
        }
        if (result == NULL) {
            return null;
        }
        return this.resultType.cast(result);
    }

    private Throwable attachCallerThreadStackTrace(Throwable failure) {
        ArrayList<StackTraceElement> adjusted = new ArrayList<StackTraceElement>();
        adjusted.addAll(Arrays.asList(failure.getStackTrace()));
        List<StackTraceElement> currentThreadStack = Arrays.asList(Thread.currentThread().getStackTrace());
        if (!currentThreadStack.isEmpty()) {
            adjusted.addAll(currentThreadStack.subList(2, currentThreadStack.size()));
        }
        failure.setStackTrace(adjusted.toArray(new StackTraceElement[0]));
        return failure;
    }

    @Override
    public void onComplete(T result) {
        this.queue.add(result == null ? NULL : result);
    }

    @Override
    public void onFailure(GradleConnectionException failure) {
        this.queue.add(failure);
    }
}

