/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.collect.Lists;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.util.predicate.Predicates;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.ExistingDescriptorHandler;
import org.eclipse.buildship.core.workspace.SynchronizeGradleProjectJob;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerUpdater;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public final class GradleClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject javaProject) {
        this.loadClasspath(javaProject);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject javaProject, IClasspathContainer containerSuggestion) {
        this.loadClasspath(javaProject);
    }

    private void loadClasspath(IJavaProject javaProject) {
        boolean updatedFromStorage;
        IProject project = javaProject.getProject();
        if (!Predicates.accessibleGradleProject().apply((Object)project)) {
            return;
        }
        try {
            updatedFromStorage = ClasspathContainerUpdater.updateFromStorage(javaProject, null);
        }
        catch (JavaModelException e) {
            throw new GradlePluginsRuntimeException("Could not initialize Gradle classpath container.", (Exception)((Object)e));
        }
        if (!updatedFromStorage) {
            this.updateFromGradleProject(javaProject);
        }
    }

    private void updateFromGradleProject(IJavaProject project) {
        ProjectConfiguration config = CorePlugin.projectConfigurationManager().readProjectConfiguration(project.getProject());
        new SynchronizeGradleProjectJob(config.getRequestAttributes(), Lists.newArrayList(), ExistingDescriptorHandler.ALWAYS_KEEP, AsyncHandler.NO_OP).schedule();
    }
}

