/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.gradleware.tooling.toolingmodel.OmniEclipseBuildCommand;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.OmniJavaSourceSettings;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.util.Maybe;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.util.file.RelativePathUtils;
import org.eclipse.buildship.core.util.predicate.Predicates;
import org.eclipse.buildship.core.workspace.ExistingDescriptorHandler;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.workspace.WorkspaceGradleOperations;
import org.eclipse.buildship.core.workspace.internal.BuildCommandUpdater;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerUpdater;
import org.eclipse.buildship.core.workspace.internal.DefaultProjectCreatedEvent;
import org.eclipse.buildship.core.workspace.internal.JavaSourceSettingsUpdater;
import org.eclipse.buildship.core.workspace.internal.LinkedResourcesUpdater;
import org.eclipse.buildship.core.workspace.internal.ProjectNatureUpdater;
import org.eclipse.buildship.core.workspace.internal.ResourceFilter;
import org.eclipse.buildship.core.workspace.internal.SourceFolderUpdater;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

public final class DefaultWorkspaceGradleOperations
implements WorkspaceGradleOperations {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronizeGradleBuildWithWorkspace(OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes rootRequestAttributes, List<String> workingSets, ExistingDescriptorHandler existingDescriptorHandler, IProgressMonitor monitor) {
        List allGradleProjects = gradleBuild.getRootEclipseProject().getAll();
        List<IProject> decoupledWorkspaceProjects = this.collectOpenWorkspaceProjectsRemovedFromGradleBuild(allGradleProjects, rootRequestAttributes);
        monitor.beginTask("Synchronize Gradle build with workspace", decoupledWorkspaceProjects.size() + allGradleProjects.size());
        try {
            for (IProject project : decoupledWorkspaceProjects) {
                this.uncoupleWorkspaceProjectFromGradle(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            for (OmniEclipseProject gradleProject : allGradleProjects) {
                this.synchronizeGradleProjectWithWorkspaceProject(gradleProject, gradleBuild, rootRequestAttributes, workingSets, existingDescriptorHandler, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private List<IProject> collectOpenWorkspaceProjectsRemovedFromGradleBuild(List<OmniEclipseProject> gradleProjects, final FixedRequestAttributes rootRequestAttributes) {
        ImmutableSet gradleProjectDirectories = FluentIterable.from(gradleProjects).transform((Function)new Function<OmniEclipseProject, File>(){

            public File apply(OmniEclipseProject gradleProject) {
                return gradleProject.getProjectDirectory();
            }
        }).toSet();
        ImmutableList<IProject> allWorkspaceProjects = CorePlugin.workspaceOperations().getAllProjects();
        return FluentIterable.from(allWorkspaceProjects).filter(Predicates.accessibleGradleProject()).filter((Predicate)new Predicate<IProject>((Set)gradleProjectDirectories){
            final /* synthetic */ Set val$gradleProjectDirectories;
            {
                this.val$gradleProjectDirectories = set;
            }

            public boolean apply(IProject project) {
                ProjectConfiguration projectConfiguration = CorePlugin.projectConfigurationManager().readProjectConfiguration(project);
                return projectConfiguration.getRequestAttributes().getProjectDir().equals(rootRequestAttributes.getProjectDir()) && (project.getLocation() == null || !this.val$gradleProjectDirectories.contains(project.getLocation().toFile()));
            }
        }).toList();
    }

    @Override
    public void synchronizeGradleProjectWithWorkspaceProject(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes rootRequestAttributes, List<String> workingSets, ExistingDescriptorHandler existingDescriptorHandler, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Synchronize Gradle project %s with workspace project", project.getName()), 1);
        try {
            Optional<IProject> workspaceProject = CorePlugin.workspaceOperations().findProjectByLocation(project.getProjectDirectory());
            if (workspaceProject.isPresent()) {
                this.synchronizeWorkspaceProject(project, gradleBuild, (IProject)workspaceProject.get(), rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                this.synchronizeNonWorkspaceProject(project, gradleBuild, rootRequestAttributes, workingSets, existingDescriptorHandler, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot synchronize Gradle project %s with workspace project.", project.getName()), (Exception)((Object)e));
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeWorkspaceProject(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, IProject workspaceProject, FixedRequestAttributes rootRequestAttributes, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.format("Synchronize Gradle project %s that is already in the workspace", project.getName()), 1);
        try {
            if (workspaceProject.isAccessible()) {
                this.synchronizeOpenWorkspaceProject(project, gradleBuild, workspaceProject, rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                this.synchronizeClosedWorkspaceProject();
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeOpenWorkspaceProject(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, IProject workspaceProject, FixedRequestAttributes rootRequestAttributes, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.format("Synchronize Gradle project %s that is open in the workspace", project.getName()), 11);
        try {
            CorePlugin.workspaceOperations().refreshProject(workspaceProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CorePlugin.workspaceOperations().addNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (rootRequestAttributes != null) {
                ProjectConfiguration configuration = ProjectConfiguration.from(rootRequestAttributes, project);
                CorePlugin.projectConfigurationManager().saveProjectConfiguration(configuration, workspaceProject);
            }
            List<File> filteredSubFolders = this.getChildProjectDirectories(project);
            ResourceFilter.updateFilters(workspaceProject, filteredSubFolders, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            LinkedResourcesUpdater.update(workspaceProject, project.getLinkedResources(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.markDerivedFolders(project, workspaceProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.isJavaProject(project)) {
                IJavaProject javaProject;
                if (this.hasJavaNature(workspaceProject)) {
                    javaProject = JavaCore.create((IProject)workspaceProject);
                    monitor.worked(1);
                } else {
                    IPath jrePath = JavaRuntime.getDefaultJREContainerEntry().getPath();
                    IClasspathEntry classpathContainer = GradleClasspathContainer.newClasspathEntry();
                    javaProject = CorePlugin.workspaceOperations().createJavaProject(workspaceProject, jrePath, classpathContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                JavaSourceSettingsUpdater.update(javaProject, (OmniJavaSourceSettings)project.getJavaSourceSettings().get(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                SourceFolderUpdater.update(javaProject, project.getSourceDirectories(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                ClasspathContainerUpdater.updateFromModel(javaProject, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                monitor.worked(4);
            }
            ProjectNatureUpdater.update(workspaceProject, (Optional<List<OmniEclipseProjectNature>>)project.getProjectNatures(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            BuildCommandUpdater.update(workspaceProject, (Optional<List<OmniEclipseBuildCommand>>)project.getBuildCommands(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private void synchronizeClosedWorkspaceProject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeNonWorkspaceProject(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes rootRequestAttributes, List<String> workingSets, ExistingDescriptorHandler existingDescriptorHandler, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.format("Synchronize Gradle project %s that is not yet in the workspace", project.getName()), 2);
        try {
            IProject workspaceProject;
            Optional<IProjectDescription> projectDescription = CorePlugin.workspaceOperations().findProjectInFolder(project.getProjectDirectory(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (projectDescription.isPresent()) {
                if (existingDescriptorHandler.shouldOverwriteDescriptor((IProjectDescription)projectDescription.get())) {
                    CorePlugin.workspaceOperations().deleteProjectDescriptors(project.getProjectDirectory());
                    workspaceProject = this.addNewEclipseProjectToWorkspace(project, gradleBuild, rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    workspaceProject = this.addExistingEclipseProjectToWorkspace(project, gradleBuild, (IProjectDescription)projectDescription.get(), rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            } else {
                workspaceProject = this.addNewEclipseProjectToWorkspace(project, gradleBuild, rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            DefaultProjectCreatedEvent event = new DefaultProjectCreatedEvent(workspaceProject, workingSets);
            CorePlugin.listenerRegistry().dispatch(event);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject addExistingEclipseProjectToWorkspace(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, IProjectDescription projectDescription, FixedRequestAttributes rootRequestAttributes, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.format("Add existing Eclipse project %s for Gradle project %s to the workspace", projectDescription.getName(), project.getName()), 2);
        try {
            IProject workspaceProject = CorePlugin.workspaceOperations().includeProject(projectDescription, (List<String>)ImmutableList.of(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.synchronizeOpenWorkspaceProject(project, gradleBuild, workspaceProject, rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IProject iProject = workspaceProject;
            return iProject;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IProject addNewEclipseProjectToWorkspace(OmniEclipseProject project, OmniEclipseGradleBuild gradleBuild, FixedRequestAttributes rootRequestAttributes, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.format("Add new Eclipse project for Gradle project %s to the workspace", project.getName()), 2);
        try {
            IProject workspaceProject = CorePlugin.workspaceOperations().createProject(project.getName(), project.getProjectDirectory(), (List<String>)ImmutableList.of(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.synchronizeOpenWorkspaceProject(project, gradleBuild, workspaceProject, rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IProject iProject = workspaceProject;
            return iProject;
        }
        finally {
            monitor.done();
        }
    }

    private List<File> getChildProjectDirectories(OmniEclipseProject project) {
        return FluentIterable.from((Iterable)project.getChildren()).transform((Function)new Function<OmniEclipseProject, File>(){

            public File apply(OmniEclipseProject childProject) {
                return childProject.getProjectDirectory();
            }
        }).toList();
    }

    private void markDerivedFolders(OmniEclipseProject gradleProject, IProject workspaceProject, IProgressMonitor monitor) throws CoreException {
        IFolder dotGradle;
        IFolder buildDirectory = this.getBuildDirectory(gradleProject, workspaceProject);
        if (buildDirectory.exists()) {
            CorePlugin.workspaceOperations().markAsDerived((IResource)buildDirectory, monitor);
            CorePlugin.workspaceOperations().markAsBuildFolder(buildDirectory);
        }
        if ((dotGradle = workspaceProject.getFolder(".gradle")).exists()) {
            CorePlugin.workspaceOperations().markAsDerived((IResource)dotGradle, monitor);
        }
    }

    private IFolder getBuildDirectory(OmniEclipseProject project, IProject workspaceProject) {
        OmniGradleProject gradleProject = project.getGradleProject();
        Maybe buildDirectory = gradleProject.getBuildDirectory();
        if (buildDirectory.isPresent() && buildDirectory.get() != null) {
            IPath relativePath = RelativePathUtils.getRelativePath(workspaceProject.getLocation(), (IPath)new Path(((File)buildDirectory.get()).getPath()));
            return workspaceProject.getFolder(relativePath);
        }
        return workspaceProject.getFolder("build");
    }

    private boolean isJavaProject(OmniEclipseProject project) {
        return project.getJavaSourceSettings().isPresent();
    }

    private boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncoupleWorkspaceProjectFromGradle(IProject workspaceProject, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Uncouple workspace project %s from Gradle", workspaceProject.getName()), 2);
        try {
            ResourceFilter.detachAllFilters(workspaceProject, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CorePlugin.workspaceOperations().removeNature(workspaceProject, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            CorePlugin.projectConfigurationManager().deleteProjectConfiguration(workspaceProject);
        }
        finally {
            monitor.done();
        }
    }
}

