/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.launch.RunGradleConfigurationDelegateJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public final class GradleRunConfigurationDelegate
extends LaunchConfigurationDelegate {
    public static final String ID = "org.eclipse.buildship.core.launch.runconfiguration";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        monitor.beginTask("Launch Gradle tasks", -1);
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            RunGradleConfigurationDelegateJob job = new RunGradleConfigurationDelegateJob(launch, configuration);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    latch.countDown();
                }
            });
            job.schedule();
            try {
                boolean cancelRequested = false;
                while (!latch.await(500L, TimeUnit.MILLISECONDS)) {
                    if (!monitor.isCanceled() || cancelRequested) continue;
                    job.cancel();
                    cancelRequested = true;
                }
            }
            catch (InterruptedException e) {
                CorePlugin.logger().error("Failed to launch Gradle tasks.", e);
            }
        }
        finally {
            monitor.done();
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
    }
}

