/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniGradleBuildStructure;
import com.gradleware.tooling.toolingmodel.OmniGradleProjectStructure;
import com.gradleware.tooling.toolingmodel.util.Pair;
import com.gradleware.tooling.toolingutils.binding.Property;
import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.gradle.Limitations;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.util.gradle.GradleDistributionFormatter;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.util.font.FontUtils;
import org.eclipse.buildship.ui.util.layout.LayoutUtils;
import org.eclipse.buildship.ui.util.widget.UiBuilder;
import org.eclipse.buildship.ui.wizard.project.AbstractWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.gradle.tooling.ProgressListener;
import org.gradle.util.GradleVersion;

public final class ProjectPreviewWizardPage
extends AbstractWizardPage {
    private final ProjectPreviewLoader projectPreviewLoader;
    private final Font keyFont;
    private final Font valueFont;
    private final String pageContextInformation;
    private Label projectDirLabel;
    private Label gradleUserHomeLabel;
    private Label gradleDistributionLabel;
    private Label gradleVersionLabel;
    private Label gradleVersionWarningLabel;
    private Label javaHomeLabel;
    private Label jvmArgumentsLabel;
    private Label argumentsLabel;
    private Tree projectPreviewTree;

    public ProjectPreviewWizardPage(ProjectImportConfiguration configuration, ProjectPreviewLoader previewLoader) {
        this(configuration, previewLoader, ProjectWizardMessages.Title_PreviewImportWizardPage, ProjectWizardMessages.InfoMessage_PreviewImportWizardPageDefault, ProjectWizardMessages.InfoMessage_GradlePreviewWizardPageContext);
    }

    public ProjectPreviewWizardPage(ProjectImportConfiguration configuration, ProjectPreviewLoader previewLoader, String title, String defaultMessage, String pageContextInformation) {
        super("ProjectPreview", title, defaultMessage, configuration, (List<Property<?>>)ImmutableList.of());
        this.projectPreviewLoader = (ProjectPreviewLoader)Preconditions.checkNotNull((Object)previewLoader);
        this.keyFont = FontUtils.getCustomDialogFont(1);
        this.valueFont = FontUtils.getCustomDialogFont(0);
        this.pageContextInformation = pageContextInformation;
    }

    @Override
    protected void createWidgets(Composite root) {
        root.setLayout(this.createLayout());
        this.createContent(root);
    }

    private Layout createLayout() {
        GridLayout layout = LayoutUtils.newGridLayout(2);
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        return layout;
    }

    private void createContent(Composite root) {
        this.createSummaryLabels(root);
        this.createPreviewGroup(root);
        this.updatePreviewLabels(this.getConfiguration());
    }

    private void createSummaryLabels(Composite container) {
        UiBuilder.UiBuilderFactory uiBuilderFactory = this.getUiBuilderFactory();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_ProjectRootDirectory + ":").font(this.keyFont).alignLeft();
        this.projectDirLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_GradleUserHome + ":").font(this.keyFont).alignLeft();
        this.gradleUserHomeLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_GradleDistribution + ":").font(this.keyFont).alignLeft();
        this.gradleDistributionLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_GradleVersion + ":").font(this.keyFont).alignLeft();
        Composite gradleVersionContainer = new Composite(container, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)gradleVersionContainer);
        GridLayoutFactory.swtDefaults().margins(0, 0).extendedMargins(0, 0, 0, 0).spacing(0, 0).numColumns(2).applyTo(gradleVersionContainer);
        this.gradleVersionLabel = uiBuilderFactory.newLabel(gradleVersionContainer).alignLeft().disabled().font(this.valueFont).control();
        this.gradleVersionWarningLabel = uiBuilderFactory.newLabel(gradleVersionContainer).alignLeft().control();
        this.gradleVersionWarningLabel.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        this.gradleVersionWarningLabel.setToolTipText(ProjectWizardMessages.Limitations_Tooltip);
        this.gradleVersionWarningLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                String version = ProjectPreviewWizardPage.this.gradleVersionLabel.getText();
                Limitations limitations = new Limitations(GradleVersion.version((String)version));
                FluentIterable limitationMessages = FluentIterable.from((Iterable)limitations.getLimitations()).transform((Function)new Function<Pair<GradleVersion, String>, String>(){

                    public String apply(Pair<GradleVersion, String> limitation) {
                        return (String)limitation.getSecond();
                    }
                });
                String message = NLS.bind((String)ProjectWizardMessages.Limitations_Details_0_1, (Object)version, (Object)Joiner.on((char)'\n').join((Iterable)limitationMessages));
                MessageDialog.openInformation((Shell)ProjectPreviewWizardPage.this.getShell(), (String)ProjectWizardMessages.Title_Dialog_Limitations, (String)message);
            }
        });
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_JavaHome + ":").font(this.keyFont).alignLeft();
        this.javaHomeLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_JvmArguments + ":").font(this.keyFont).alignLeft();
        this.jvmArgumentsLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_ProgramArguments + ":").font(this.keyFont).alignLeft();
        this.argumentsLabel = uiBuilderFactory.newLabel(container).alignFillHorizontal().disabled().font(this.valueFont).control();
    }

    private void createPreviewGroup(Composite container) {
        UiBuilder.UiBuilderFactory uiBuilderFactory = this.getUiBuilderFactory();
        this.createSpacingRow(container, 2);
        uiBuilderFactory.newLabel(container).text(ProjectWizardMessages.Label_ProjectStructure + ":").font(this.keyFont).alignLeft();
        this.projectPreviewTree = uiBuilderFactory.newTree(container).alignFillBoth(2).control();
    }

    private void createSpacingRow(Composite container, int horizontalSpan) {
        GridData data = new GridData(16384, 0x1000000, false, false, horizontalSpan, 1);
        data.heightHint = 8;
        new Label(container, 0).setLayoutData((Object)data);
    }

    private void updatePreviewLabels(ProjectImportConfiguration configuration) {
        this.updateFileLabel(this.projectDirLabel, (Property<File>)configuration.getProjectDir(), CoreMessages.Value_UseGradleDefault);
        this.updateGradleDistributionLabel(this.gradleDistributionLabel, (Property<GradleDistributionWrapper>)configuration.getGradleDistribution(), CoreMessages.Value_UseGradleDefault);
        this.updateGradleVersionLabel(this.gradleVersionLabel, (Property<GradleDistributionWrapper>)configuration.getGradleDistribution(), CoreMessages.Value_Unknown);
        this.updateGradleVersionWarningLabel();
        this.updateFileLabel(this.gradleUserHomeLabel, (Property<File>)configuration.getGradleUserHome(), CoreMessages.Value_UseGradleDefault);
        this.updateFileLabel(this.javaHomeLabel, (Property<File>)configuration.getJavaHome(), CoreMessages.Value_UseGradleDefault);
        this.updateStringLabel(this.jvmArgumentsLabel, (Property<String>)configuration.getJvmArguments(), CoreMessages.Value_None);
        this.updateStringLabel(this.argumentsLabel, (Property<String>)configuration.getArguments(), CoreMessages.Value_None);
    }

    private void updateStringLabel(Label target, Property<String> source, String defaultMessage) {
        String string = Strings.emptyToNull((String)((String)source.getValue()));
        target.setText(string != null ? string : defaultMessage);
    }

    private void updateFileLabel(Label target, Property<File> source, String defaultMessage) {
        File file = (File)source.getValue();
        target.setText(file != null ? file.getAbsolutePath() : defaultMessage);
    }

    private void updateGradleDistributionLabel(Label target, Property<GradleDistributionWrapper> gradleDistribution, String defaultMessage) {
        GradleDistributionWrapper gradleDistributionWrapper = (GradleDistributionWrapper)gradleDistribution.getValue();
        target.setText(gradleDistributionWrapper != null ? GradleDistributionFormatter.toString((GradleDistributionWrapper)gradleDistributionWrapper) : defaultMessage);
    }

    private void updateGradleVersionLabel(Label target, Property<GradleDistributionWrapper> gradleDistribution, String defaultMessage) {
        GradleDistributionWrapper gradleDistributionWrapper = (GradleDistributionWrapper)gradleDistribution.getValue();
        if (gradleDistributionWrapper == null) {
            target.setText(defaultMessage);
            return;
        }
        switch (gradleDistributionWrapper.getType()) {
            case WRAPPER: 
            case LOCAL_INSTALLATION: 
            case REMOTE_DISTRIBUTION: {
                target.setText(defaultMessage);
                break;
            }
            case VERSION: {
                target.setText(gradleDistributionWrapper.getConfiguration());
                break;
            }
            default: {
                throw new GradlePluginsRuntimeException("Unrecognized Gradle distribution type: " + gradleDistributionWrapper.getType());
            }
        }
        target.getParent().layout();
    }

    private void updateGradleVersionWarningLabel() {
        try {
            GradleVersion version = GradleVersion.version((String)this.gradleVersionLabel.getText());
            Limitations limitations = new Limitations(version);
            this.gradleVersionWarningLabel.setVisible(!limitations.getLimitations().isEmpty());
        }
        catch (IllegalArgumentException e) {
            this.gradleVersionWarningLabel.setVisible(false);
        }
        this.gradleVersionLabel.getParent().layout();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updatePreviewLabels(this.getConfiguration());
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectPreviewWizardPage.this.scheduleProjectPreviewJob();
                }
            });
        }
    }

    private void scheduleProjectPreviewJob() {
        final CountDownLatch latch = new CountDownLatch(1);
        final DelegatingProgressListener listener = new DelegatingProgressListener();
        final Job job = this.projectPreviewLoader.loadPreview(new ProjectPreviewJobResultHandler(latch), (List<ProgressListener>)ImmutableList.of((Object)listener));
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InterruptedException {
                    monitor.beginTask("Loading project preview", -1);
                    listener.setMonitor(monitor);
                    while (!latch.await(500L, TimeUnit.MILLISECONDS)) {
                        if (!monitor.isCanceled()) continue;
                        job.cancel();
                        throw new InterruptedException();
                    }
                }
            });
        }
        catch (Exception e) {
            UiPlugin.logger().error("Failed to load preview.", (Throwable)e);
        }
    }

    @Override
    protected String getPageContextInformation() {
        return this.pageContextInformation;
    }

    @Override
    public void dispose() {
        this.keyFont.dispose();
        this.valueFont.dispose();
        super.dispose();
    }

    private final class ProjectPreviewJobResultHandler
    implements FutureCallback<Pair<OmniBuildEnvironment, OmniGradleBuildStructure>> {
        private final CountDownLatch latch;

        private ProjectPreviewJobResultHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onSuccess(Pair<OmniBuildEnvironment, OmniGradleBuildStructure> result) {
            this.latch.countDown();
            this.updateSummary((OmniBuildEnvironment)result.getFirst());
            this.populateTree((OmniGradleBuildStructure)result.getSecond());
        }

        public void onFailure(Throwable t) {
            this.latch.countDown();
            this.clearTree();
        }

        private void updateSummary(final OmniBuildEnvironment buildEnvironment) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (buildEnvironment.getGradle().getGradleUserHome().isPresent()) {
                        String gradleUserHome = ((File)buildEnvironment.getGradle().getGradleUserHome().get()).getAbsolutePath();
                        ProjectPreviewWizardPage.this.gradleUserHomeLabel.setText(gradleUserHome);
                    }
                    String gradleVersion = buildEnvironment.getGradle().getGradleVersion();
                    ProjectPreviewWizardPage.this.gradleVersionLabel.setText(gradleVersion);
                    ProjectPreviewWizardPage.this.updateGradleVersionWarningLabel();
                    String javaHome = buildEnvironment.getJava().getJavaHome().getAbsolutePath();
                    ProjectPreviewWizardPage.this.javaHomeLabel.setText(javaHome);
                }
            });
        }

        private void populateTree(final OmniGradleBuildStructure buildStructure) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectPreviewWizardPage.this.projectPreviewTree.removeAll();
                    OmniGradleProjectStructure rootProject = buildStructure.getRootProject();
                    TreeItem rootTreeItem = new TreeItem(ProjectPreviewWizardPage.this.projectPreviewTree, 0);
                    rootTreeItem.setExpanded(true);
                    rootTreeItem.setText(rootProject.getName());
                    ProjectPreviewJobResultHandler.this.populateRecursively(rootProject, rootTreeItem);
                }
            });
        }

        private void clearTree() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectPreviewWizardPage.this.projectPreviewTree.removeAll();
                }
            });
        }

        private void populateRecursively(OmniGradleProjectStructure gradleProjectStructure, TreeItem parent) {
            for (OmniGradleProjectStructure childProject : gradleProjectStructure.getChildren()) {
                TreeItem treeItem = new TreeItem(parent, 0);
                treeItem.setText(childProject.getName());
                this.populateRecursively(childProject, treeItem);
            }
        }
    }

    public static interface ProjectPreviewLoader {
        public Job loadPreview(FutureCallback<Pair<OmniBuildEnvironment, OmniGradleBuildStructure>> var1, List<ProgressListener> var2);
    }
}

