/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.launching.JavaRuntime;

public class JavaProjectClassLoader {
    private IJavaProject javaProject;
    private URLClassLoader classLoader = null;

    public JavaProjectClassLoader(IJavaProject javaProject) {
        if (javaProject == null || !javaProject.exists()) {
            throw new IllegalArgumentException("Invalid javaProject");
        }
        this.javaProject = javaProject;
    }

    public JavaProjectClassLoader(IProject project) {
        if (project == null || !project.exists()) {
            throw new IllegalArgumentException("Invalid javaProject");
        }
        this.javaProject = JavaCore.create((IProject)project);
    }

    public IType findClass(String className, IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return javaProject.findType(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<IType> findClasses(String classNamePattern) {
        ArrayList<IType> results = new ArrayList<IType>();
        if (classNamePattern.endsWith(".java")) {
            classNamePattern = classNamePattern.substring(0, classNamePattern.lastIndexOf("."));
        }
        this.findClasses(classNamePattern, results);
        return results;
    }

    public void findClasses(String classNamePattern, final List<IType> results) {
        SearchEngine searchEngine = new SearchEngine();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaProject[]{this.javaProject});
        char[] packageName = null;
        char[] typeName = null;
        int index = classNamePattern.lastIndexOf(46);
        int packageMatch = 0;
        int typeMatch = 1;
        if (index == -1) {
            typeName = classNamePattern.toCharArray();
        } else if (index + 1 == classNamePattern.length()) {
            typeName = "".toCharArray();
            packageName = classNamePattern.substring(0, index).toCharArray();
        } else {
            typeName = classNamePattern.substring(index + 1).toCharArray();
            packageName = classNamePattern.substring(0, index).toCharArray();
        }
        try {
            TypeNameMatchRequestor req = new TypeNameMatchRequestor(){

                public void acceptTypeNameMatch(TypeNameMatch match) {
                    results.add(match.getType());
                }
            };
            searchEngine.searchAllTypeNames(packageName, packageMatch, typeName, typeMatch, 10, scope, req, 3, null);
        }
        catch (CoreException coreException) {}
    }

    public Class<?> loadClass(String name) {
        this.getClassLoader();
        if (this.classLoader != null) {
            try {
                return this.classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    private URLClassLoader getClassLoader() {
        if (this.classLoader == null) {
            try {
                String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)this.javaProject);
                ArrayList<URL> urlList = new ArrayList<URL>();
                int i = 0;
                while (i < classPathEntries.length) {
                    String entry = classPathEntries[i];
                    Path path = new Path(entry);
                    URL url = path.toFile().toURI().toURL();
                    urlList.add(url);
                    ++i;
                }
                ClassLoader parentClassLoader = JavaProjectClassLoader.class.getClassLoader();
                URL[] urls = urlList.toArray(new URL[urlList.size()]);
                this.classLoader = new URLClassLoader(urls, parentClassLoader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.classLoader;
    }
}

