/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.model;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.di.BpmnDiFactory;
import org.eclipse.bpmn2.di.BpmnDiPackage;
import org.eclipse.bpmn2.impl.Bpmn2FactoryImpl;
import org.eclipse.bpmn2.impl.DocumentRootImpl;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.model.Messages;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntimeAdapter;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dd.dc.DcPackage;
import org.eclipse.dd.di.DiPackage;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.osgi.util.NLS;

public class Bpmn2ModelerFactory
extends Bpmn2FactoryImpl {
    public static final String TARGET_RUNTIME = "TargetRuntime";
    public static final String INITIALIZE_OBJECT = "InitializeObject";
    protected static boolean enableModelExtensions = true;
    protected static Resource resource;
    private static ReentrantLock lock;

    static {
        lock = new ReentrantLock();
    }

    public static void lock() {
        lock.lock();
    }

    public static void unlock() {
        lock.unlock();
    }

    public static Bpmn2Factory getInstance() {
        return eINSTANCE;
    }

    public DocumentRoot createDocumentRoot() {
        Bpmn2ModelerDocumentRootImpl documentRoot = new Bpmn2ModelerDocumentRootImpl();
        return documentRoot;
    }

    public EObject create(EClass eClass) {
        if (resource != null) {
            return Bpmn2ModelerFactory.create(resource, eClass, new KeyValue[0]);
        }
        return super.create(eClass);
    }

    public EObject createInternal(EClass eClass) {
        return super.create(eClass);
    }

    public static <T extends EObject> T create(Resource resource, Class<T> clazz) {
        EClass eClass = Bpmn2ModelerFactory.getEClass(resource, clazz);
        return (T)Bpmn2ModelerFactory.create(resource, eClass, new KeyValue[0]);
    }

    public static EObject create(Resource resource, EClass eClass, KeyValue ... args) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (args != null) {
            KeyValue[] keyValueArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                KeyValue kv = keyValueArray[n2];
                if (kv.getValue() != null) {
                    map.put(kv.getKey(), kv.getValue());
                }
                ++n2;
            }
        }
        return Bpmn2ModelerFactory.create(resource, eClass, map);
    }

    public static EObject create(Resource resource, EClass eClass, Map<String, Object> args) {
        Assert.isTrue((eClass != null ? 1 : 0) != 0);
        Assert.isTrue((resource != null ? 1 : 0) != 0);
        EObject object = null;
        Bpmn2ModelerFactory.lock();
        try {
            try {
                ExtendedPropertiesAdapter adapter;
                String customElementId = null;
                TargetRuntime rt = null;
                boolean initializeObject = enableModelExtensions;
                if (args != null) {
                    for (Map.Entry<String, Object> kv : args.entrySet()) {
                        if ("custom.element.id".equals(kv.getKey())) {
                            customElementId = (String)kv.getValue();
                        }
                        if (TARGET_RUNTIME.equals(kv.getKey())) {
                            rt = (TargetRuntime)kv.getValue();
                        }
                        if (!INITIALIZE_OBJECT.equals(kv.getKey())) continue;
                        initializeObject = (Boolean)kv.getValue();
                    }
                }
                if (rt == null) {
                    rt = TargetRuntime.getRuntime(resource);
                }
                Assert.isTrue((rt != null ? 1 : 0) != 0);
                EFactory factory = eClass.getEPackage().getEFactoryInstance();
                object = factory instanceof Bpmn2ModelerFactory ? ((Bpmn2ModelerFactory)factory).createInternal(eClass) : factory.create(eClass);
                TargetRuntimeAdapter.adapt(object, rt);
                String className = eClass.getName();
                if (!className.equals(Bpmn2Package.eINSTANCE.getDocumentRoot().getName()) && rt.getModelDescriptor().getEPackage() != Bpmn2Package.eINSTANCE && rt.getModelDescriptor().getEPackage() != null && rt.getModelDescriptor().getEPackage().getEClassifier(className) != null) {
                    EClass clazz = (EClass)rt.getModelDescriptor().getEPackage().getEClassifier(className);
                    object = rt.getModelDescriptor().getEFactory().create(clazz);
                }
                if (customElementId != null) {
                    CustomTaskDescriptor ctd = rt.getCustomTask(customElementId);
                    if (ctd != null) {
                        ctd.populateObject(object, resource, initializeObject);
                    }
                } else {
                    List<ModelExtensionDescriptor> list = rt.getModelExtensionDescriptors();
                    for (ModelExtensionDescriptor med : list) {
                        if (!className.equals(med.getType())) continue;
                        med.populateObject(object, resource, initializeObject);
                    }
                    for (ModelExtensionDescriptor med : list) {
                        for (EClass st : eClass.getEAllSuperTypes()) {
                            if (!st.getName().equals(med.getType())) continue;
                            med.populateObject(object, resource, initializeObject);
                        }
                    }
                }
                if (initializeObject) {
                    String id = ModelUtil.setID(object, resource);
                    EStructuralFeature feature = object.eClass().getEStructuralFeature("name");
                    if (feature != null && !object.eIsSet(feature)) {
                        if (id != null) {
                            object.eSet(feature, (Object)ModelUtil.toCanonicalString(id));
                        } else {
                            String name = ModelUtil.toCanonicalString(object.eClass().getName());
                            object.eSet(feature, (Object)NLS.bind((String)Messages.Bpmn2ModelerFactory_New_Name, (Object)name));
                        }
                    }
                }
                if ((adapter = ExtendedPropertiesAdapter.adapt(object)) != null) {
                    adapter.setResource(resource);
                }
                rt.notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_CREATED, object, rt));
            }
            catch (Exception e) {
                e.printStackTrace();
                Bpmn2ModelerFactory.unlock();
            }
        }
        finally {
            Bpmn2ModelerFactory.unlock();
        }
        return object;
    }

    public static void setEnableModelExtensions(boolean enable) {
        enableModelExtensions = enable;
    }

    public static boolean getEnableModelExtensions() {
        return enableModelExtensions;
    }

    public static <T extends EObject> T createObject(Resource resource, Class<T> clazz) {
        EClass eClass = Bpmn2ModelerFactory.getEClass(resource, clazz);
        EObject newObject = null;
        if (eClass != null) {
            newObject = Bpmn2ModelerFactory.createObject(resource, eClass, new KeyValue[0]);
        } else {
            EClassifier eClassifier = BpmnDiPackage.eINSTANCE.getEClassifier(clazz.getSimpleName());
            if (eClassifier instanceof EClass) {
                newObject = BpmnDiFactory.eINSTANCE.create((EClass)eClassifier);
            }
        }
        return (T)newObject;
    }

    public static EObject createObject(Resource resource, EClass eClass, KeyValue ... args) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (args != null) {
            KeyValue[] keyValueArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                KeyValue kv = keyValueArray[n2];
                if (kv.getValue() != null) {
                    map.put(kv.getKey(), kv.getValue());
                }
                ++n2;
            }
        }
        return Bpmn2ModelerFactory.createObject(resource, eClass, map);
    }

    public static EObject createObject(Resource resource, EClass eClass, Map<String, Object> args) {
        Assert.isTrue((eClass != null ? 1 : 0) != 0);
        EObject newObject = null;
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(resource, eClass);
        if (adapter != null) {
            newObject = (EObject)adapter.getObjectDescriptor().createObject(resource, eClass, args);
        } else {
            EPackage pkg = eClass.getEPackage();
            if (!Bpmn2ModelerFactory.isBpmnPackage(pkg)) {
                newObject = pkg.getEFactoryInstance().create(eClass);
            }
        }
        if (newObject != null) {
            TargetRuntime rt = TargetRuntime.getRuntime(newObject);
            rt.notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_CREATED, newObject, rt));
        }
        return newObject;
    }

    public static void setResource(Resource r) {
        resource = r;
    }

    public static <T extends EObject> T createFeature(Resource resource, EObject object, String featureName, Class<T> clazz) {
        return Bpmn2ModelerFactory.createFeature(resource, object, object.eClass().getEStructuralFeature(featureName), clazz);
    }

    public static <T extends EObject> T createFeature(Resource resource, EObject object, EStructuralFeature feature, Class<T> clazz) {
        Assert.isTrue((boolean)feature.getEType().getInstanceClass().isAssignableFrom(clazz));
        EClass eClass = Bpmn2ModelerFactory.getEClass(resource, clazz);
        return (T)Bpmn2ModelerFactory.createFeature(resource, object, feature, eClass);
    }

    public static EObject createFeature(Resource resource, EObject object, EStructuralFeature feature, EClass eClass) {
        ExtendedPropertiesAdapter adapter;
        if (eClass == null) {
            eClass = (EClass)feature.getEType();
        }
        Assert.isTrue((boolean)feature.getEType().getInstanceClass().isAssignableFrom(eClass.getInstanceClass()));
        EObject newObject = null;
        if (resource == null) {
            resource = object.eResource();
        }
        if ((adapter = ExtendedPropertiesAdapter.adapt(object)) != null) {
            newObject = adapter.getFeatureDescriptor(feature).createFeature(resource, eClass);
        } else {
            EPackage pkg = eClass.getEPackage();
            if (!Bpmn2ModelerFactory.isBpmnPackage(pkg)) {
                newObject = pkg.getEFactoryInstance().create(eClass);
            }
        }
        if (newObject != null) {
            TargetRuntime rt = TargetRuntime.getRuntime(newObject);
            rt.notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_CREATED, newObject, rt));
        }
        return newObject;
    }

    private static EClass getEClass(Resource resource, Class clazz) {
        EPackage pkg;
        EClassifier eClassifier;
        TargetRuntime rt;
        String nsURI = null;
        if (resource != null && (rt = TargetRuntimeAdapter.getTargetRuntime((Notifier)resource)) != null) {
            nsURI = rt.getRuntimeExtension().getTargetNamespace(null);
        }
        if ((eClassifier = ModelDecorator.findEClassifier(pkg = ModelDecorator.getEPackage(nsURI), clazz.getSimpleName())) instanceof EClass) {
            return (EClass)eClassifier;
        }
        return null;
    }

    public static boolean isBpmnPackage(EPackage pkg) {
        return pkg == Bpmn2Package.eINSTANCE || pkg == BpmnDiPackage.eINSTANCE || pkg == DcPackage.eINSTANCE || pkg == DiPackage.eINSTANCE;
    }

    public static boolean isBpmnPackage(String nsURI) {
        if (nsURI == null || nsURI.isEmpty()) {
            return true;
        }
        if (!nsURI.endsWith("-XMI")) {
            nsURI = String.valueOf(nsURI) + "-XMI";
        }
        return Bpmn2Package.eINSTANCE.getNsURI().equals(nsURI) || BpmnDiPackage.eINSTANCE.getNsURI().equals(nsURI) || DcPackage.eINSTANCE.getNsURI().equals(nsURI) || DiPackage.eINSTANCE.getNsURI().equals(nsURI);
    }

    public class Bpmn2ModelerDocumentRootImpl
    extends DocumentRootImpl {
        private boolean deliver = true;

        public void setDeliver(boolean deliver) {
            this.deliver = deliver;
        }

        public Map<String, String> getXMLNSPrefixMap() {
            if (this.xMLNSPrefixMap == null) {
                this.xMLNSPrefixMap = new EcoreEMap<String, String>(EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY, EStringToStringMapEntryImpl.class, (InternalEObject)this, 1){
                    {
                        this.initializeDelegateEList();
                    }

                    protected void initializeDelegateEList() {
                        this.delegateEList = new EcoreEMap.DelegateEObjectContainmentEList<BasicEMap.Entry<String, String>>((EcoreEMap)this, this.entryClass, (InternalEObject)Bpmn2ModelerDocumentRootImpl.this, 1){

                            protected void dispatchNotification(Notification notification) {
                                if (Bpmn2ModelerDocumentRootImpl.this.deliver) {
                                    super.dispatchNotification(notification);
                                }
                            }
                        };
                    }
                };
            }
            return this.xMLNSPrefixMap.map();
        }
    }

    public static class KeyValue
    implements Map.Entry<String, Object> {
        private String key;
        private Object value;

        public KeyValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            this.value = value;
            return value;
        }
    }
}

