/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextAndButtonObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.SyntaxCheckerUtils;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;

public class IDEditor
extends TextAndButtonObjectEditor {
    Definitions definitions = null;

    public IDEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
        this.definitions = ModelUtil.getDefinitions(object);
    }

    @Override
    protected void buttonClicked(int buttonId) {
        String text = this.getText();
        IInputValidator validator = new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.isEmpty()) {
                    return Messages.IDEditor_ID_is_Null;
                }
                if (!SyntaxCheckerUtils.isQName(newText)) {
                    return Messages.IDEditor_ID_is_Invalid;
                }
                TreeIterator iter = IDEditor.this.definitions.eAllContents();
                while (iter.hasNext()) {
                    String id;
                    EStructuralFeature f;
                    EObject o = (EObject)iter.next();
                    if (o == IDEditor.this.object || (f = o.eClass().getEStructuralFeature("id")) == null || !(o.eGet(f) instanceof String) || !newText.equals(id = (String)o.eGet(f))) continue;
                    return NLS.bind((String)Messages.IDEditor_Duplicate_ID, (Object)IDEditor.this.getObjectName(o));
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.parent.getShell(), Messages.IDEditor_Edit_ID, NLS.bind((String)Messages.IDEditor_Enter_New_ID_for, (Object)this.getObjectName(this.object)), text, validator);
        if (dialog.open() == 0) {
            this.setValue(dialog.getValue());
        }
    }

    private String getObjectName(EObject o) {
        return String.valueOf(ModelUtil.getLabel(o)) + " \"" + ModelUtil.getDisplayName(o) + "\"";
    }
}

