/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.refactoring.IJavaElementMapper;
import org.eclipse.jdt.core.refactoring.RenameTypeArguments;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.DeleteBreakpointChange;
import org.eclipse.jdt.internal.debug.core.refactoring.WatchpointTypeChange;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class WatchpointTypeRenameChange
extends WatchpointTypeChange {
    private RefactoringProcessor fProcessor;
    private RenameTypeArguments fArguments;

    public WatchpointTypeRenameChange(IJavaWatchpoint watchpoint, IType destType, IType originalType, RefactoringProcessor processor, RenameTypeArguments arguments) throws CoreException {
        super(watchpoint, destType, originalType);
        this.fProcessor = processor;
        this.fArguments = arguments;
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        IJavaElement[] similarDeclarations;
        IField originalField = this.getOriginalType().getField(this.getFieldName());
        IField destinationField = null;
        if (this.fArguments.getUpdateSimilarDeclarations() && (similarDeclarations = this.fArguments.getSimilarDeclarations()) != null) {
            int i = 0;
            while (i < similarDeclarations.length) {
                IJavaElement element = similarDeclarations[i];
                if (element.equals(originalField)) {
                    IJavaElementMapper elementMapper = (IJavaElementMapper)this.fProcessor.getAdapter(IJavaElementMapper.class);
                    destinationField = (IField)elementMapper.getRefactoredJavaElement((IJavaElement)originalField);
                    break;
                }
                ++i;
            }
        }
        if (destinationField == null) {
            destinationField = this.getDestinationType().getField(this.getFieldName());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        BreakpointUtils.addJavaBreakpointAttributes(map, (IJavaElement)destinationField);
        map.put("workingset_name", this.getOriginalWorkingSets());
        IResource resource = BreakpointUtils.getBreakpointResource((IMember)destinationField);
        int[] range = this.getNewLineNumberAndRange((IMember)destinationField);
        IJavaWatchpoint breakpoint = JDIDebugModel.createWatchpoint((IResource)resource, (String)this.getDestinationType().getFullyQualifiedName(), (String)destinationField.getElementName(), (int)-1, (int)range[1], (int)range[2], (int)this.getHitCount(), (boolean)true, map);
        this.apply(breakpoint);
        this.getOriginalBreakpoint().delete();
        return new DeleteBreakpointChange((IJavaBreakpoint)breakpoint);
    }
}

