/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpoints;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class DisableAllBreakpointsAction
extends AbstractRemoveAllActionDelegate
implements IBreakpointsListener {
    @Override
    protected boolean isEnabled() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints().length > 0;
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
        this.update();
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        this.update();
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.getAction() != null) {
            this.update();
        }
    }

    @Override
    protected void initialize() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    @Override
    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        super.dispose();
    }

    public void run(IAction action) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        final IBreakpoint[] breakpoints = breakpointManager.getBreakpoints();
        if (breakpoints.length < 1) {
            return;
        }
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean prompt = store.getBoolean("org.eclipse.debug.ui.disable_all_breakpoints_prompt");
        boolean proceed = true;
        if (prompt) {
            MessageDialogWithToggle mdwt = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)ActionMessages.DisableAllBreakPointsAction_0, (String)ActionMessages.DisableAllBreakPointsAction_1, (String)ActionMessages.DisableAllBreakPointsAction_2, (!prompt ? 1 : 0) != 0, null, null);
            if (mdwt.getReturnCode() != 2) {
                proceed = false;
            } else {
                store.setValue("org.eclipse.debug.ui.disable_all_breakpoints_prompt", !mdwt.getToggleState());
            }
        }
        if (proceed) {
            new Job(ActionMessages.DisableAllBreakPointsAction_1){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IBreakpoint[] iBreakpointArray = breakpoints;
                        int n = breakpoints.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBreakpoint breakpoint = iBreakpointArray[n2];
                            breakpoint.setEnabled(false);
                            ++n2;
                        }
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log(e);
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

