/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import java.net.URISyntaxException;
import org.eclipse.birt.report.designer.data.ui.dataset.PropertyPageWrapper;
import org.eclipse.birt.report.designer.data.ui.datasource.DataSourceEditorHelper;
import org.eclipse.birt.report.designer.data.ui.datasource.PropertyBindingPage;
import org.eclipse.birt.report.designer.data.ui.property.AbstractPropertyDialog;
import org.eclipse.birt.report.designer.data.ui.property.PropertyNode;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPage;
import org.eclipse.birt.report.designer.ui.dialogs.properties.IPropertyPageContainer;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSourceDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class DataSourceEditor
extends AbstractPropertyDialog
implements IPreferencePageContainer {
    protected DataSourceDesignSession m_designSession = null;
    protected OdaDataSourceHandle dataSourceHandle = null;

    protected boolean needRememberLastSize() {
        return true;
    }

    public DataSourceEditor(Shell parentShell, DataSourceHandle ds) {
        super(parentShell, (Object)ds);
        if (ds instanceof OdaDataSourceHandle) {
            this.dataSourceHandle = (OdaDataSourceHandle)ds;
            assert (this.dataSourceHandle != null);
            String dataSourceType = this.dataSourceHandle.getExtensionID();
            this.addPagesToOdaDataSource(dataSourceType);
        } else {
            IPropertyPage[] pages = DataSourceEditorHelper.getExternalPages(ds);
            int i = 0;
            while (i < pages.length) {
                this.addPageTo("/", pages[i].getName(), pages[i].getName(), null, pages[i]);
                ++i;
            }
        }
    }

    protected void addPagesToOdaDataSource(String dataSourceType) {
        if (DesignSessionUtil.hasValidOdaDesignUIExtension((String)dataSourceType)) {
            this.addCustomPageODAV3(this.dataSourceHandle);
            if (this.supportsPropertyBindingPage()) {
                this.addPageTo("/", "org.eclipse.birt.datasource.editor.property", Messages.getString((String)"datasource.editor.property"), null, (IPropertyPage)new PropertyBindingPage());
            }
        } else {
            IConfigurationElement element = DataSetProvider.findDataSourceElement((String)dataSourceType);
            if (element != null) {
                this.addCustomPageODAV2(element);
            }
        }
    }

    protected boolean supportsPropertyBindingPage() {
        return true;
    }

    private void addCustomPageODAV3(OdaDataSourceHandle dataSourceHandle) {
        try {
            DesignSessionRequest designSessionRequest = DTPUtil.getInstance().createDesignSessionRequest(dataSourceHandle);
            this.m_designSession = DataSourceDesignSession.startEditDesign((DesignSessionRequest)designSessionRequest);
            PropertyPageWrapper customPage = new PropertyPageWrapper(this.m_designSession.getEditorPage(), this.m_designSession);
            DataSourceDesign dataSourceDesign = designSessionRequest.getDataSourceDesign();
            this.addPageTo("/", dataSourceDesign.getName(), customPage.getPropertyPage().getTitle(), null, (IPropertyPage)customPage);
            PropertyPageWrapper profileSelectionPage = new PropertyPageWrapper(this.m_designSession.getProfileSelectionPropertyPage(), this.m_designSession);
            String profilePageNodeId = profileSelectionPage.getPropertyPage().getClass().getName();
            this.addPageTo("/", profilePageNodeId, profileSelectionPage.getPropertyPage().getTitle(), null, (IPropertyPage)profileSelectionPage);
            boolean isProfileValid = this.m_designSession.setAndVerifyUseProfileSelectionPage();
            if (!isProfileValid) {
                this.setDefaultNode(profilePageNodeId);
            }
        }
        catch (URISyntaxException | OdaException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void addCustomPageODAV2(IConfigurationElement element) {
        try {
            IConfigurationElement[] editorPages = element.getChildren("dataSourceEditorPage");
            if (editorPages != null && editorPages.length > 0 && editorPages != null) {
                int n = 0;
                while (n < editorPages.length) {
                    IPropertyPage page = (IPropertyPage)editorPages[n].createExecutableExtension("class");
                    this.addPageTo(editorPages[n].getAttribute("path"), editorPages[n].getAttribute("name"), editorPages[n].getAttribute("displayName"), null, page);
                    ++n;
                }
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void updateDesignSession() throws OdaException {
        DesignSessionRequest designSessionRequest;
        if (this.m_designSession != null) {
            this.m_designSession.finish();
        }
        try {
            designSessionRequest = DTPUtil.getInstance().createDesignSessionRequest((OdaDataSourceHandle)this.getModel());
        }
        catch (URISyntaxException e) {
            throw new OdaException((Throwable)e);
        }
        this.m_designSession = DataSourceDesignSession.startEditDesign((DesignSessionRequest)designSessionRequest);
        boolean externalWithProfile = true;
        this.populateDataSourceEditorPage(externalWithProfile);
    }

    private void populateDataSourceEditorPage(boolean linkedToProfile) throws OdaException {
        DataSourceEditorPage dataSourceEditorPages;
        if (this.m_designSession == null) {
            return;
        }
        try {
            dataSourceEditorPages = (DataSourceEditorPage)this.m_designSession.getEditorPage();
        }
        catch (OdaException e) {
            return;
        }
        PropertyPageWrapper propertyPageWrapper = new PropertyPageWrapper((PropertyPage)dataSourceEditorPages, this.m_designSession);
        if (this.rootNode.hasSubNodes()) {
            PropertyNode[] nodes = this.rootNode.getSubNodes();
            nodes[0].setPage((IPropertyPage)propertyPageWrapper);
            nodes[0].setContainer((IPropertyPageContainer)this);
            nodes[0].createPageControl(this.getPropertyPane());
        }
        PropertyPageWrapper profileSelectionPage = new PropertyPageWrapper(this.m_designSession.getProfileSelectionPropertyPage(), this.m_designSession);
        this.m_designSession.setUseProfileSelectionPage(linkedToProfile);
        PropertyNode[] nodes = this.rootNode.getSubNodes();
        if (nodes != null && nodes.length >= 2) {
            nodes[1].setPage((IPropertyPage)profileSelectionPage);
            nodes[1].setContainer((IPropertyPageContainer)this);
            nodes[1].createPageControl(this.getPropertyPane());
        }
    }

    public boolean performOk() {
        if (this.m_designSession != null) {
            try {
                DataSourceDesign requestDesign = this.m_designSession.getRequest().getDataSourceDesign();
                DTPUtil.getInstance().updateDataSourceHandle(this.m_designSession.finish().getResponse(), requestDesign, this.dataSourceHandle);
            }
            catch (OdaException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        return true;
    }

    public boolean performCancel() {
        if (this.m_designSession != null) {
            this.m_designSession.cancel();
        }
        return true;
    }

    protected Control createContents(Composite parent) {
        String title = Messages.getFormattedString((String)"datasource.edit", (Object[])new String[]{((DataSourceHandle)this.getModel()).getName()});
        this.getShell().setText(title);
        Control control = super.createContents(parent);
        Utility.setSystemHelp((Control)control, (String)"org.eclipse.birt.cshelp.Dialog_DatasourceEdit_ID");
        return control;
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateButtons() {
        PropertyPage propertyPage;
        if (this.getOkButton() != null && (propertyPage = this.getCurrentPropertyPage()) != null) {
            this.getOkButton().setEnabled(propertyPage.isValid());
        }
    }

    public void updateMessage() {
        PropertyPage propertyPage = this.getCurrentPropertyPage();
        if (propertyPage != null) {
            String errMessage;
            String message = propertyPage.getMessage();
            int messageType = propertyPage.getMessageType();
            if (messageType < 3 && (errMessage = propertyPage.getErrorMessage()) != null) {
                message = errMessage;
                messageType = 3;
            }
            this.setMessage(message, messageType);
        }
    }

    private PropertyPage getCurrentPropertyPage() {
        if (this.getCurrentNode() == null) {
            return null;
        }
        IPropertyPage currentPage = this.getCurrentNode().getPage();
        if (!(currentPage instanceof PropertyPageWrapper)) {
            return null;
        }
        return ((PropertyPageWrapper)currentPage).getPropertyPage();
    }

    public void updateTitle() {
    }

    protected Control createButtonBar(Composite parent) {
        Control container = super.createButtonBar(parent);
        this.updateButtons();
        return container;
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.DataSourceEditor_ID");
        return super.createDialogArea(parent);
    }
}

