/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import java.io.File;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.ClassFoldersSelectionDialog;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.JarsSelectionDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ClassPathEditor {
    private Text txtClassPaths;

    public ClassPathEditor(Composite parent, Object layoutData, final File topDirForRelativePath, int index) {
        final Composite topComposite = new Composite(parent, 0);
        topComposite.setLayoutData(layoutData);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        this.txtClassPaths = new Text(topComposite, 2882);
        GridData gd = new GridData(1808);
        gd.widthHint = 150;
        this.txtClassPaths.setLayoutData((Object)gd);
        Composite buttonComposite = new Composite(topComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(2));
        buttonComposite.setLayout((Layout)new FillLayout(512));
        Button addJarsButton = new Button(buttonComposite, 0);
        addJarsButton.setText(Messages.getString("DataSource.AddRelativeJars" + index));
        addJarsButton.setToolTipText(Messages.getString("DataSource.button.tooltip.AddRelativeJars"));
        addJarsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] paths;
                JarsSelectionDialog jsd = new JarsSelectionDialog(topComposite.getShell(), topDirForRelativePath);
                jsd.open();
                String[] stringArray = paths = jsd.getSelectedItems();
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    ClassPathEditor.this.appendPathSeparator();
                    ClassPathEditor.this.txtClassPaths.append(path);
                    ++n2;
                }
            }
        });
        if (topDirForRelativePath == null) {
            addJarsButton.setEnabled(false);
        }
        Button addClassFoldersButton = new Button(buttonComposite, 0);
        addClassFoldersButton.setText(Messages.getString("DataSource.AddRelativeClassFolder" + index));
        addClassFoldersButton.setToolTipText(Messages.getString("DataSource.button.tooltip.AddRelativeClassFolder"));
        addClassFoldersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] paths;
                ClassFoldersSelectionDialog cfsd = new ClassFoldersSelectionDialog(topComposite.getShell(), topDirForRelativePath);
                cfsd.open();
                String[] stringArray = paths = cfsd.getSelectedItems();
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    ClassPathEditor.this.appendPathSeparator();
                    ClassPathEditor.this.txtClassPaths.append(path);
                    ++n2;
                }
            }
        });
        if (topDirForRelativePath == null) {
            addClassFoldersButton.setEnabled(false);
        }
        addJarsButton = new Button(buttonComposite, 0);
        addJarsButton.setText(Messages.getString("DataSource.AddAbsoluteJars" + index));
        addJarsButton.setToolTipText(Messages.getString("DataSource.button.tooltip.AddAbsoluteJars"));
        addJarsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ClassPathEditor.this.txtClassPaths.getShell(), 2);
                dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
                dialog.open();
                String[] stringArray = dialog.getFileNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    ClassPathEditor.this.appendPathSeparator();
                    ClassPathEditor.this.txtClassPaths.append(String.valueOf(dialog.getFilterPath()) + File.separator);
                    ClassPathEditor.this.txtClassPaths.append(file);
                    ++n2;
                }
            }
        });
        addClassFoldersButton = new Button(buttonComposite, 0);
        addClassFoldersButton.setText(Messages.getString("DataSource.AddAbsoluteClassFolder" + index));
        addClassFoldersButton.setToolTipText(Messages.getString("DataSource.button.tooltip.AddAbsoluteClassFolder"));
        addClassFoldersButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ClassPathEditor.this.txtClassPaths.getShell());
                dialog.open();
                if (dialog.getFilterPath() != null && dialog.getFilterPath().length() > 0) {
                    ClassPathEditor.this.appendPathSeparator();
                    ClassPathEditor.this.txtClassPaths.append(dialog.getFilterPath());
                }
            }
        });
    }

    private void appendPathSeparator() {
        if (this.txtClassPaths.getText().trim().length() == 0) {
            this.txtClassPaths.setText("");
            return;
        }
        if (!this.txtClassPaths.getText().trim().endsWith(String.valueOf(';'))) {
            this.txtClassPaths.append(String.valueOf(';'));
        }
    }

    public void setClassPath(String s) {
        if (s == null) {
            this.txtClassPaths.setText("");
        } else {
            this.txtClassPaths.setText(s.trim());
        }
    }

    public String getClassPath() {
        return this.txtClassPaths.getText().trim();
    }
}

