/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import me.prettyprint.cassandra.service.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CassandraHost {
    private static Logger log = LoggerFactory.getLogger(CassandraHost.class);
    public static final int DEFAULT_PORT = 9160;
    public static final int DEFAULT_MAX_ACTIVE = 50;
    public static final boolean DEFAULT_USE_FRAMED_THRIFT_TRANSPORT = true;
    public static final long DEFAULT_MAX_WAITTIME_WHEN_EXHAUSTED = -1L;
    public static final boolean DEFAULT_LIFO = true;
    private final String host;
    private final String ip;
    private final String url;
    private final int port;
    private final String name;
    private int maxActive = 50;
    private boolean lifo = true;
    private long maxWaitTimeWhenExhausted = -1L;
    private int cassandraThriftSocketTimeout;
    private boolean useThriftFramedTransport = true;
    private boolean useSocketKeepalive;

    public CassandraHost(String url) {
        this(url, CassandraHost.parsePortFromUrl(url));
    }

    public CassandraHost(String url2, int port) {
        String tip;
        String turl;
        url2 = CassandraHost.parseHostFromUrl(url2);
        this.port = port;
        StringBuilder b = new StringBuilder();
        try {
            InetAddress address = InetAddress.getByName(url2);
            turl = this.isPerformNameResolution() ? address.getHostName() : url2;
            tip = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("Unable to resolve host {}", (Object)url2);
            turl = url2;
            tip = url2;
        }
        this.host = turl;
        this.ip = tip;
        b.append(url2);
        b.append("(");
        b.append(this.ip);
        b.append("):");
        b.append(port);
        this.name = b.toString();
        this.url = String.format("%s:%d", this.host, port);
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isPerformNameResolution() {
        String sysprop = System.getProperty(SystemProperties.HECTOR_PERFORM_NAME_RESOLUTION.toString());
        return sysprop != null && Boolean.parseBoolean(sysprop);
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CassandraHost)) {
            return false;
        }
        CassandraHost other = (CassandraHost)obj;
        return other.ip.equals(this.ip) && other.port == this.port;
    }

    public int hashCode() {
        return this.ip.hashCode();
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public long getMaxWaitTimeWhenExhausted() {
        return this.maxWaitTimeWhenExhausted;
    }

    public void setMaxWaitTimeWhenExhausted(long maxWaitTimeWhenExhausted) {
        this.maxWaitTimeWhenExhausted = maxWaitTimeWhenExhausted;
    }

    public int getCassandraThriftSocketTimeout() {
        return this.cassandraThriftSocketTimeout;
    }

    public void setCassandraThriftSocketTimeout(int cassandraThriftSocketTimeout) {
        this.cassandraThriftSocketTimeout = cassandraThriftSocketTimeout;
    }

    public boolean getUseThriftFramedTransport() {
        return this.useThriftFramedTransport;
    }

    public void setUseThriftFramedTransport(boolean useThriftFramedTransport) {
        this.useThriftFramedTransport = useThriftFramedTransport;
    }

    public static String parseHostFromUrl(String urlPort) {
        return urlPort.lastIndexOf(58) > 0 ? urlPort.substring(0, urlPort.lastIndexOf(58)) : urlPort;
    }

    public static int parsePortFromUrl(String urlPort) {
        return urlPort.lastIndexOf(58) > 0 ? Integer.parseInt(urlPort.substring(urlPort.lastIndexOf(58) + 1, urlPort.length())) : 9160;
    }

    public boolean getLifo() {
        return this.lifo;
    }

    public void setLifo(boolean lifo) {
        this.lifo = lifo;
    }

    public boolean getUseSocketKeepalive() {
        return this.useSocketKeepalive;
    }

    public void setUseSocketKeepalive(boolean useSocketKeepalive) {
        this.useSocketKeepalive = useSocketKeepalive;
    }
}

