/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportRootFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.IFixLayoutHelper;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportItemConstraint;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ReportFlowLayout
extends AbstractHintLayout {
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFTTOP = 1;
    public static final int ALIGN_RIGHTBOTTOM = 2;
    private static final Insets INSETS_SINGLETON = new Insets();
    protected boolean fill = false;
    protected int majorAlignment = 1;
    protected int minorAlignment = 1;
    protected int minorSpacing = 5;
    protected int majorSpacing = 5;
    private WorkingData data = null;
    private Hashtable constraints = new Hashtable();
    private String layoutPreference = "auto layout";
    private IFlowLayoutStrategy layoutStrategy = null;

    public String getLayoutPreference() {
        return this.layoutPreference;
    }

    public int getMajorAlignment() {
        return this.majorAlignment;
    }

    public int getMajorSpacing() {
        return this.majorSpacing;
    }

    public int getMinorAlignment() {
        return this.minorAlignment;
    }

    public int getMinorSpacing() {
        return this.minorSpacing;
    }

    protected Insets getFigureMargin(IFigure f) {
        ReportItemConstraint constraint = (ReportItemConstraint)((Object)this.getConstraint(f));
        Insets margin = INSETS_SINGLETON;
        if (constraint != null) {
            margin = constraint.getMargin();
        }
        if ((margin == null || margin == INSETS_SINGLETON) && f instanceof IReportElementFigure) {
            margin = ((IReportElementFigure)f).getMargin();
        }
        return margin;
    }

    private void initRow() {
        this.data.rowX = 0;
        this.data.rowHeight = 0;
        this.data.rowWidth = 0;
    }

    private void initVariables(IFigure parent) {
        this.data.row = new IFigure[parent.getChildren().size()];
        this.data.bounds = new Rectangle[this.data.row.length];
        this.data.margin = new Insets[this.data.row.length];
        this.data.maxWidth = this.data.area.width;
    }

    public void layout(IFigure parent) {
        Rectangle relativeArea;
        this.data = new WorkingData();
        this.data.area = relativeArea = parent.getClientArea().getCopy();
        this.initVariables(parent);
        this.initRow();
        this.getLayoutStrategy().layout(parent, this.data);
        this.data = null;
    }

    private void layoutVertical(IFigure parent) {
        block8: {
            if (this.minorAlignment != 0 && this.minorAlignment != 2) break block8;
            int minTop = 0;
            int maxBottom = 0;
            int i = 0;
            while (i < this.data.bounds.length) {
                if (this.data.bounds[i].y < minTop) {
                    minTop = this.data.bounds[i].y;
                }
                if (this.data.bounds[i].y + this.data.bounds[i].height > maxBottom) {
                    maxBottom = this.data.bounds[i].y + this.data.bounds[i].height;
                }
                ++i;
            }
            if (maxBottom - minTop < this.data.area.height) {
                int adjustment = this.data.area.height - maxBottom + minTop;
                if (this.minorAlignment == 0) {
                    adjustment /= 2;
                }
                int i2 = 0;
                while (i2 < this.data.bounds.length) {
                    Rectangle fbounds = this.data.bounds[i2].getCopy().crop(this.data.margin[i2]);
                    fbounds.y += adjustment;
                    this.setBoundsOfChild(parent, this.data.row[i2], fbounds);
                    ++i2;
                }
            } else {
                i = 0;
                while (i < this.data.bounds.length) {
                    Rectangle fbounds = this.data.bounds[i].getCopy().crop(this.data.margin[i]);
                    this.setBoundsOfChild(parent, this.data.row[i], fbounds);
                    ++i;
                }
            }
        }
    }

    protected void layoutRow(IFigure parent) {
        int minorAdjustment = 0;
        int correctMajorAlignment = this.majorAlignment;
        int majorAdjustment = this.data.area.width - this.data.rowWidth + this.getMinorSpacing();
        if (majorAdjustment < 0) {
            if (parent instanceof ReportRootFigure || !parent.isMirrored()) {
                majorAdjustment = 0;
            }
        } else {
            switch (correctMajorAlignment) {
                case 1: {
                    majorAdjustment = 0;
                    break;
                }
                case 0: {
                    majorAdjustment /= 2;
                    break;
                }
            }
        }
        boolean needVerticalAlign = this.minorAlignment == 0 || this.minorAlignment == 2;
        int j = this.data.rowPos;
        while (j < this.data.rowCount) {
            int correctMinorAlignment = this.getChildVerticalAlign(this.data.row[j]);
            if (this.fill) {
                this.data.bounds[j].height = this.data.rowHeight;
            } else {
                minorAdjustment = this.data.rowHeight - this.data.bounds[j].height;
                switch (correctMinorAlignment) {
                    case 1: {
                        minorAdjustment = 0;
                        break;
                    }
                    case 0: {
                        minorAdjustment /= 2;
                        break;
                    }
                }
                if (minorAdjustment < 0) {
                    minorAdjustment = 0;
                }
                this.data.bounds[j].y += minorAdjustment;
            }
            this.data.bounds[j].x += majorAdjustment;
            Rectangle parentArea = parent.getClientArea().getCopy();
            if (this.data.rowY < parentArea.y + parentArea.height && this.data.rowY + this.data.rowHeight > parentArea.y + parentArea.height) {
                Rectangle rect = this.data.bounds[j].getCopy();
                rect.translate(parentArea.x, parentArea.y);
                int distanceHeight = rect.y + rect.height - parentArea.y - parentArea.height;
                if (distanceHeight > 0) {
                    int topDistnceHeight = rect.y - this.data.rowY - parentArea.y;
                    if (topDistnceHeight > 0) {
                        this.data.bounds[j].y = distanceHeight > topDistnceHeight ? (this.data.bounds[j].y -= topDistnceHeight) : (correctMinorAlignment == 0 ? this.data.bounds[j].y - minorAdjustment + (topDistnceHeight - distanceHeight) / 2 : this.data.bounds[j].y - minorAdjustment + topDistnceHeight - distanceHeight);
                    }
                } else if (correctMinorAlignment == 0) {
                    this.data.bounds[j].y = this.data.bounds[j].y - minorAdjustment + (parentArea.height - this.data.rowY - this.data.bounds[j].height) / 2;
                }
            }
            if (!needVerticalAlign) {
                this.setBoundsOfChild(parent, this.data.row[j], this.data.bounds[j].getCopy().crop(this.data.margin[j]));
            }
            ++j;
        }
        this.data.rowPos = this.data.rowCount;
        this.data.rowY += this.getMajorSpacing() + this.data.rowHeight;
        this.postLayoutRow(this.data);
        this.initRow();
    }

    void postLayoutRow(WorkingData data) {
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    public void setStretchMinorAxis(boolean value) {
        this.fill = value;
    }

    public void setMajorAlignment(int align) {
        this.majorAlignment = align;
    }

    public void setMajorSpacing(int n) {
        this.majorSpacing = n;
    }

    public void setMinorAlignment(int align) {
        this.minorAlignment = align;
    }

    public void setMinorSpacing(int n) {
        this.minorSpacing = n;
    }

    private int getDisplay(IFigure element) {
        ReportItemConstraint constraint = (ReportItemConstraint)((Object)this.getConstraint(element));
        if (constraint != null) {
            return constraint.getDisplay();
        }
        return 2;
    }

    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }

    private void updateChild(IFigure child, int wHint) {
        ReportItemConstraint constraint = (ReportItemConstraint)((Object)this.getConstraint(child));
        if ("fixed layout".equals(this.layoutPreference) && child instanceof IFixLayoutHelper && constraint != null) {
            Dimension dimension = constraint.getSize();
            if (dimension.width <= 0 && constraint.getMeasure() != 0.0 && "%".equals(constraint.getUnits())) {
                int trueWidth = this.getParentClientArea(child);
                int width = (int)constraint.getMeasure() * trueWidth / 100;
                if (child instanceof LabelFigure) {
                    LabelFigure label = (LabelFigure)child;
                    Dimension dim = label.getRecommendSize();
                    label.setRecommendSize(new Dimension(width, dim.height));
                }
            }
        }
    }

    private int getChildVerticalAlign(IFigure child) {
        ReportItemConstraint constraint = (ReportItemConstraint)((Object)this.getConstraint(child));
        if (constraint == null) {
            return 2;
        }
        return constraint.getAlign();
    }

    private int getParentClientArea(IFigure child) {
        int parentWidth = child.getParent().getClientArea().width;
        Insets fmargin = this.getFigureMargin(child);
        return Math.max(0, parentWidth - fmargin.getWidth());
    }

    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        Dimension dimension;
        Dimension preferredDimension;
        this.updateChild(child, wHint);
        ReportItemConstraint constraint = (ReportItemConstraint)((Object)this.getConstraint(child));
        if ("fixed layout".equals(this.layoutPreference) && child instanceof IFixLayoutHelper) {
            preferredDimension = ((IFixLayoutHelper)child).getFixPreferredSize(wHint, hHint);
            if (constraint != null) {
                dimension = constraint.getSize();
                if (dimension.width <= 0 && constraint.getMeasure() != 0.0 && "%".equals(constraint.getUnits())) {
                    int trueWidth = this.getParentClientArea(child);
                    preferredDimension.width = (int)constraint.getMeasure() * trueWidth / 100;
                }
            }
            constraint = null;
        } else {
            preferredDimension = child.getPreferredSize(wHint, hHint);
        }
        if (constraint != null && !constraint.isFitContiner()) {
            if (constraint.isNone()) {
                return new Dimension(0, 0);
            }
            dimension = constraint.getSize();
            if (dimension.height <= 0) {
                dimension.height = preferredDimension.height;
            }
            if (dimension.width <= 0) {
                dimension.width = constraint.getMeasure() != 0.0 && "%".equals(constraint.getUnits()) ? (int)constraint.getMeasure() * wHint / 100 : preferredDimension.width;
            }
            return dimension;
        }
        return preferredDimension;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        int maxWidth = wHint;
        hHint = -1;
        if (maxWidth < 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        Dimension prefSize = new Dimension();
        List children = container.getChildren();
        int width = 0;
        int height = 0;
        IFigure lastChild = null;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Insets fmargin = this.getFigureMargin(child);
            if (wHint != -1) {
                wHint = Math.max(0, wHint - fmargin.getWidth());
            }
            int caleHint = this.getDisplay(child) != 2 ? -1 : wHint;
            Dimension childSize = this.getChildSize(child, caleHint, hHint);
            if (i == 0) {
                width = childSize.width + fmargin.getWidth();
                height = childSize.height + fmargin.getHeight();
            } else if (this.getDisplay(child) != 0) {
                if (width + childSize.width + fmargin.getWidth() + this.getMinorSpacing() <= maxWidth && this.getDisplay(child) == 1 && this.getDisplay(lastChild) == 1) {
                    width += childSize.width + fmargin.getWidth() + this.getMinorSpacing();
                    height = Math.max(height, childSize.height + fmargin.getHeight());
                } else {
                    prefSize.height += height + this.getMajorSpacing();
                    prefSize.width = Math.max(prefSize.width, width);
                    width = childSize.width + fmargin.getWidth();
                    height = childSize.height + fmargin.getHeight();
                }
            }
            lastChild = child;
            ++i;
        }
        prefSize.height += height;
        prefSize.width = Math.max(prefSize.width, width);
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        int maxWidth = wHint;
        hHint = -1;
        if (maxWidth < 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        Dimension prefSize = new Dimension();
        List children = container.getChildren();
        int width = 0;
        int height = 0;
        IFigure lastChild = null;
        int i = 0;
        while (i < children.size()) {
            Dimension childSize;
            int display;
            IFigure child = (IFigure)children.get(i);
            Insets fmargin = this.getFigureMargin(child);
            if (wHint != -1) {
                wHint = Math.max(0, wHint - fmargin.getWidth());
            }
            if ("fixed layout".equals(this.layoutPreference) && child instanceof IFixLayoutHelper) {
                this.updateChild(child, wHint);
                display = this.getDisplay(child);
                if (display == 1 && child instanceof LabelFigure && lastChild != null && this.getDisplay(lastChild) == 1) {
                    childSize = ((IFixLayoutHelper)child).getFixMinimumSize(wHint - width - this.getMinorSpacing() <= 0 ? -1 : wHint - width - this.getMinorSpacing(), hHint);
                    if (childSize.width == wHint - width - this.getMinorSpacing()) {
                        childSize = ((IFixLayoutHelper)child).getFixMinimumSize(-1, hHint);
                    }
                } else {
                    childSize = display == 1 ? ((IFixLayoutHelper)child).getFixMinimumSize(-1, hHint) : ((IFixLayoutHelper)child).getFixMinimumSize(wHint, hHint);
                }
            } else {
                childSize = child.getMinimumSize(wHint, hHint);
            }
            if (i == 0) {
                width = childSize.width + fmargin.getWidth();
                height = childSize.height + fmargin.getHeight();
            } else if (this.getDisplay(child) != 0) {
                if (width + childSize.width + fmargin.getWidth() + this.getMinorSpacing() <= maxWidth && this.getDisplay(child) == 1 && this.getDisplay(lastChild) == 1) {
                    width += childSize.width + fmargin.getWidth() + this.getMinorSpacing();
                    height = Math.max(height, childSize.height + fmargin.getHeight());
                } else {
                    if ("fixed layout".equals(this.layoutPreference) && child instanceof IFixLayoutHelper) {
                        display = this.getDisplay(child);
                        childSize = display == 1 ? ((IFixLayoutHelper)child).getFixMinimumSize(-1, hHint) : ((IFixLayoutHelper)child).getFixMinimumSize(wHint, hHint);
                    }
                    prefSize.height += height + this.getMajorSpacing();
                    prefSize.width = Math.max(prefSize.width, width);
                    width = childSize.width + fmargin.getWidth();
                    height = childSize.height + fmargin.getHeight();
                }
            }
            lastChild = child;
            ++i;
        }
        prefSize.height += height;
        prefSize.width = Math.max(prefSize.width, width);
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    public void setLayoutPreference(String layoutPreference) {
        this.layoutPreference = layoutPreference;
        this.layoutStrategy = null;
    }

    protected IFlowLayoutStrategy createFlowLayoutStrategy() {
        if ("auto layout".equals(this.layoutPreference)) {
            return new AutoLayoutStrategy();
        }
        if ("fixed layout".equals(this.layoutPreference)) {
            return new FixLayoutStrategy();
        }
        throw new RuntimeException("Don't support this flow layout style");
    }

    public IFlowLayoutStrategy getLayoutStrategy() {
        if (this.layoutStrategy == null) {
            this.layoutStrategy = this.createFlowLayoutStrategy();
        }
        return this.layoutStrategy;
    }

    private class AutoLayoutStrategy
    implements IFlowLayoutStrategy {
        private AutoLayoutStrategy() {
        }

        @Override
        public void layout(IFigure parent, WorkingData data) {
            Iterator iterator = parent.getChildren().iterator();
            int i = 0;
            int display = 2;
            int lastDisplay = 2;
            int wHint = parent.getClientArea().width;
            int hHint = -1;
            while (iterator.hasNext()) {
                IFigure f = (IFigure)iterator.next();
                Insets fmargin = ReportFlowLayout.this.getFigureMargin(f);
                wHint = parent.getClientArea().width;
                if (wHint != -1) {
                    wHint = Math.max(0, wHint - fmargin.getWidth());
                }
                Dimension pref = ReportFlowLayout.this.getChildSize(f, wHint, hHint);
                if (f instanceof LabelFigure && pref.width + fmargin.getWidth() > parent.getClientArea().width) {
                    pref = ReportFlowLayout.this.getChildSize(f, Math.max(0, parent.getClientArea().width - fmargin.getWidth()), hHint);
                }
                Rectangle r = new Rectangle(0, 0, pref.width + fmargin.getWidth(), pref.height + fmargin.getHeight());
                display = ReportFlowLayout.this.getDisplay(f);
                if (data.rowCount > data.rowPos && (data.rowWidth + r.width > data.maxWidth || display == 2 || lastDisplay == 2)) {
                    ReportFlowLayout.this.layoutRow(parent);
                }
                lastDisplay = display;
                r.x = data.rowX;
                r.y = data.rowY;
                int dx = r.width + ReportFlowLayout.this.getMinorSpacing();
                data.rowX += dx;
                data.rowWidth += dx;
                data.rowHeight = Math.max(data.rowHeight, r.height);
                data.row[data.rowCount] = f;
                data.margin[data.rowCount] = fmargin;
                data.bounds[data.rowCount] = r;
                ++data.rowCount;
                ++i;
            }
            if (data.rowCount > data.rowPos) {
                ReportFlowLayout.this.layoutRow(parent);
            }
            ReportFlowLayout.this.layoutVertical(parent);
        }
    }

    private class FixLayoutStrategy
    implements IFlowLayoutStrategy {
        private FixLayoutStrategy() {
        }

        @Override
        public void layout(IFigure parent, WorkingData data) {
            Iterator iterator = parent.getChildren().iterator();
            int i = 0;
            int display = 2;
            int lastDisplay = 2;
            int hHint = -1;
            while (iterator.hasNext()) {
                int wHint = parent.getClientArea().width;
                IFigure f = (IFigure)iterator.next();
                Insets fmargin = ReportFlowLayout.this.getFigureMargin(f);
                if (wHint != -1) {
                    wHint = Math.max(0, wHint - fmargin.getWidth());
                }
                Dimension pref = ReportFlowLayout.this.getChildSize(f, wHint, hHint);
                display = ReportFlowLayout.this.getDisplay(f);
                if (display == 1 && f instanceof LabelFigure && lastDisplay == 1) {
                    pref = ReportFlowLayout.this.getChildSize(f, wHint - data.rowWidth <= 0 ? -1 : wHint - data.rowWidth, hHint);
                    if (pref.width == wHint - data.rowWidth) {
                        pref = ReportFlowLayout.this.getChildSize(f, -1, hHint);
                    }
                } else if (display == 1) {
                    pref = ReportFlowLayout.this.getChildSize(f, -1, hHint);
                }
                Rectangle r = new Rectangle(0, 0, pref.width + fmargin.getWidth(), pref.height + fmargin.getHeight());
                if (data.rowCount > data.rowPos && (data.rowWidth + r.width > data.maxWidth || display == 2 || lastDisplay == 2)) {
                    ReportFlowLayout.this.layoutRow(parent);
                }
                lastDisplay = display;
                r.x = data.rowX;
                r.y = data.rowY;
                int dx = r.width + ReportFlowLayout.this.getMinorSpacing();
                data.rowX += dx;
                data.rowWidth += dx;
                data.rowHeight = Math.max(data.rowHeight, r.height);
                data.row[data.rowCount] = f;
                data.margin[data.rowCount] = fmargin;
                data.bounds[data.rowCount] = r;
                ++data.rowCount;
                ++i;
            }
            if (data.rowCount > data.rowPos) {
                ReportFlowLayout.this.layoutRow(parent);
            }
            ReportFlowLayout.this.layoutVertical(parent);
        }
    }

    public static interface IFlowLayoutStrategy {
        public void layout(IFigure var1, WorkingData var2);
    }

    public static class WorkingData {
        int rowHeight;
        int rowWidth;
        int rowCount;
        int rowX;
        int rowY;
        int maxWidth;
        int rowPos;
        Rectangle[] bounds;
        Rectangle area;
        Insets[] margin;
        IFigure[] row;
    }
}

