/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.extension;

import org.eclipse.birt.report.designer.ui.editors.IReportEditorPage;
import org.eclipse.birt.report.designer.ui.editors.actions.PageSetAction;
import org.eclipse.birt.report.designer.ui.editors.extension.IExtensionConstants;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorActionBarContributor;

public class FormPageDef
implements IExtensionConstants {
    private IConfigurationElement element;
    public String id;
    public String targetEditor;
    public String displayName;
    public String pageClass;
    public boolean visible = true;
    public String relative;
    public int position;
    public IAction pageAction;
    public int priority;

    FormPageDef(IConfigurationElement element) {
        this.element = element;
        this.id = this.loadStringAttribute(element, "id");
        this.displayName = this.loadStringAttribute(element, "displayName");
        this.pageClass = this.loadStringAttribute(element, "class");
        this.visible = this.loadBooleanAttribute(element, "visible");
        this.relative = this.loadStringAttribute(element, "relative");
        this.position = this.loadPosition(element, "position");
        this.priority = this.loadPriority(element, "priority");
        if (this.loadStringAttribute(element, "pageAction") != null) {
            this.pageAction = (IAction)this.loadClass(element, "pageAction");
        }
        if (this.pageAction == null) {
            this.pageAction = new PageSetAction(this.displayName, this.id);
        }
    }

    private int loadPriority(IConfigurationElement element, String attributeName) {
        String attribute = element.getAttribute(attributeName);
        if ("normal".equals(attribute)) {
            return 1;
        }
        if ("high".equals(attribute)) {
            return 2;
        }
        if ("low".equals(attribute)) {
            return 0;
        }
        return 1;
    }

    private int loadPosition(IConfigurationElement element, String attributeName) {
        String attribute = element.getAttribute(attributeName);
        if ("left".equals(attribute)) {
            return 0;
        }
        if ("right".equals(attribute)) {
            return 1;
        }
        return 1;
    }

    private String loadStringAttribute(IConfigurationElement element, String attributeName) {
        return element.getAttribute(attributeName);
    }

    private boolean loadBooleanAttribute(IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return true;
    }

    private Object loadClass(IConfigurationElement element, String attributeName) {
        Object clazz = null;
        try {
            if (element.getAttribute(attributeName) != null) {
                clazz = element.createExecutableExtension(attributeName);
            }
        }
        catch (CoreException e) {
            ExceptionUtil.handle((Throwable)e);
        }
        return clazz;
    }

    public IReportEditorPage createPage() {
        Object def = this.loadClass(this.element, "class");
        if (def instanceof IReportEditorPage) {
            return (IReportEditorPage)def;
        }
        return null;
    }

    public IEditorActionBarContributor createActionBarContributor() {
        Object def = this.loadClass(this.element, "actionBarContributor");
        if (def instanceof IEditorActionBarContributor) {
            return (IEditorActionBarContributor)def;
        }
        return null;
    }
}

