/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.generator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapter;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JImport;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.properties.PropertyMerger;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.codegen.util.GIFEmitter;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.impl.SingletonAdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ContentHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGeneratorAdapter
extends SingletonAdapterImpl
implements GeneratorAdapter {
    protected static final String MANIFEST_ENCODING = "UTF-8";
    protected static final String PROPERTIES_ENCODING = "ISO-8859-1";
    protected GeneratorAdapterFactory adapterFactory;
    protected Object generatingObject;
    protected String message;
    protected JETEmitter[] jetEmitters;
    protected GIFEmitter[] gifEmitters;
    protected ImportManager importManager;
    protected String lineDelimiter;
    protected URIConverter uriConverter;
    protected static final Class<?>[] OBJECT_ARGUMENT = new Class[]{Object.class};
    protected static final Pattern EXTENSION_POINT_PATTERN = Pattern.compile("[ \t]*<extension[^>]+point\\s*=['\"]([^'\"]+)['\"].*?(?<!<category\\s{1,40})(?:id|class)\\s*=\\s*['\"]([^'\"]+)['\"].*?</extension>[ \t]*(\n\r|\r\n|\n|\r)", 32);
    protected static final Pattern GENERATED_PATTERN = Pattern.compile("<!-- *@generated *([^ ]+) *-->");
    protected static final Pattern PLUGIN_END_TAG_PATTERN = Pattern.compile(".*(\n\r|\r\n|\n|\r)?[ \t]*(</plugin>)");
    protected static final Pattern BLANK_LINES_PATTERN = Pattern.compile("([ \t]*(\n\r|\r\n|\n|\r))+");
    protected static final Pattern VERSION_PATTERN = Pattern.compile("Manifest-Version: *([0-9]+(?:\\.[0-9]+)*) *(\r\n|\n\r|\n|\r)?");
    protected static final Pattern HEADER_PATTERN = Pattern.compile("([A-Za-z0-9][-_A-Za-z0-9]*): *([^\n\r]*)(\r\n|\n\r|\n|\r)?");
    protected static final Pattern CONTINUATION_PATTERN = Pattern.compile(" ([^\n\r]*)(\r\n|\n\r|\n|\r)?");

    public AbstractGeneratorAdapter() {
    }

    public AbstractGeneratorAdapter(GeneratorAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    @Override
    public GeneratorAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public void setAdapterFactory(GeneratorAdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public boolean isAdapterForType(Object type) {
        return type == this.adapterFactory;
    }

    @Override
    public Collection<?> getCanGenerateChildren(Object object, Object projectType) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object getCanGenerateParent(Object object, Object projectType) {
        return null;
    }

    @Override
    public abstract boolean canGenerate(Object var1, Object var2);

    @Override
    public Collection<?> getGenerateChildren(Object object, Object projectType) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Object getGenerateParent(Object object, Object projectType) {
        return null;
    }

    @Override
    public final Diagnostic preGenerate(Object object, Object projectType) {
        try {
            this.generatingObject = object;
            if (this.getGenerator().getOptions().dynamicTemplates) {
                this.jetEmitters = null;
                this.gifEmitters = null;
            }
            Diagnostic diagnostic = this.doPreGenerate(object, projectType);
            return diagnostic;
        }
        finally {
            this.generatingObject = null;
        }
    }

    protected Diagnostic doPreGenerate(Object object, Object projectType) {
        return Diagnostic.OK_INSTANCE;
    }

    @Override
    public final Diagnostic generate(Object object, Object projectType, Monitor monitor) {
        try {
            if (this.canGenerate(object, projectType)) {
                this.generatingObject = object;
                this.message = null;
                Diagnostic diagnostic = this.doGenerate(object, projectType, monitor);
                return diagnostic;
            }
            Diagnostic diagnostic = Diagnostic.OK_INSTANCE;
            return diagnostic;
        }
        catch (Exception exception) {
            Diagnostic diagnostic = this.toDiagnostic(exception, this.message);
            return diagnostic;
        }
        finally {
            this.generatingObject = null;
            this.message = null;
            monitor.done();
        }
    }

    protected abstract Diagnostic doGenerate(Object var1, Object var2, Monitor var3) throws Exception;

    @Override
    public final Diagnostic postGenerate(Object object, Object projectType) {
        try {
            this.generatingObject = object;
            if (this.getGenerator().getOptions().dynamicTemplates) {
                this.jetEmitters = null;
                this.gifEmitters = null;
            }
            Diagnostic diagnostic = this.doPostGenerate(object, projectType);
            return diagnostic;
        }
        finally {
            this.generatingObject = null;
        }
    }

    protected Diagnostic doPostGenerate(Object object, Object projectType) {
        return Diagnostic.OK_INSTANCE;
    }

    protected Diagnostic toDiagnostic(Exception exception, String currentMessage) {
        if (!(exception instanceof OperationCanceledException)) {
            CodeGenEcorePlugin.INSTANCE.log(exception);
        }
        currentMessage = currentMessage != null ? CodeGenEcorePlugin.INSTANCE.getString("_UI_GenerateException_diagnostic", new Object[]{currentMessage}) : CodeGenEcorePlugin.INSTANCE.getString("_UI_GenericGenerateException_diagnostic");
        BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.codegen.ecore", 0, currentMessage, null);
        diagnostic.add(BasicDiagnostic.toDiagnostic((Throwable)exception));
        return diagnostic;
    }

    protected org.eclipse.emf.codegen.ecore.generator.Generator getGenerator() {
        return this.getAdapterFactory().getGenerator();
    }

    protected JETEmitter getJETEmitter(JETEmitterDescriptor[] jetEmitterDescriptors, int id) {
        JETEmitter jetEmitter;
        if (this.jetEmitters == null) {
            this.jetEmitters = new JETEmitter[jetEmitterDescriptors.length];
        }
        if ((jetEmitter = this.jetEmitters[id]) == null) {
            this.jetEmitters[id] = jetEmitter = this.createJETEmitter(jetEmitterDescriptors[id]);
        }
        return jetEmitter;
    }

    protected JETEmitter createJETEmitter(JETEmitterDescriptor jetEmitterDescriptor) {
        JETEmitter jetEmitter = new JETEmitter(this.getTemplatePath(), jetEmitterDescriptor.templatePathName, this.getClass().getClassLoader());
        try {
            this.setStaticTemplateClass(jetEmitter, jetEmitterDescriptor.className);
            this.addClasspathEntries(jetEmitter);
        }
        catch (JETException exception) {
            CodeGenEcorePlugin.INSTANCE.log((Object)exception);
        }
        return jetEmitter;
    }

    private String[] getTemplatePath() {
        String[] legacyPath = this.getGenerator().getOptions().templatePath;
        if (legacyPath != null) {
            return legacyPath;
        }
        ArrayList<String> result = new ArrayList<String>(this.getUserTemplatePath());
        result.addAll(this.getBaseTemplatePath());
        return result.toArray(new String[result.size()]);
    }

    protected List<String> getUserTemplatePath() {
        return Collections.emptyList();
    }

    private List<String> getBaseTemplatePath() {
        ArrayList<String> result = new ArrayList<String>();
        this.addBaseTemplatePathEntries(result);
        return result;
    }

    protected void addBaseTemplatePathEntries(List<String> templatePath) {
    }

    protected void setStaticTemplateClass(JETEmitter jetEmitter, String className) {
        this.setStaticTemplateClass(jetEmitter, className, "generate", OBJECT_ARGUMENT);
    }

    protected void setStaticTemplateClass(JETEmitter jetEmitter, String className, String methodName, Class<?>[] arguments) {
        if (!this.getGenerator().getOptions().dynamicTemplates) {
            try {
                Class<?> templateClass = this.getClass().getClassLoader().loadClass(className);
                Method emitterMethod = templateClass.getDeclaredMethod(methodName, arguments);
                jetEmitter.setMethod(emitterMethod);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void addClasspathEntries(JETEmitter jetEmitter) throws JETException {
        if (this.getGenerator().getOptions().templateClasspath != null) {
            for (String additionalClasspathEntry : this.getGenerator().getOptions().templateClasspath) {
                int index = additionalClasspathEntry.indexOf(61);
                if (index == -1) {
                    jetEmitter.addVariable(additionalClasspathEntry, additionalClasspathEntry);
                    continue;
                }
                jetEmitter.addVariable(additionalClasspathEntry.substring(0, index), additionalClasspathEntry.substring(index + 1));
            }
        }
    }

    protected GIFEmitter getGIFEmitter(String[] inputPathNames, int id) {
        GIFEmitter gifEmitter;
        if (this.gifEmitters == null) {
            this.gifEmitters = new GIFEmitter[inputPathNames.length];
        }
        if ((gifEmitter = this.gifEmitters[id]) == null) {
            this.gifEmitters[id] = gifEmitter = this.createGIFEmitter(inputPathNames[id]);
        }
        return gifEmitter;
    }

    protected GIFEmitter createGIFEmitter(String inputPathName) {
        return new GIFEmitter(JETCompiler.find((String[])this.getTemplatePath(), (String)inputPathName));
    }

    protected void generateText(String targetPathName, JETEmitter jetEmitter, Object[] arguments, boolean overwrite, String encoding, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 3);
                URI targetFile = this.toURI(targetPathName);
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingFile_message", new Object[]{targetFile}));
                URI targetDirectory = targetFile.trimSegments(1);
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                boolean exists = this.exists(targetFile);
                if (!exists || overwrite) {
                    if (arguments == null) {
                        arguments = new Object[]{this.generatingObject};
                    }
                    this.setLineDelimiter(this.getLineDelimiter(targetFile, encoding));
                    String emitterResult = jetEmitter.generate(this.createMonitor(monitor, 1), arguments, this.getLineDelimiter());
                    if (PROPERTIES_ENCODING.equals(encoding)) {
                        emitterResult = CodeGenUtil.unicodeEscapeEncode((String)emitterResult);
                    }
                    if (encoding == null) {
                        encoding = this.getEncoding(targetFile);
                    }
                    boolean changed = true;
                    if (exists) {
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                        String oldContents = this.getContents(targetFile, encoding);
                        boolean bl = changed = !emitterResult.equals(oldContents);
                        if (changed) {
                            if (targetPathName.endsWith("/plugin.xml")) {
                                emitterResult = this.mergePluginXML(this.generatingObject instanceof GenBase ? ((GenBase)this.generatingObject).getGenModel().getPluginKey() : "", oldContents, emitterResult);
                                changed = !emitterResult.equals(oldContents);
                            } else if (targetPathName.endsWith("/MANIFEST.MF")) {
                                boolean bl2 = changed = !(emitterResult = this.mergeManifest(oldContents, emitterResult)).equals(oldContents);
                            }
                        }
                    }
                    if (changed) {
                        boolean redirect;
                        byte[] bytes = encoding == null ? emitterResult.toString().getBytes() : emitterResult.toString().getBytes(encoding);
                        String redirection = this.getGenerator().getOptions().redirectionPattern;
                        boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                        if (redirect) {
                            String baseName = MessageFormat.format(redirection, targetFile.lastSegment());
                            targetFile = targetDirectory.appendSegment(baseName);
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                        }
                        if (this.isReadOnly(targetFile)) {
                            if (this.getGenerator().getOptions().forceOverwrite) {
                                this.validateEdit(targetFile, this.createMonitor(monitor, 1));
                                this.setWriteable(targetFile);
                            } else {
                                targetFile = targetDirectory.appendSegment("." + targetFile.lastSegment() + ".new");
                                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                            }
                        }
                        OutputStream outputStream = this.createOutputStream(targetFile);
                        outputStream.write(bytes);
                        outputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
                this.setLineDelimiter(null);
                monitor.done();
            }
        }
        finally {
            this.setLineDelimiter(null);
            monitor.done();
        }
    }

    protected List<ExtensionData> getExtensionData(String contents) {
        ArrayList<ExtensionData> extensions = new ArrayList<ExtensionData>();
        Matcher matcher = EXTENSION_POINT_PATTERN.matcher(contents);
        while (matcher.find()) {
            ExtensionData extension = new ExtensionData();
            extension.extensionPointID = matcher.group(1);
            extension.identifier = matcher.group(2);
            extension.start = matcher.start();
            extension.end = matcher.end();
            extension.content = matcher.group();
            extension.lineSeparator = matcher.group(3);
            extensions.add(extension);
            Matcher generatedMatcher = GENERATED_PATTERN.matcher(extension.content);
            if (!generatedMatcher.find()) continue;
            extension.generated = generatedMatcher.group(1);
        }
        return extensions;
    }

    protected String mergePluginXML(String generated, String oldContents, String newContents) {
        List<ExtensionData> oldExtensions = this.getExtensionData(oldContents);
        List<ExtensionData> newExtensions = this.getExtensionData(newContents);
        int end = -1;
        Matcher matcher = PLUGIN_END_TAG_PATTERN.matcher(oldContents);
        boolean isEmpty = false;
        if (matcher.find()) {
            isEmpty = matcher.group(1) == null;
            end = matcher.start(2);
        }
        int i = 0;
        int size = oldExtensions.size();
        while (i < size) {
            ExtensionData oldExtension = oldExtensions.get(i);
            int index = newExtensions.indexOf(oldExtension);
            if (index == -1) {
                if (generated.equals(oldExtension.generated)) {
                    oldExtension.content = "";
                    Matcher trailingMatching = BLANK_LINES_PATTERN.matcher(oldContents);
                    if (trailingMatching.find(oldExtension.end) && oldExtension.end == trailingMatching.start()) {
                        oldExtension.end = trailingMatching.end();
                    }
                }
            } else {
                ExtensionData newExtension = newExtensions.get(index);
                if (oldExtension.generated != null && oldExtension.generated.equals(newExtension.generated)) {
                    oldExtension.content = newExtension.content;
                }
                newExtension.content = null;
            }
            ++i;
        }
        i = 0;
        size = newExtensions.size();
        while (i < size) {
            block14: {
                ExtensionData newExtension = newExtensions.get(i);
                if (newExtension.content != null && newExtension.generated != null) {
                    ExtensionData oldExtension;
                    int j = i - 1;
                    while (j >= 0) {
                        int index = oldExtensions.indexOf(newExtensions.get(j));
                        if (index != -1) {
                            oldExtension = oldExtensions.get(index);
                            oldExtensions.add(index + 1, newExtension);
                            newExtension.content = String.valueOf(oldExtension.lineSeparator) + newExtension.content;
                            newExtension.start = newExtension.end = oldExtension.end;
                            break block14;
                        }
                        --j;
                    }
                    j = i + 1;
                    while (j < size) {
                        int index = oldExtensions.indexOf(newExtensions.get(j));
                        if (index != -1) {
                            oldExtension = oldExtensions.get(index);
                            oldExtensions.add(index, newExtension);
                            newExtension.content = String.valueOf(newExtension.content) + newExtension.lineSeparator;
                            newExtension.start = newExtension.end = oldExtension.start;
                            break block14;
                        }
                        ++j;
                    }
                    oldExtensions.add(newExtension);
                    newExtension.content = String.valueOf(isEmpty ? newExtension.lineSeparator : "") + newExtension.content + newExtension.lineSeparator;
                    newExtension.lineSeparator = "";
                    newExtension.start = newExtension.end = end;
                }
            }
            ++i;
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        int i2 = 0;
        int size2 = oldExtensions.size();
        while (i2 < size2) {
            ExtensionData oldExtension = oldExtensions.get(i2);
            result.append(oldContents.substring(index, oldExtension.start));
            result.append(oldExtension.content);
            index = oldExtension.end;
            ++i2;
        }
        result.append(oldContents.substring(index));
        return result.toString();
    }

    protected List<AttributeData> getAttributeData(String contents) {
        ArrayList<AttributeData> result = new ArrayList<AttributeData>();
        Matcher versionMatcher = VERSION_PATTERN.matcher(contents);
        if (versionMatcher.lookingAt()) {
            AttributeData versionAttribute = new AttributeData();
            versionAttribute.name = "Manifest-Version";
            versionAttribute.value = versionMatcher.group(1);
            versionAttribute.lineDelimiter = versionMatcher.group(2);
            versionAttribute.end = versionMatcher.end();
            result.add(versionAttribute);
            Matcher headerMatcher = HEADER_PATTERN.matcher(contents);
            Matcher continuationMatcher = CONTINUATION_PATTERN.matcher(contents);
            int start = versionMatcher.end();
            while (headerMatcher.find(start) && headerMatcher.start() == start) {
                AttributeData attribute = new AttributeData();
                attribute.name = headerMatcher.group(1);
                attribute.lineDelimiter = headerMatcher.group(3);
                attribute.start = headerMatcher.start();
                attribute.end = headerMatcher.end();
                result.add(attribute);
                StringBuilder value = new StringBuilder(headerMatcher.group(2));
                start = headerMatcher.end();
                while (continuationMatcher.find(start) && continuationMatcher.start() == start) {
                    value.append(continuationMatcher.group(1));
                    attribute.end = continuationMatcher.end();
                    start = continuationMatcher.end();
                }
                attribute.value = value.toString();
                attribute.elements = ManifestElement.getElements(attribute.name, attribute.value);
            }
        }
        return result;
    }

    protected String mergeManifest(String oldContents, String newContents) {
        List<AttributeData> oldAttributes = this.getAttributeData(oldContents);
        List<AttributeData> newAttributes = this.getAttributeData(newContents);
        int i = 0;
        int size = oldAttributes.size();
        while (i < size) {
            AttributeData oldAttributeData = oldAttributes.get(i);
            int index = newAttributes.indexOf(oldAttributeData);
            if (index != -1) {
                AttributeData newAttributeData = newAttributes.get(index);
                if ("Bundle-RequiredExecutionEnvironment".equals(oldAttributeData.name) || "Bundle-Name".equals(oldAttributeData.name) || "Bundle-Vendor".equals(oldAttributeData.name) || "Bundle-Localization".equals(oldAttributeData.name) || "Bundle-SymbolicName".equals(oldAttributeData.name) || "Bundle-Activator".equals(oldAttributeData.name) || "Automatic-Module-Name".equals(oldAttributeData.name)) {
                    if (oldAttributeData.elements == null) {
                        oldAttributeData.value = newAttributeData.value;
                    } else {
                        oldAttributeData.elements = newAttributeData.elements;
                    }
                } else if (("Export-Package".equals(oldAttributeData.name) || "Import-Package".equals(oldAttributeData.name) || "Require-Bundle".equals(oldAttributeData.name) || "Require-Package".equals(oldAttributeData.name) || "Provide-Capability".equals(oldAttributeData.name)) && newAttributeData.elements != null) {
                    if (oldAttributeData.elements == null) {
                        oldAttributeData.value = newAttributeData.value;
                    } else {
                        int j = 0;
                        int elementSize = newAttributeData.elements.size();
                        while (j < elementSize) {
                            block39: {
                                AttributeData.Element element = newAttributeData.elements.get(j);
                                int elementIndex = oldAttributeData.getMatchingElement(element);
                                if (elementIndex != -1) {
                                    int targetIndex;
                                    int oldAttributeIndex;
                                    AttributeData.Element oldElement = oldAttributeData.elements.get(elementIndex);
                                    int m = 0;
                                    int attributeSize = element.attributes.size();
                                    while (m < attributeSize) {
                                        block37: {
                                            AttributeData.Element.Attribute attribute = element.attributes.get(m);
                                            oldAttributeIndex = oldElement.attributes.indexOf(attribute);
                                            if (oldAttributeIndex != -1) {
                                                AttributeData.Element.Attribute oldAttribute = oldElement.attributes.get(oldAttributeIndex);
                                                oldAttribute.value = attribute.value;
                                            } else {
                                                int n = m - 1;
                                                while (n >= 0) {
                                                    targetIndex = oldElement.attributes.indexOf(element.attributes.get(n));
                                                    if (targetIndex != -1) {
                                                        oldElement.attributes.add(targetIndex + 1, attribute);
                                                        break block37;
                                                    }
                                                    --n;
                                                }
                                                n = m + 1;
                                                while (n < attributeSize) {
                                                    targetIndex = oldElement.attributes.indexOf(element.attributes.get(n));
                                                    if (targetIndex != -1) {
                                                        oldElement.attributes.add(targetIndex, attribute);
                                                        break block37;
                                                    }
                                                    ++n;
                                                }
                                                oldElement.attributes.add(attribute);
                                            }
                                        }
                                        ++m;
                                    }
                                    m = 0;
                                    int directiveSize = element.directives.size();
                                    while (m < directiveSize) {
                                        block38: {
                                            AttributeData.Element.Directive directive = element.directives.get(m);
                                            oldAttributeIndex = oldElement.directives.indexOf(directive);
                                            if (oldAttributeIndex != -1) {
                                                AttributeData.Element.Directive oldDirective = oldElement.directives.get(oldAttributeIndex);
                                                oldDirective.value = directive.value;
                                            } else {
                                                int n = m - 1;
                                                while (n >= 0) {
                                                    targetIndex = oldElement.directives.indexOf(element.directives.get(n));
                                                    if (targetIndex != -1) {
                                                        oldElement.directives.add(targetIndex + 1, directive);
                                                        break block38;
                                                    }
                                                    --n;
                                                }
                                                n = m + 1;
                                                while (n < directiveSize) {
                                                    targetIndex = oldElement.directives.indexOf(element.directives.get(n));
                                                    if (targetIndex != -1) {
                                                        oldElement.directives.add(targetIndex, directive);
                                                        break block38;
                                                    }
                                                    ++n;
                                                }
                                                oldElement.directives.add(directive);
                                            }
                                        }
                                        ++m;
                                    }
                                } else {
                                    int targetIndex;
                                    int k = j - 1;
                                    while (k >= 0) {
                                        targetIndex = oldAttributeData.getMatchingElement(newAttributeData.elements.get(k));
                                        if (targetIndex != -1) {
                                            oldAttributeData.elements.add(targetIndex + 1, element);
                                            break block39;
                                        }
                                        --k;
                                    }
                                    k = j + 1;
                                    while (k < elementSize) {
                                        targetIndex = oldAttributeData.getMatchingElement(newAttributeData.elements.get(k));
                                        if (targetIndex != -1) {
                                            oldAttributeData.elements.add(targetIndex, element);
                                            break block39;
                                        }
                                        ++k;
                                    }
                                    oldAttributeData.elements.add(element);
                                }
                            }
                            ++j;
                        }
                    }
                }
                newAttributeData.value = null;
            }
            ++i;
        }
        i = 0;
        size = newAttributes.size();
        while (i < size) {
            block40: {
                AttributeData newAttribute = newAttributes.get(i);
                if (newAttribute.value != null) {
                    int j = i - 1;
                    while (j >= 0) {
                        int index = oldAttributes.indexOf(newAttributes.get(j));
                        if (index != -1) {
                            AttributeData oldAttribute = oldAttributes.get(index);
                            oldAttributes.add(index + 1, newAttribute);
                            newAttribute.start = newAttribute.end = oldAttribute.end;
                            break block40;
                        }
                        --j;
                    }
                    j = i + 1;
                    while (j < size) {
                        int index = oldAttributes.indexOf(newAttributes.get(j));
                        if (index != -1) {
                            AttributeData oldAttribute = oldAttributes.get(index);
                            oldAttributes.add(index, newAttribute);
                            newAttribute.start = newAttribute.end = oldAttribute.start;
                            break block40;
                        }
                        ++j;
                    }
                    oldAttributes.add(newAttribute);
                    newAttribute.start = newAttribute.end = oldAttributes.get((int)(oldAttributes.size() - 1)).end;
                }
            }
            ++i;
        }
        StringBuilder result = new StringBuilder();
        int index = 0;
        int i2 = 0;
        int size2 = oldAttributes.size();
        while (i2 < size2) {
            AttributeData oldAttribute = oldAttributes.get(i2);
            result.append(oldContents.substring(index, oldAttribute.start));
            result.append(oldAttribute);
            result.append(oldAttribute.lineDelimiter);
            index = oldAttribute.end;
            ++i2;
        }
        result.append(oldContents.substring(index));
        return result.toString();
    }

    protected void generateProperties(String targetPathName, JETEmitter jetEmitter, Object[] arguments, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 3);
                URI targetFile = this.toURI(targetPathName);
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingFile_message", new Object[]{targetFile}));
                URI targetDirectory = targetFile.trimSegments(1);
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                boolean changed = false;
                if (arguments == null) {
                    arguments = new Object[]{this.generatingObject};
                }
                this.setLineDelimiter(this.getLineDelimiter(targetFile, PROPERTIES_ENCODING));
                String emitterResult = CodeGenUtil.unicodeEscapeEncode((String)jetEmitter.generate(this.createMonitor(monitor, 1), arguments, this.getLineDelimiter()));
                byte[] bytes = emitterResult.toString().getBytes(PROPERTIES_ENCODING);
                if (this.shouldMerge(targetFile) && this.exists(targetFile)) {
                    PropertyMerger propertyMerger = new PropertyMerger();
                    propertyMerger.setSourceProperties(emitterResult);
                    monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                    String oldProperties = propertyMerger.createPropertiesForInputStream(this.createInputStream(targetFile));
                    propertyMerger.setTargetProperties(oldProperties);
                    monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                    propertyMerger.merge();
                    String mergedResult = propertyMerger.getTargetProperties();
                    boolean bl = changed = !mergedResult.equals(oldProperties);
                    if (changed) {
                        if (this.isReadOnly(targetFile) && this.validateEdit(targetFile, this.createMonitor(monitor, 1))) {
                            propertyMerger.setTargetProperties(propertyMerger.createPropertiesForInputStream(this.createInputStream(targetFile)));
                            propertyMerger.merge();
                            mergedResult = propertyMerger.getTargetProperties();
                        }
                        bytes = mergedResult.getBytes(PROPERTIES_ENCODING);
                    }
                } else {
                    changed = true;
                    monitor.worked(1);
                }
                if (changed) {
                    boolean redirect;
                    String redirection = this.getGenerator().getOptions().redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, targetFile.lastSegment());
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (this.getGenerator().getOptions().forceOverwrite) {
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + targetFile.lastSegment() + ".new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    OutputStream outputStream = this.createOutputStream(targetFile);
                    outputStream.write(bytes);
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
                this.setLineDelimiter(null);
                monitor.done();
            }
        }
        finally {
            this.setLineDelimiter(null);
            monitor.done();
        }
    }

    protected void generateGIF(String targetPathName, GIFEmitter gifEmitter, String parentKey, String childKey, boolean overwrite, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 3);
                URI targetFile = this.toURI(targetPathName);
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingImage_message", new Object[]{targetFile}));
                URI targetDirectory = targetFile.trimSegments(1);
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                boolean exists = this.exists(targetFile);
                if (!exists || overwrite) {
                    boolean redirect;
                    byte[] emitterResult = gifEmitter.generateGIF(parentKey, childKey);
                    monitor.worked(1);
                    String redirection = this.getGenerator().getOptions().redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, targetFile.lastSegment());
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (this.getGenerator().getOptions().forceOverwrite) {
                            this.validateEdit(targetFile, this.createMonitor(monitor, 1));
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + targetFile.lastSegment() + ".new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    OutputStream outputStream = this.createOutputStream(targetFile);
                    outputStream.write(emitterResult);
                    outputStream.close();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected boolean shouldMerge(URI workspacePath) {
        return true;
    }

    protected void generateJava(String targetPath, String packageName, String className, JETEmitter jetEmitter, Object[] arguments, Monitor monitor) {
        try {
            try {
                monitor.beginTask("", 4);
                URI targetDirectory = this.toURI(targetPath).appendSegments(packageName.split("\\."));
                URI targetFile = targetDirectory.appendSegment(String.valueOf(className) + ".java");
                monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_Generating_message", new Object[]{targetFile}));
                this.ensureContainerExists(targetDirectory, this.createMonitor(monitor, 1));
                if (arguments == null) {
                    arguments = new Object[]{this.generatingObject};
                }
                final JControlModel jControlModel = this.getGenerator().getJControlModel();
                JMerger jMerger = null;
                final boolean shouldMerge = this.shouldMerge(targetFile);
                if (jControlModel.canMerge()) {
                    jMerger = new JMerger(jControlModel){
                        private String compilationUnitContents;

                        public void setSourceCompilationUnit(String sourceCompilationUnitContents) {
                            if (shouldMerge) {
                                super.setSourceCompilationUnit(sourceCompilationUnitContents);
                            } else {
                                this.compilationUnitContents = sourceCompilationUnitContents;
                            }
                        }

                        public void merge() {
                            if (shouldMerge) {
                                super.merge();
                            }
                        }

                        public String getTargetCompilationUnitContents() {
                            if (shouldMerge) {
                                return super.getTargetCompilationUnitContents();
                            }
                            return CodeGenUtil.convertFormat((String)jControlModel.getLeadingTabReplacement(), (boolean)jControlModel.convertToStandardBraceStyle(), (String)this.compilationUnitContents);
                        }
                    };
                }
                this.createImportManager(packageName, className);
                String targetFileContents = null;
                String targetFileEncoding = this.getEncoding(targetFile);
                if (shouldMerge && this.exists(targetFile) && jMerger != null) {
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(this.createInputStream(targetFile), targetFileEncoding));
                    JCompilationUnit targetCompilationUnit = jMerger.getTargetCompilationUnit();
                    ImportManager importManager = this.getImportManager();
                    for (JNode node : targetCompilationUnit.getChildren()) {
                        JImport jImport;
                        String qualifiedName;
                        if (!(node instanceof JImport) || (qualifiedName = (jImport = (JImport)node).getQualifiedName()).endsWith(".*")) continue;
                        importManager.addImport(qualifiedName);
                    }
                    targetFileContents = jMerger.getTargetCompilationUnitContents();
                }
                this.setLineDelimiter(this.getLineDelimiter(targetFile, targetFileEncoding));
                String emitterResult = jetEmitter.generate(this.createMonitor(monitor, 1), arguments, this.getLineDelimiter());
                boolean changed = true;
                String newContents = emitterResult;
                Generator.Options options = this.getGenerator().getOptions();
                if (jMerger != null) {
                    jMerger.setFixInterfaceBrace(jControlModel.getFacadeHelper().fixInterfaceBrace());
                    try {
                        jMerger.setSourceCompilationUnit(emitterResult);
                    }
                    catch (RuntimeException runtimeException) {
                        if (targetFileContents != null) {
                            throw runtimeException;
                        }
                        jMerger = null;
                    }
                    if (jMerger != null) {
                        Object codeFormatter;
                        Object object = codeFormatter = options.codeFormatting ? this.createCodeFormatter(options.codeFormatterOptions, targetFile) : null;
                        if (targetFileContents != null) {
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                            jMerger.merge();
                            newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter, options.commentFormatting);
                            if (options.importOrganizing) {
                                newContents = this.organizeImports(targetFile.toString(), newContents);
                            }
                            boolean bl = changed = !targetFileContents.equals(newContents);
                            if (changed && this.isReadOnly(targetFile) && this.validateEdit(targetFile, this.createMonitor(monitor, 1))) {
                                jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(this.createInputStream(targetFile), targetFileEncoding));
                                jMerger.remerge();
                                newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter, options.commentFormatting);
                                if (options.importOrganizing) {
                                    newContents = this.organizeImports(targetFile.toString(), newContents);
                                }
                            }
                        } else {
                            changed = true;
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_PreparingNew_message", new Object[]{targetFile}));
                            jMerger.merge();
                            newContents = this.formatCode(jMerger.getTargetCompilationUnitContents(), codeFormatter, options.commentFormatting);
                        }
                        if (jControlModel.getFacadeHelper() != null) {
                            jControlModel.getFacadeHelper().reset();
                        }
                    }
                }
                if (jMerger == null) {
                    newContents = CodeGenUtil.convertFormat((String)jControlModel.getLeadingTabReplacement(), (boolean)jControlModel.convertToStandardBraceStyle(), (String)emitterResult);
                    if (targetFileContents != null) {
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_ExaminingOld_message", new Object[]{targetFile}));
                        changed = !targetFileContents.equals(newContents);
                    } else {
                        changed = true;
                    }
                }
                monitor.worked(1);
                if (changed) {
                    boolean redirect;
                    String encoding = targetFileEncoding;
                    byte[] bytes = encoding == null ? newContents.getBytes() : newContents.getBytes(encoding);
                    String redirection = options.redirectionPattern;
                    boolean bl = redirect = redirection != null && redirection.indexOf("{0}") != -1;
                    if (redirect) {
                        String baseName = MessageFormat.format(redirection, String.valueOf(className) + ".java");
                        targetFile = targetDirectory.appendSegment(baseName);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingAlternate_message", new Object[]{targetFile}));
                    }
                    if (this.isReadOnly(targetFile)) {
                        if (options.forceOverwrite) {
                            this.setWriteable(targetFile);
                        } else {
                            targetFile = targetDirectory.appendSegment("." + className + ".java.new");
                            monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_UsingDefaultAlternate_message", new Object[]{targetFile}));
                        }
                    }
                    OutputStream outputStream = this.createOutputStream(targetFile);
                    outputStream.write(bytes);
                    outputStream.close();
                }
            }
            catch (Exception e) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new WrappedException(e);
            }
        }
        finally {
            this.clearImportManager();
            this.setLineDelimiter(null);
            monitor.done();
        }
    }

    protected URI toURI(String pathName) {
        return URI.createURI((String)pathName);
    }

    protected URI toPlatformResourceURI(URI uri) {
        return URI.createPlatformResourceURI((String)uri.toString(), (boolean)true);
    }

    protected Monitor createMonitor(Monitor monitor, int ticks) {
        return CodeGenUtil.createMonitor((Monitor)monitor, (int)ticks);
    }

    protected void createImportManager(String packageName, String className) {
        this.importManager = new ImportManager(packageName);
        this.importManager.addMasterImport(packageName, className);
    }

    protected void clearImportManager() {
        this.importManager = null;
    }

    protected ImportManager getImportManager() {
        return this.importManager;
    }

    protected void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    protected String getLineDelimiter() {
        return this.lineDelimiter;
    }

    protected void ensureProjectExists(String workspacePath, Object object, Object projectType, boolean force, Monitor monitor) {
        try {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                EclipseHelper.ensureProjectExists(workspacePath, object, projectType, force, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void ensureContainerExists(URI workspacePath, Monitor monitor) {
        try {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                EclipseHelper.ensureContainerExists(workspacePath.toString(), monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected URIConverter getURIConverter() {
        URIConverter result;
        ResourceSet resourceSet = this.getGenerator().getOptions().resourceSet;
        URIConverter uRIConverter = result = resourceSet != null ? resourceSet.getURIConverter() : null;
        if (result != null) {
            return result;
        }
        if (this.uriConverter == null) {
            this.uriConverter = new ExtensibleURIConverterImpl();
        }
        return this.uriConverter;
    }

    public String getLineDelimiter(URI workspacePath, String encoding) {
        InputStream inputStream = null;
        try {
            inputStream = this.createInputStream(workspacePath);
            String lineDelimiter = ContentHandlerImpl.getLineDelimiter((InputStream)inputStream, (String)encoding);
            if (lineDelimiter != null) {
                String string = lineDelimiter;
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException exception) {
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                }
            }
        }
        if (EcorePlugin.getWorkspaceRoot() != null) {
            return PlatformResourceURIHandlerImpl.WorkbenchHelper.getLineDelimiter((String)workspacePath.toString(), null);
        }
        return System.getProperty("line.separator");
    }

    protected boolean exists(URI workspacePath) {
        if (EcorePlugin.getWorkspaceRoot() != null) {
            return PlatformResourceURIHandlerImpl.WorkbenchHelper.exists((String)workspacePath.toString(), null);
        }
        return this.getURIConverter().exists(this.toPlatformResourceURI(workspacePath), null);
    }

    protected boolean isReadOnly(URI workspacePath) {
        if (EcorePlugin.getWorkspaceRoot() != null) {
            return EclipseHelper.isReadOnly(workspacePath.toString());
        }
        URI uri = this.getURIConverter().normalize(this.toPlatformResourceURI(workspacePath));
        if ("file".equalsIgnoreCase(uri.scheme())) {
            File file = new File(uri.toFileString());
            return file.exists() && !file.canWrite();
        }
        return false;
    }

    protected void setWriteable(URI workspacePath) throws Exception {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            EclipseHelper.setWriteable(workspacePath.toString());
            return;
        }
        URI uri = this.getURIConverter().normalize(this.toPlatformResourceURI(workspacePath));
        if ("file".equalsIgnoreCase(uri.scheme())) {
            new File(uri.toFileString()).delete();
        }
    }

    protected boolean validateEdit(URI workspacePath, Monitor monitor) {
        try {
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                boolean bl = EclipseHelper.validateEdit(workspacePath.toString(), monitor);
                return bl;
            }
            return false;
        }
        finally {
            monitor.done();
        }
    }

    protected InputStream createInputStream(URI workspacePath) throws Exception {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.createInputStream(workspacePath.toString());
        }
        return this.getURIConverter().createInputStream(this.toPlatformResourceURI(workspacePath), null);
    }

    protected OutputStream createOutputStream(URI workspacePath) throws Exception {
        OutputStream result = EMFPlugin.IS_ECLIPSE_RUNNING ? URIConverter.INSTANCE.createOutputStream(this.toPlatformResourceURI(workspacePath), null) : this.getURIConverter().createOutputStream(this.toPlatformResourceURI(workspacePath), null);
        this.getGenerator().generatedOutput(workspacePath);
        return result;
    }

    protected String getContents(URI workspacePath, String encoding) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.createInputStream(workspacePath));
        byte[] input = new byte[bufferedInputStream.available()];
        bufferedInputStream.read(input);
        bufferedInputStream.close();
        return encoding == null ? new String(input) : new String(input, encoding);
    }

    protected String getEncoding(URI workspacePath) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.getEncoding(workspacePath.toString());
        }
        return null;
    }

    protected Object createCodeFormatter(Map<?, ?> options, URI workspacePath) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            return EclipseHelper.createCodeFormatter(options, workspacePath.toString());
        }
        return null;
    }

    @Deprecated
    protected String formatCode(String contents, Object codeFormatter) {
        return EMFPlugin.IS_ECLIPSE_RUNNING ? EclipseHelper.formatCode(contents, codeFormatter, this.getLineDelimiter(), false) : contents;
    }

    protected String formatCode(String contents, Object codeFormatter, boolean formatComments) {
        return formatComments && EMFPlugin.IS_ECLIPSE_RUNNING ? EclipseHelper.formatCode(contents, codeFormatter, this.getLineDelimiter(), formatComments) : this.formatCode(contents, codeFormatter);
    }

    protected String organizeImports(String path, String contents) {
        return EMFPlugin.IS_ECLIPSE_RUNNING ? EclipseHelper.organizeImports(path, contents) : contents;
    }

    protected static final class AttributeData {
        public String name;
        public String value;
        public String lineDelimiter;
        public List<Element> elements;
        public int start;
        public int end;

        protected AttributeData() {
        }

        public String toString() {
            if (this.elements != null) {
                StringBuilder result = new StringBuilder(this.name);
                result.append(": ");
                boolean previous = false;
                for (Element element : this.elements) {
                    if (previous) {
                        result.append(',');
                        result.append(this.lineDelimiter);
                        result.append(' ');
                    } else {
                        previous = true;
                    }
                    result.append(element.toString(this.lineDelimiter));
                }
                return result.toString();
            }
            StringBuilder result = new StringBuilder(this.name);
            result.append(": ");
            int index = 0;
            boolean previous = false;
            int length = this.value.length();
            int i = this.value.indexOf(44);
            while (i != -1) {
                if (previous) {
                    result.append(',');
                    result.append(this.lineDelimiter);
                    result.append(' ');
                } else {
                    previous = true;
                }
                if (i + 1 < length && Character.isDigit(this.value.charAt(i + 1))) {
                    result.append(this.value.substring(index, i + 1));
                    previous = false;
                } else {
                    result.append(this.value.substring(index, i));
                }
                index = i + 1;
                i = this.value.indexOf(44, index);
            }
            if (previous) {
                result.append(',');
                result.append(this.lineDelimiter);
                result.append(' ');
            }
            result.append(this.value.substring(index));
            return result.toString();
        }

        public boolean equals(Object object) {
            return object instanceof AttributeData && this.name.equals(((AttributeData)object).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public int getMatchingElement(Element element) {
            if ("Provide-Capability".equals(this.name)) {
                if (element.valueComponents.contains("org.eclipse.emf.ecore.generated_package")) {
                    int index = this.getMatchingElement(element, "uri");
                    if (index == -1) {
                        index = this.getMatchingElement(element, "class");
                    }
                    return index;
                }
                return -1;
            }
            return this.elements.indexOf(element);
        }

        protected int getMatchingElement(Element element, String attributeKey) {
            Element.Attribute attribute = element.getAttribute(attributeKey);
            if (attribute != null) {
                int i = 0;
                int size = this.elements.size();
                while (i < size) {
                    Element.Attribute otherAttribute;
                    Element otherElement = this.elements.get(i);
                    if (otherElement.equals(element) && (otherAttribute = otherElement.getAttribute(attributeKey)) != null && otherAttribute.value.equals(attribute.value)) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        private static String quote(String value) {
            boolean hasLetter = false;
            boolean needsQuote = false;
            int i = 0;
            int length = value.length();
            while (i < length) {
                char c = value.charAt(i);
                boolean isLetter = Character.isLetter(c);
                if (!isLetter && !Character.isDigit(c) && c != '_' && c != '-' && c != '.') {
                    needsQuote = true;
                    break;
                }
                if (isLetter) {
                    hasLetter = true;
                }
                ++i;
            }
            if (!hasLetter || needsQuote) {
                return String.valueOf('\"') + value.replace("\\", "\\\\").replace("\"", "\\\"") + '\"';
            }
            return value;
        }

        protected static final class Element {
            public Set<String> valueComponents = new LinkedHashSet<String>();
            public List<Directive> directives = new ArrayList<Directive>();
            public List<Attribute> attributes = new ArrayList<Attribute>();

            protected Element() {
            }

            public boolean equals(Object object) {
                return object instanceof Element && this.valueComponents.equals(((Element)object).valueComponents);
            }

            public int hashCode() {
                return this.valueComponents.hashCode();
            }

            public String toString(String lineDelimiter) {
                StringBuilder result = new StringBuilder();
                boolean previous = false;
                for (String valueComponent : this.valueComponents) {
                    if (previous) {
                        result.append(';');
                    } else {
                        previous = true;
                    }
                    result.append(valueComponent);
                }
                for (Attribute attribute : this.attributes) {
                    result.append(';');
                    result.append(attribute.toString(lineDelimiter));
                }
                for (Directive directive : this.directives) {
                    result.append(';');
                    result.append(directive.toString(lineDelimiter));
                }
                return result.toString();
            }

            public String toString() {
                return this.toString("");
            }

            public Attribute getAttribute(String key) {
                for (Attribute attribute : this.attributes) {
                    if (!key.equals(attribute.key)) continue;
                    return attribute;
                }
                return null;
            }

            protected static final class Attribute {
                public String key;
                public String value;

                protected Attribute() {
                }

                public String toString(String lineDelimiter) {
                    return String.valueOf(this.key) + "=" + AttributeData.quote(this.value);
                }

                public String toString() {
                    return this.toString("");
                }

                public boolean equals(Object object) {
                    return object instanceof Attribute && this.key.equals(((Attribute)object).key);
                }

                public int hashCode() {
                    return this.key.hashCode();
                }
            }

            protected static final class Directive {
                public String key;
                public String value;

                protected Directive() {
                }

                public String toString(String lineDelimiter) {
                    if ("x-friends".equals(this.key) || "uses".equals(this.key)) {
                        boolean hasLineDelimiter = lineDelimiter.length() != 0;
                        StringBuilder result = new StringBuilder();
                        if (hasLineDelimiter) {
                            result.append(lineDelimiter);
                            result.append("  ");
                        }
                        result.append(this.key);
                        result.append(":=\"");
                        List friends = XMLTypeFactory.eINSTANCE.createIDREFS(this.value.replace(',', ' '));
                        int size = friends.size();
                        if (size > 0) {
                            result.append((String)friends.get(0));
                            int i = 1;
                            while (i < size) {
                                result.append(',');
                                if (lineDelimiter.length() != 0) {
                                    result.append(lineDelimiter);
                                    result.append("   ");
                                }
                                result.append((String)friends.get(i));
                                ++i;
                            }
                        }
                        result.append('\"');
                        return result.toString();
                    }
                    return String.valueOf(this.key) + ":=" + AttributeData.quote(this.value);
                }

                public String toString() {
                    return this.toString("");
                }

                public boolean equals(Object object) {
                    return object instanceof Directive && this.key.equals(((Directive)object).key);
                }

                public int hashCode() {
                    return this.key.hashCode();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EclipseHelper {
        private EclipseHelper() {
        }

        public static boolean ensureProjectExists(String workspacePath, Object object, Object projectType, boolean force, Monitor monitor) {
            try {
                Path path = new Path(workspacePath);
                if (path.isAbsolute()) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IProject project = workspace.getRoot().getProject(path.segment(0));
                    if (!project.exists() || force) {
                        IPath javaSource = path.uptoSegment(1).append("src");
                        Generator.createEMFProject(javaSource, null, Collections.<IProject>emptyList(), monitor, Generator.EMF_PLUGIN_PROJECT_STYLE);
                    }
                    return workspace.getRoot().getProject(path.segment(0)).exists();
                }
            }
            catch (Exception exception) {
                CodeGenEcorePlugin.INSTANCE.log(exception);
            }
            return false;
        }

        public static boolean ensureContainerExists(String workspacePath, Monitor monitor) {
            IProject container;
            Path path;
            block10: {
                path = new Path(workspacePath);
                container = null;
                try {
                    try {
                        IWorkspace workspace;
                        IProject project;
                        monitor.beginTask("", path.segmentCount() + 1);
                        monitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_OpeningFolder_message", new Object[]{path}));
                        if (path.isAbsolute() && (project = (workspace = ResourcesPlugin.getWorkspace()).getRoot().getProject(path.segment(0))).exists()) {
                            if (!project.isOpen()) {
                                project.open(BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)monitor, (int)1)));
                            } else {
                                monitor.worked(1);
                            }
                            container = project;
                            int i = 1;
                            int length = path.segmentCount();
                            while (i < length) {
                                IFolder folder = container.getFolder((IPath)new Path(path.segment(i)));
                                if (!folder.exists()) {
                                    folder.create(false, true, BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)monitor, (int)1)));
                                }
                                container = folder;
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {
                        CodeGenEcorePlugin.INSTANCE.log(exception);
                        monitor.done();
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    monitor.done();
                    throw throwable;
                }
                monitor.done();
            }
            return container != null && container.getFullPath().equals((Object)path);
        }

        public static boolean isReadOnly(String workspacePath) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).isReadOnly();
        }

        public static void setWriteable(String workspacePath) throws Exception {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath));
            ResourceAttributes resourceAttributes = file.getResourceAttributes();
            if (resourceAttributes != null) {
                resourceAttributes.setReadOnly(false);
                file.setResourceAttributes(resourceAttributes);
            }
        }

        public static boolean validateEdit(String workspacePath, Monitor monitor) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath));
            return file.getWorkspace().validateEdit(new IFile[]{file}, IWorkspace.VALIDATE_PROMPT).isOK();
        }

        public static InputStream createInputStream(String workspacePath) throws Exception {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).getContents(true);
        }

        public static String getEncoding(String workspacePath) {
            try {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath)).getCharset();
            }
            catch (CoreException exception) {
                return null;
            }
        }

        public static Object createCodeFormatter(Map<?, ?> options, String workspacePath) {
            IJavaProject javaProject;
            IProject project;
            if (options == null && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(workspacePath).segment(0))) != null && (javaProject = JavaCore.create((IProject)project)) != null) {
                options = javaProject.getOptions(true);
            }
            return ToolFactory.createCodeFormatter(options);
        }

        public static String formatCode(String contents, Object codeFormatter, String lineDelimiter, boolean formatComments) {
            Document doc;
            TextEdit edit;
            if (codeFormatter instanceof CodeFormatter && (edit = ((CodeFormatter)codeFormatter).format(8 | (formatComments ? 4096 : 0), (doc = new Document(contents)).get(), 0, doc.get().length(), 0, lineDelimiter)) != null) {
                try {
                    edit.apply((IDocument)doc);
                    contents = doc.get();
                }
                catch (Exception exception) {
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                }
            }
            return contents;
        }

        public static String organizeImports(String workspacePath, String contents) {
            IJavaProject javaProject;
            final String[] result = new String[]{contents};
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePath));
            IProject project = file.getProject();
            if (project != null && (javaProject = JavaCore.create((IProject)project)) != null) {
                ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)file);
                WorkingCopyOwner workingCopyOwner = new WorkingCopyOwner(){

                    public IBuffer createBuffer(final ICompilationUnit workingCopy) {
                        return new IBuffer(){

                            public IOpenable getOwner() {
                                return workingCopy;
                            }

                            public String getText(int offset, int length) throws IndexOutOfBoundsException {
                                return result[0].substring(offset, offset + length);
                            }

                            public int getLength() {
                                return result[0].length();
                            }

                            public String getContents() {
                                return result[0];
                            }

                            public char[] getCharacters() {
                                return result[0].toCharArray();
                            }

                            public char getChar(int position) {
                                return result[0].charAt(position);
                            }

                            public boolean isReadOnly() {
                                return true;
                            }

                            public boolean isClosed() {
                                return false;
                            }

                            public boolean hasUnsavedChanges() {
                                return false;
                            }

                            public IResource getUnderlyingResource() {
                                return null;
                            }

                            public void close() {
                            }

                            public void save(IProgressMonitor progress, boolean force) throws JavaModelException {
                                throw new UnsupportedOperationException();
                            }

                            public void setContents(String contents) {
                                throw new UnsupportedOperationException();
                            }

                            public void setContents(char[] contents) {
                                throw new UnsupportedOperationException();
                            }

                            public void replace(int position, int length, String text) {
                                throw new UnsupportedOperationException();
                            }

                            public void replace(int position, int length, char[] text) {
                                throw new UnsupportedOperationException();
                            }

                            public void append(String text) {
                                throw new UnsupportedOperationException();
                            }

                            public void append(char[] text) {
                                throw new UnsupportedOperationException();
                            }

                            public void addBufferChangedListener(IBufferChangedListener listener) {
                            }

                            public void removeBufferChangedListener(IBufferChangedListener listener) {
                            }
                        };
                    }
                };
                try {
                    ICompilationUnit workingCopy = compilationUnit.getWorkingCopy(workingCopyOwner, null);
                    ASTParser astParser = CodeGenUtil.EclipseUtil.newASTParser((boolean)true);
                    astParser.setCompilerOptions(Collections.singletonMap("org.eclipse.jdt.core.compiler.problem.unusedImport", "error"));
                    astParser.setResolveBindings(true);
                    astParser.setProject(javaProject);
                    ASTRequestor unusedImportRemover = new ASTRequestor(){

                        public void acceptAST(ICompilationUnit sourceUnit, CompilationUnit compiledUnit) {
                            final HashSet<String> unusedImports = new HashSet<String>();
                            IProblem[] problems = compiledUnit.getProblems();
                            boolean onlyUnusedImportErrors = true;
                            IProblem[] iProblemArray = problems;
                            int n = problems.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IProblem problem = iProblemArray[n2];
                                int id = problem.getID();
                                if (id != 268435844) {
                                    onlyUnusedImportErrors = false;
                                    break;
                                }
                                unusedImports.add(problem.getArguments()[0]);
                                ++n2;
                            }
                            if (!onlyUnusedImportErrors) {
                                List imports = compiledUnit.imports();
                                for (ImportDeclaration importDeclaration : imports) {
                                    if (importDeclaration.isStatic() || importDeclaration.isOnDemand()) continue;
                                    unusedImports.add(importDeclaration.getName().getFullyQualifiedName());
                                }
                                compiledUnit.accept(new ASTVisitor(true){

                                    public boolean visit(ImportDeclaration node) {
                                        return false;
                                    }

                                    public boolean visit(QualifiedName node) {
                                        Name name = node.getQualifier();
                                        while (name.isQualifiedName()) {
                                            name = ((QualifiedName)name).getQualifier();
                                        }
                                        this.visit((SimpleName)name);
                                        return false;
                                    }

                                    public boolean visit(SimpleName node) {
                                        ITypeBinding erasure;
                                        IBinding binding = node.resolveBinding();
                                        if (binding instanceof ITypeBinding && (erasure = ((ITypeBinding)binding).getErasure()) != null) {
                                            unusedImports.remove(erasure.getQualifiedName());
                                            return false;
                                        }
                                        String suffix = "." + node.getIdentifier();
                                        for (String unusedImport : unusedImports) {
                                            if (!unusedImport.endsWith(suffix)) continue;
                                            unusedImports.remove(unusedImport);
                                            break;
                                        }
                                        return false;
                                    }
                                });
                                IProblem[] iProblemArray2 = problems;
                                int n3 = problems.length;
                                n = 0;
                                while (n < n3) {
                                    IProblem problem = iProblemArray2[n];
                                    int id = problem.getID();
                                    if (id == 0x1000002 || id == 33554515) {
                                        String suffix = "." + problem.getArguments()[0];
                                        for (String unusedImport : unusedImports) {
                                            if (!unusedImport.endsWith(suffix)) continue;
                                            unusedImports.remove(unusedImport);
                                            break;
                                        }
                                    }
                                    ++n;
                                }
                            }
                            if (!unusedImports.isEmpty()) {
                                ImportRewrite importRewrite;
                                try {
                                    importRewrite = ImportRewrite.create((ICompilationUnit)sourceUnit, (boolean)true);
                                }
                                catch (JavaModelException e) {
                                    return;
                                }
                                for (String unusedImport : unusedImports) {
                                    boolean removed = importRewrite.removeImport(unusedImport);
                                    if (removed) continue;
                                    importRewrite.removeImport(String.valueOf(unusedImport) + ".*");
                                }
                                try {
                                    TextEdit textEdits = importRewrite.rewriteImports(null);
                                    Document document = new Document(result[0]);
                                    textEdits.apply((IDocument)document);
                                    result[0] = document.get();
                                }
                                catch (BadLocationException exception) {
                                    return;
                                }
                                catch (CoreException exception) {
                                    return;
                                }
                            }
                        }
                    };
                    astParser.createASTs(new ICompilationUnit[]{workingCopy}, new String[0], unusedImportRemover, null);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            return result[0];
        }
    }

    protected static final class ExtensionData {
        public String extensionPointID;
        public String identifier;
        public String generated;
        public int start;
        public int end;
        public String content;
        public String lineSeparator;

        protected ExtensionData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ExtensionData) {
                ExtensionData extension = (ExtensionData)object;
                return extension.extensionPointID.equals(this.extensionPointID) && (extension.identifier == null ? this.identifier == null : extension.identifier.equals(this.identifier));
            }
            return false;
        }

        public int hashCode() {
            return this.extensionPointID.hashCode() ^ (this.identifier == null ? 0 : this.identifier.hashCode());
        }

        public String toString() {
            return String.valueOf(this.extensionPointID) + ":" + this.identifier + ":" + this.generated;
        }
    }

    protected static class JETEmitterDescriptor {
        public String templatePathName;
        public String className;

        public JETEmitterDescriptor(String templatePathName, String className) {
            this.templatePathName = templatePathName;
            this.className = className;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManifestElement {
        private static final Set<String> OSGI_ATTRIBUTES = new HashSet<String>(Arrays.asList("Bundle-ManifestVersion", "Bundle-SymbolicName", "Bundle-Version", "Bundle-Localization", "Bundle-Name", "Bundle-Vendor", "Bundle-ClassPath", "Bundle-Activator", "Bundle-ActivationPolicy", "Bundle-RequiredExecutionEnvironment", "Require-Bundle", "Import-Package", "Export-Package", "Provide-Capability"));
        private final String[] valueComponents;
        private Map<String, Object> attributes;
        private Map<String, Object> directives;

        private ManifestElement(String[] valueComponents) {
            this.valueComponents = valueComponents;
        }

        public String[] getValueComponents() {
            return this.valueComponents;
        }

        public String getAttribute(String key) {
            return this.getTableValue(this.attributes, key);
        }

        public Enumeration<String> getKeys() {
            return this.getTableKeys(this.attributes);
        }

        private void addAttribute(String key, String value) {
            this.attributes = this.addTableValue(this.attributes, key, value);
        }

        public String getDirective(String key) {
            return this.getTableValue(this.directives, key);
        }

        public Enumeration<String> getDirectiveKeys() {
            return this.getTableKeys(this.directives);
        }

        private void addDirective(String key, String value) {
            this.directives = this.addTableValue(this.directives, key, value);
        }

        private String getTableValue(Map<String, Object> table, String key) {
            if (table == null) {
                return null;
            }
            Object result = table.get(key);
            if (result == null) {
                return null;
            }
            if (result instanceof String) {
                return (String)result;
            }
            List valueList = (List)result;
            return (String)valueList.get(valueList.size() - 1);
        }

        private Enumeration<String> getTableKeys(Map<String, Object> table) {
            if (table == null) {
                return null;
            }
            return Collections.enumeration(table.keySet());
        }

        private Map<String, Object> addTableValue(Map<String, Object> table, String key, String value) {
            Object curValue;
            if (table == null) {
                table = new LinkedHashMap<String, Object>(7);
            }
            if ((curValue = table.get(key)) != null) {
                ArrayList<String> newList;
                if (curValue instanceof List) {
                    newList = (ArrayList<String>)curValue;
                } else {
                    newList = new ArrayList<String>(5);
                    newList.add((String)curValue);
                }
                newList.add(value);
                table.put(key, newList);
            } else {
                table.put(key, value);
            }
            return table;
        }

        /*
         * Exception decompiling
         */
        public static ManifestElement[] parseHeader(String header, String value) throws IllegalArgumentException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public static List<AttributeData.Element> getElements(String name, String value) {
            ArrayList<AttributeData.Element> elements = null;
            if (OSGI_ATTRIBUTES.contains(name)) {
                try {
                    ManifestElement[] header = ManifestElement.parseHeader(name, value);
                    if (header != null) {
                        elements = new ArrayList<AttributeData.Element>();
                        ManifestElement[] manifestElementArray = header;
                        int n = header.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Enumeration<String> attributeKeys;
                            String[] valueComponents;
                            ManifestElement manifestElement = manifestElementArray[n2];
                            AttributeData.Element element = new AttributeData.Element();
                            elements.add(element);
                            String[] stringArray = valueComponents = manifestElement.getValueComponents();
                            int n3 = valueComponents.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String valueComponent = stringArray[n4];
                                element.valueComponents.add(valueComponent);
                                ++n4;
                            }
                            Enumeration<String> directiveKeys = manifestElement.getDirectiveKeys();
                            if (directiveKeys != null) {
                                while (directiveKeys.hasMoreElements()) {
                                    AttributeData.Element.Directive directive = new AttributeData.Element.Directive();
                                    directive.key = directiveKeys.nextElement();
                                    directive.value = manifestElement.getDirective(directive.key);
                                    element.directives.add(directive);
                                }
                            }
                            if ((attributeKeys = manifestElement.getKeys()) != null) {
                                while (attributeKeys.hasMoreElements()) {
                                    AttributeData.Element.Attribute attribute = new AttributeData.Element.Attribute();
                                    attribute.key = attributeKeys.nextElement();
                                    attribute.value = manifestElement.getAttribute(attribute.key);
                                    element.attributes.add(attribute);
                                }
                            }
                            ++n2;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return elements;
        }

        private static class Tokenizer {
            protected final char[] value;
            protected final int max;
            protected int cursor;

            public Tokenizer(String value) {
                this.value = value.toCharArray();
                this.max = this.value.length;
                this.cursor = 0;
            }

            private void skipWhiteSpace() {
                char[] val = this.value;
                int cur = this.cursor;
                while (cur < this.max) {
                    char c = val[cur];
                    if (c != ' ' && c != '\t' && c != '\n' && c != '\r') break;
                    ++cur;
                }
                this.cursor = cur;
            }

            public String getToken(String terminals) {
                int cur;
                this.skipWhiteSpace();
                char[] val = this.value;
                int begin = cur = this.cursor;
                while (cur < this.max) {
                    char c = val[cur];
                    if (terminals.indexOf(c) != -1) break;
                    ++cur;
                }
                this.cursor = cur;
                int count = cur - begin;
                if (count > 0) {
                    this.skipWhiteSpace();
                    while (count > 0 && (val[begin + count - 1] == ' ' || val[begin + count - 1] == '\t')) {
                        --count;
                    }
                    return new String(val, begin, count);
                }
                return null;
            }

            public String getString(String terminals, String preserveEscapes) {
                this.skipWhiteSpace();
                char[] val = this.value;
                int cur = this.cursor;
                if (cur < this.max) {
                    if (val[cur] == '\"') {
                        StringBuilder sb = new StringBuilder();
                        ++cur;
                        char c = '\u0000';
                        while (cur < this.max) {
                            c = val[cur];
                            if (c == '\\') {
                                if (++cur == this.max) break;
                                c = val[cur];
                                if (preserveEscapes != null && preserveEscapes.indexOf(c) != -1) {
                                    sb.append('\\');
                                }
                            } else if (c == '\"') break;
                            sb.append(c);
                            ++cur;
                        }
                        if (c == '\"') {
                            ++cur;
                        }
                        this.cursor = cur;
                        this.skipWhiteSpace();
                        return sb.toString();
                    }
                    return this.getToken(terminals);
                }
                return null;
            }

            public String getString(String terminals) {
                return this.getString(terminals, null);
            }

            public char getChar() {
                int cur = this.cursor;
                if (cur < this.max) {
                    this.cursor = cur + 1;
                    return this.value[cur];
                }
                return '\u0000';
            }
        }
    }
}

