/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.NoCommentSourceRangeComputer;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocationCore;
import org.eclipse.text.edits.TextEditGroup;

public class TypeParametersFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public static TypeParametersFixCore createInsertInferredTypeArgumentsFix(CompilationUnit compilationUnit, ParameterizedType node) {
        if (node == null) {
            return null;
        }
        ArrayList<ASTNode> changedNodes = new ArrayList<ASTNode>();
        node.accept((ASTVisitor)new InsertTypeArgumentsVisitor(changedNodes));
        if (changedNodes.isEmpty()) {
            return null;
        }
        InsertTypeArgumentsOperation op = new InsertTypeArgumentsOperation(new ParameterizedType[]{node});
        return new TypeParametersFixCore(FixMessages.TypeParametersFix_insert_inferred_type_arguments_name, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
    }

    public static IProposableFix createRemoveRedundantTypeArgumentsFix(CompilationUnit compilationUnit, IProblemLocationCore problem) {
        int id = problem.getProblemId();
        if (id == 16778100) {
            ParameterizedType parameterizedType = TypeParametersFixCore.getParameterizedType(compilationUnit, problem);
            if (parameterizedType == null) {
                return null;
            }
            RemoveTypeArgumentsOperation operation = new RemoveTypeArgumentsOperation(parameterizedType);
            return new TypeParametersFixCore(FixMessages.TypeParametersFix_remove_redundant_type_arguments_name, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation});
        }
        return null;
    }

    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit, boolean insertInferredTypeArguments, boolean removeRedundantTypeArguments) {
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocationCore[] locations = new IProblemLocationCore[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocationCore(problems[i]);
            ++i;
        }
        return TypeParametersFixCore.createCleanUp(compilationUnit, locations, insertInferredTypeArguments, removeRedundantTypeArguments);
    }

    public static ICleanUpFixCore createCleanUp(CompilationUnit compilationUnit, IProblemLocationCore[] problems, boolean insertInferredTypeArguments, boolean removeRedundantTypeArguments) {
        if (insertInferredTypeArguments) {
            ArrayList<ASTNode> changedNodes = new ArrayList<ASTNode>();
            compilationUnit.accept((ASTVisitor)new InsertTypeArgumentsVisitor(changedNodes));
            if (changedNodes.isEmpty()) {
                return null;
            }
            InsertTypeArgumentsOperation op = new InsertTypeArgumentsOperation(changedNodes.toArray(new ParameterizedType[changedNodes.size()]));
            return new TypeParametersFixCore(FixMessages.TypeParametersFix_insert_inferred_type_arguments_name, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{op});
        }
        if (removeRedundantTypeArguments) {
            ArrayList<RemoveTypeArgumentsOperation> result = new ArrayList<RemoveTypeArgumentsOperation>();
            IProblemLocationCore[] iProblemLocationCoreArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                IProblemLocationCore problem = iProblemLocationCoreArray[n2];
                int id = problem.getProblemId();
                if (id == 16778100) {
                    ParameterizedType parameterizedType = TypeParametersFixCore.getParameterizedType(compilationUnit, problem);
                    if (parameterizedType == null) {
                        return null;
                    }
                    result.add(new RemoveTypeArgumentsOperation(parameterizedType));
                }
                ++n2;
            }
            if (!result.isEmpty()) {
                return new TypeParametersFixCore(FixMessages.TypeParametersFix_remove_redundant_type_arguments_name, compilationUnit, result.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[result.size()]));
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static ParameterizedType getParameterizedType(CompilationUnit compilationUnit, IProblemLocationCore problem) {
        selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            selectedNode = selectedNode.getParent();
lbl5:
            // 2 sources

            ** while (!(selectedNode instanceof ParameterizedType) && !(selectedNode instanceof Statement))
        }
lbl6:
        // 1 sources

        if (selectedNode instanceof ParameterizedType) {
            return (ParameterizedType)selectedNode;
        }
        return null;
    }

    protected TypeParametersFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    public static class InsertTypeArgumentsOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ParameterizedType[] fCreatedTypes;

        public InsertTypeArgumentsOperation(ParameterizedType[] parameterizedTypes) {
            this.fCreatedTypes = parameterizedTypes;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.TypeParametersFix_insert_inferred_type_arguments_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            ParameterizedType[] parameterizedTypeArray = this.fCreatedTypes;
            int n = this.fCreatedTypes.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterizedType createdType = parameterizedTypeArray[n2];
                ITypeBinding[] typeArguments = createdType.resolveBinding().getTypeArguments();
                ContextSensitiveImportRewriteContext importContext = new ContextSensitiveImportRewriteContext(cuRewrite.getRoot(), createdType.getStartPosition(), importRewrite);
                ListRewrite argumentsRewrite = rewrite.getListRewrite((ASTNode)createdType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
                ITypeBinding[] iTypeBindingArray = typeArguments;
                int n3 = typeArguments.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding typeArgument = iTypeBindingArray[n4];
                    Type argumentNode = importRewrite.addImport(typeArgument, ast, (ImportRewrite.ImportRewriteContext)importContext, ImportRewrite.TypeLocation.TYPE_ARGUMENT);
                    argumentsRewrite.insertLast((ASTNode)argumentNode, group);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public static final class InsertTypeArgumentsVisitor
    extends ASTVisitor {
        private final ArrayList<ASTNode> fNodes;

        public InsertTypeArgumentsVisitor(ArrayList<ASTNode> nodes) {
            this.fNodes = nodes;
        }

        public boolean visit(ParameterizedType createdType) {
            if (createdType == null || createdType.typeArguments().size() != 0) {
                return true;
            }
            ITypeBinding binding = createdType.resolveBinding();
            if (binding == null) {
                return true;
            }
            ITypeBinding[] typeArguments = binding.getTypeArguments();
            if (typeArguments.length == 0) {
                return true;
            }
            this.fNodes.add((ASTNode)createdType);
            return true;
        }
    }

    public static class RemoveTypeArgumentsOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ParameterizedType fParameterizedType;

        public RemoveTypeArgumentsOperation(ParameterizedType parameterizedType) {
            this.fParameterizedType = parameterizedType;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(FixMessages.TypeParametersFix_remove_redundant_type_arguments_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            rewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)new NoCommentSourceRangeComputer());
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)this.fParameterizedType, ParameterizedType.TYPE_ARGUMENTS_PROPERTY);
            List typeArguments = this.fParameterizedType.typeArguments();
            for (Type typeArgument : typeArguments) {
                listRewrite.remove((ASTNode)typeArgument, group);
            }
        }
    }
}

