/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import org.eclipse.birt.data.oda.pojo.querymodel.ConstantParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.IMethodParameter;
import org.eclipse.birt.data.oda.pojo.querymodel.VariableParameter;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.util.HelpUtil;
import org.eclipse.birt.data.oda.pojo.util.MethodParameterType;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MethodParameterDialog
extends StatusDialog {
    private IModifyValidator validator;
    private Text nameText;
    private Button checkBtn;
    private static String TITLE = Messages.getString("MethodParameterDialog.edit.title");
    private IMethodParameter param;
    private String name;
    private String type;
    private String value;
    private boolean toBeMapped;

    protected MethodParameterDialog(IMethodParameter param) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell());
        this.param = param;
        this.name = param instanceof VariableParameter ? ((VariableParameter)param).getName() : "";
        this.type = param.getDataType();
        this.value = param.getStringValue() == null ? "" : param.getStringValue().toString();
    }

    public void create() {
        super.create();
        Point pt = this.getShell().computeSize(-1, -1);
        pt.x = Math.max(pt.x, 400);
        pt.y = Math.max(pt.y, 200);
        this.getShell().setSize(pt);
        this.getShell().setText(TITLE);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 20;
        layout.marginWidth = 20;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createDialogContent(composite);
        HelpUtil.setSystemHelp((Control)composite, "org.eclipse.birt.cshelp.Wizard_POJO_Dataset_MethodParameter_ID");
        return composite;
    }

    private void createDialogContent(Composite composite) {
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.checkBtn = new Button(composite, 32);
        this.checkBtn.setText(Messages.getString("MethodParameterDialog.checkBox.message"));
        this.checkBtn.setSelection(this.param instanceof VariableParameter);
        this.toBeMapped = this.checkBtn.getSelection();
        this.checkBtn.setLayoutData((Object)data);
        this.checkBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodParameterDialog.this.toBeMapped = MethodParameterDialog.this.checkBtn.getSelection();
                MethodParameterDialog.this.nameText.setEnabled(MethodParameterDialog.this.toBeMapped);
                MethodParameterDialog.this.nameText.setText(MethodParameterDialog.this.toBeMapped ? MethodParameterDialog.this.name : "N/A");
                MethodParameterDialog.this.validateSyntax();
            }
        });
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("MethodParameterDialog.label.name"));
        GridData gd = new GridData(768);
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)gd);
        this.nameText.setEnabled(this.toBeMapped);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MethodParameterDialog.this.nameText.isEnabled()) {
                    MethodParameterDialog.this.name = MethodParameterDialog.this.nameText.getText();
                }
                MethodParameterDialog.this.validateSyntax();
            }
        });
        Label valueLabel = new Label(composite, 0);
        valueLabel.setText(Messages.getString("MethodParameterDialog.label.value"));
        final Text valueText = new Text(composite, 2048);
        valueText.setLayoutData((Object)gd);
        valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodParameterDialog.this.value = valueText.getText();
                MethodParameterDialog.this.validateSyntax();
            }
        });
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(Messages.getString("MethodParameterDialog.label.dataType"));
        final ComboViewer comboTypes = new ComboViewer(composite, 2048);
        GridData comboData = new GridData(768);
        comboTypes.getCombo().setLayoutData((Object)comboData);
        comboTypes.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object arg0) {
                MethodParameterType[] types = MethodParameterType.getBuiltins();
                Object[] names = new String[types.length];
                int i = 0;
                while (i < types.length) {
                    names[i] = types[i].getName();
                    ++i;
                }
                return names;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        comboTypes.setInput((Object)"");
        comboTypes.getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodParameterDialog.this.type = comboTypes.getCombo().getText();
                MethodParameterDialog.this.validateSyntax();
            }
        });
        comboTypes.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodParameterDialog.this.type = comboTypes.getCombo().getText();
                MethodParameterDialog.this.validateSyntax();
            }
        });
        if (this.param != null) {
            if (this.toBeMapped) {
                this.nameText.setText(this.name == null ? "" : this.name);
            } else {
                this.nameText.setText("N/A");
            }
            valueText.setText(this.value == null ? "" : this.value);
            comboTypes.getCombo().setText(this.type == null ? "" : this.type);
        }
        this.validateSyntax();
    }

    private void validateSyntax() {
        Status status = null;
        if (this.type == null || this.type.trim().length() == 0) {
            status = this.getMiscStatus(4, Messages.getString("MethodParameterDialog.error.missingDataType"));
        } else if (this.toBeMapped && (this.name == null || this.name.trim().length() == 0)) {
            status = this.getMiscStatus(4, Messages.getString("MethodParameterDialog.error.missingName"));
        } else if (!(this.toBeMapped || this.value != null && this.value.trim().length() != 0)) {
            status = this.getMiscStatus(4, Messages.getString("MethodParameterDialog.error.missingValue"));
        } else if (this.validator != null) {
            Object[] args = new String[]{this.name, this.type};
            status = this.param instanceof VariableParameter && !this.validator.validateInputValue((VariableParameter)this.param, args) ? this.getMiscStatus(4, Messages.getFormattedString("MethodParameterDialog.error.invalidParamName", new Object[]{this.name})) : (!this.validator.validateInputValue(new VariableParameter(this.name, this.type), args) ? this.getMiscStatus(4, Messages.getFormattedString("MethodParameterDialog.error.invalidParamName", new Object[]{this.name})) : this.getOKStatus());
        } else {
            status = this.getOKStatus();
        }
        if (status != null) {
            this.updateStatus((IStatus)status);
        }
    }

    private Status getMiscStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.ui", severity, message, null);
    }

    private Status getOKStatus() {
        return this.getMiscStatus(0, "");
    }

    protected IMethodParameter updateMethodParameter() {
        if (this.toBeMapped) {
            this.param = new VariableParameter(this.name, this.type);
            ((VariableParameter)this.param).setName(this.name);
        } else {
            this.param = new ConstantParameter(this.value.toString(), this.type);
        }
        this.param.setDataType(this.type);
        this.param.setStringValue(this.value);
        return this.param;
    }

    public void setValidator(IModifyValidator validator) {
        this.validator = validator;
    }

    public static interface IModifyValidator {
        public boolean validateInputValue(Object var1, Object[] var2);
    }
}

