/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.SloppyMath;

class LatLonPointDistanceComparator
extends FieldComparator<Double>
implements LeafFieldComparator {
    final String field;
    final double latitude;
    final double longitude;
    final double[] values;
    double bottom;
    double topValue;
    SortedNumericDocValues currentDocs;
    int minLon = Integer.MIN_VALUE;
    int maxLon = Integer.MAX_VALUE;
    int minLat = Integer.MIN_VALUE;
    int maxLat = Integer.MAX_VALUE;
    int minLon2 = Integer.MAX_VALUE;
    int setBottomCounter = 0;
    private long[] currentValues = new long[4];
    private int valuesDocID = -1;

    public LatLonPointDistanceComparator(String field, double latitude, double longitude, int numHits) {
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.values = new double[numHits];
    }

    @Override
    public void setScorer(Scorer scorer) {
    }

    @Override
    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    @Override
    public void setBottom(int slot) {
        this.bottom = this.values[slot];
        if (this.setBottomCounter < 1024 || (this.setBottomCounter & 0x3F) == 63) {
            Rectangle box = Rectangle.fromPointDistance(this.latitude, this.longitude, LatLonPointDistanceComparator.haversin2(this.bottom));
            this.minLat = GeoEncodingUtils.encodeLatitude(box.minLat);
            this.maxLat = GeoEncodingUtils.encodeLatitude(box.maxLat);
            if (box.crossesDateline()) {
                this.minLon = Integer.MIN_VALUE;
                this.maxLon = GeoEncodingUtils.encodeLongitude(box.maxLon);
                this.minLon2 = GeoEncodingUtils.encodeLongitude(box.minLon);
            } else {
                this.minLon = GeoEncodingUtils.encodeLongitude(box.minLon);
                this.maxLon = GeoEncodingUtils.encodeLongitude(box.maxLon);
                this.minLon2 = Integer.MAX_VALUE;
            }
        }
        ++this.setBottomCounter;
    }

    @Override
    public void setTopValue(Double value) {
        this.topValue = value;
    }

    private void setValues() throws IOException {
        if (this.valuesDocID != this.currentDocs.docID()) {
            assert (this.valuesDocID < this.currentDocs.docID()) : " valuesDocID=" + this.valuesDocID + " vs " + this.currentDocs.docID();
            this.valuesDocID = this.currentDocs.docID();
            int count = this.currentDocs.docValueCount();
            if (count > this.currentValues.length) {
                this.currentValues = new long[ArrayUtil.oversize(count, 8)];
            }
            for (int i = 0; i < count; ++i) {
                this.currentValues[i] = this.currentDocs.nextValue();
            }
        }
    }

    @Override
    public int compareBottom(int doc) throws IOException {
        if (doc > this.currentDocs.docID()) {
            this.currentDocs.advance(doc);
        }
        if (doc < this.currentDocs.docID()) {
            return Double.compare(this.bottom, Double.POSITIVE_INFINITY);
        }
        this.setValues();
        int numValues = this.currentDocs.docValueCount();
        int cmp = -1;
        for (int i = 0; i < numValues; ++i) {
            double docLongitude;
            double docLatitude;
            int longitudeBits;
            long encoded = this.currentValues[i];
            int latitudeBits = (int)(encoded >> 32);
            if (latitudeBits < this.minLat || latitudeBits > this.maxLat || ((longitudeBits = (int)(encoded & 0xFFFFFFFFFFFFFFFFL)) < this.minLon || longitudeBits > this.maxLon) && longitudeBits < this.minLon2 || (cmp = Math.max(cmp, Double.compare(this.bottom, SloppyMath.haversinSortKey(this.latitude, this.longitude, docLatitude = GeoEncodingUtils.decodeLatitude(latitudeBits), docLongitude = GeoEncodingUtils.decodeLongitude(longitudeBits))))) <= 0) continue;
            return cmp;
        }
        return cmp;
    }

    @Override
    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.sortKey(doc);
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.field);
        if (info != null) {
            LatLonDocValuesField.checkCompatible(info);
        }
        this.currentDocs = DocValues.getSortedNumeric(reader, this.field);
        this.valuesDocID = -1;
        return this;
    }

    @Override
    public Double value(int slot) {
        return LatLonPointDistanceComparator.haversin2(this.values[slot]);
    }

    @Override
    public int compareTop(int doc) throws IOException {
        return Double.compare(this.topValue, LatLonPointDistanceComparator.haversin2(this.sortKey(doc)));
    }

    double sortKey(int doc) throws IOException {
        if (doc > this.currentDocs.docID()) {
            this.currentDocs.advance(doc);
        }
        double minValue = Double.POSITIVE_INFINITY;
        if (doc == this.currentDocs.docID()) {
            this.setValues();
            int numValues = this.currentDocs.docValueCount();
            for (int i = 0; i < numValues; ++i) {
                long encoded = this.currentValues[i];
                double docLatitude = GeoEncodingUtils.decodeLatitude((int)(encoded >> 32));
                double docLongitude = GeoEncodingUtils.decodeLongitude((int)(encoded & 0xFFFFFFFFFFFFFFFFL));
                minValue = Math.min(minValue, SloppyMath.haversinSortKey(this.latitude, this.longitude, docLatitude, docLongitude));
            }
        }
        return minValue;
    }

    static double haversin2(double partial) {
        if (Double.isInfinite(partial)) {
            return partial;
        }
        return SloppyMath.haversinMeters(partial);
    }
}

