/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.graphics.Image;

public class TasksUiImages {
    private static final URL baseURL = TasksUiPlugin.getDefault().getBundle().getEntry("/icons/");
    private static final String VIEW = "eview16";
    private static final String TOOL = "etool16";
    private static final String TOOL_SMALL = "etool12";
    private static final String OBJ = "obj16";
    private static final String OVERLAY = "ovr16";
    private static final String WIZBAN = "wizban";
    public static final ImageDescriptor TASK = TasksUiImages.create("etool16", "task.png");
    public static final ImageDescriptor TASK_COMPLETE = TasksUiImages.create("etool16", "task-complete.png");
    public static final ImageDescriptor TASK_INCOMPLETE = TasksUiImages.create("etool16", "task-incomplete.png");
    public static final ImageDescriptor TASK_COMPLETED = TasksUiImages.create("etool16", "task-completed.png");
    public static final ImageDescriptor TASK_NOTES = TasksUiImages.create("etool16", "task-notes.png");
    public static final ImageDescriptor TASK_NEW = TasksUiImages.create("etool16", "task-new.png");
    public static final ImageDescriptor TASK_NEW_SUB = TasksUiImages.create("etool16", "sub-task-new.png");
    public static final ImageDescriptor TASK_REPOSITORY_HISTORY = TasksUiImages.create("etool16", "task-repository-history.png");
    public static final ImageDescriptor TASK_REMOTE = TasksUiImages.create("etool16", "task-remote.png");
    public static final ImageDescriptor TASK_WORKING_SET = TasksUiImages.create("etool16", "open-task.png");
    public static final ImageDescriptor TASKS_VIEW = TasksUiImages.create("eview16", "task-list.png");
    public static final ImageDescriptor TASK_ATTACHMENT_PATCH = TasksUiImages.create("obj16", "attachment-patch.png");
    public static final ImageDescriptor TASK_OWNED = TasksUiImages.create("etool16", "task-owned.png");
    public static final ImageDescriptor FILTER_OBSOLETE_SMALL = TasksUiImages.create("etool12", "file-delete-line-12x12.png");
    public static final ImageDescriptor FILE_NEW_SMALL = TasksUiImages.create("etool12", "file-new-12x12.png");
    public static final ImageDescriptor TASK_RETRIEVE = TasksUiImages.create("etool16", "task-retrieve.png");
    public static final ImageDescriptor TASK_REPOSITORY = TasksUiImages.create("etool16", "task-repository.png");
    public static final ImageDescriptor TASK_REPOSITORY_NEW = TasksUiImages.create("etool16", "task-repository-new.png");
    public static final ImageDescriptor CATEGORY = TasksUiImages.create("etool16", "category.png");
    public static final ImageDescriptor CATEGORY_NEW = TasksUiImages.create("etool16", "category-new.png");
    public static final ImageDescriptor CATEGORY_UNCATEGORIZED = TasksUiImages.create("etool16", "category-archive.png");
    public static final ImageDescriptor QUERY = TasksUiImages.create("etool16", "query.png");
    public static final ImageDescriptor QUERY_NEW = TasksUiImages.create("etool16", "query-new.png");
    public static final ImageDescriptor QUERY_OFFLINE = ImageDescriptor.createWithFlags((ImageDescriptor)QUERY, (int)2);
    public static final ImageDescriptor QUERY_UNMATCHED = TasksUiImages.create("etool16", "query-unmatched.png");
    public static final ImageDescriptor REPOSITORY = TasksUiImages.create("eview16", "repositories.png");
    public static final ImageDescriptor REPOSITORY_OFFLINE = ImageDescriptor.createWithFlags((ImageDescriptor)REPOSITORY, (int)2);
    public static final ImageDescriptor REPOSITORY_SYNCHRONIZE_SMALL = TasksUiImages.create("etool12", "repository-synchronize-small.png");
    public static final ImageDescriptor REPOSITORY_UPDATE_CONFIGURATION = TasksUiImages.create("etool16", "repository-synchronize-attributes.png");
    public static final ImageDescriptor REPOSITORY_SYNCHRONIZE = TasksUiImages.create("etool16", "repository-synchronize.png");
    public static final ImageDescriptor REPOSITORY_SUBMIT = TasksUiImages.create("etool16", "repository-submit.png");
    public static final ImageDescriptor REPOSITORY_SMALL = TasksUiImages.create("obj16", "repository-small.png");
    public static final ImageDescriptor REPOSITORY_NEW = TasksUiImages.create("etool16", "repository-new.png");
    public static final ImageDescriptor REPOSITORY_VALIDATE = TasksUiImages.create("obj16", "resource_obj.png");
    public static final ImageDescriptor REPOSITORIES_VIEW = TasksUiImages.create("eview16", "repositories.png");
    public static final ImageDescriptor CONTEXT_ACTIVE = TasksUiImages.create("etool16", "task-active.png");
    public static final ImageDescriptor CONTEXT_ACTIVE_CENTERED = TasksUiImages.create("etool16", "task-active-centered.png");
    public static final ImageDescriptor CONTEXT_INACTIVE_EMPTY = TasksUiImages.create("etool16", "task-inactive.png");
    public static final ImageDescriptor CONTEXT_INACTIVE = TasksUiImages.create("etool16", "task-context.png");
    public static final ImageDescriptor CONTEXT_FOCUS = TasksUiImages.create("eview16", "focus.png");
    public static final ImageDescriptor CONTEXT_ATTACH = TasksUiImages.create("etool16", "context-attach.png");
    public static final ImageDescriptor CONTEXT_RETRIEVE = TasksUiImages.create("etool16", "context-retrieve.png");
    public static final ImageDescriptor CONTEXT_TRANSFER = TasksUiImages.create("etool16", "context-transfer.png");
    public static final ImageDescriptor CONTEXT_CLEAR = TasksUiImages.create("etool16", "context-clear.png");
    public static final ImageDescriptor CONTEXT_HISTORY_PREVIOUS = TasksUiImages.create("etool16", "navigate-previous.png");
    @Deprecated
    public static final ImageDescriptor CONTEXT_HISTORY_PREVIOUS_PAUSE = TasksUiImages.create("etool16", "navigate-previous-pause.png");
    public static final ImageDescriptor CONTEXT_HISTORY_PREVIOUS_ACTIVE = TasksUiImages.create("etool16", "navigate-previous-active.png");
    public static final ImageDescriptor CONTEXT_HISTORY_NEXT = TasksUiImages.create("etool16", "navigate-next.png");
    public static final ImageDescriptor CONTEXT_CAPTURE_PAUSE = TasksUiImages.create("etool16", "capture-pause.png");
    public static final ImageDescriptor CONTEXT_ADD = TasksUiImages.create("etool16", "context-add.png");
    public static final ImageDescriptor CONTEXT_COPY = TasksUiImages.create("etool16", "context-transfer.png");
    public static final ImageDescriptor COMMENT = TasksUiImages.create("etool16", "comment.png");
    public static final ImageDescriptor COMMENT_SORT_DOWN = TasksUiImages.create("etool16", "sort-down.gif");
    public static final ImageDescriptor COMMENT_SORT_UP = TasksUiImages.create("etool16", "sort-up.gif");
    public static final ImageDescriptor COMMENT_SORT_DOWN_GRAY = TasksUiImages.create("etool16", "sort-down-gray.gif");
    public static final ImageDescriptor COMMENT_SORT_UP_GRAY = TasksUiImages.create("etool16", "sort-up-gray.gif");
    public static final ImageDescriptor COMMENT_REPLY = TasksUiImages.create("etool16", "reply.png");
    public static final ImageDescriptor COMMENT_REPLY_SMALL = TasksUiImages.create("etool12", "reply.png");
    public static final ImageDescriptor BANNER_REPOSITORY = TasksUiImages.create("wizban", "banner-repository.gif");
    public static final ImageDescriptor BANNER_REPOSITORY_SETTINGS = TasksUiImages.create("wizban", "banner-repository-settings.gif");
    public static final ImageDescriptor BANNER_REPOSITORY_CONTEXT = TasksUiImages.create("wizban", "banner-repository-context.gif");
    public static final ImageDescriptor BANNER_WORKING_SET = TasksUiImages.create("wizban", "workset_wiz.png");
    public static final ImageDescriptor PRESENTATION_CATEGORIZED = TasksUiImages.create("etool16", "presentation-categorized.png");
    public static final ImageDescriptor PRESENTATION_SCHEDULED = TasksUiImages.create("etool16", "presentation-scheduled.png");
    public static final ImageDescriptor BANNER_REPORT_BUG = TasksUiImages.create("wizban", "bug-wizard.gif");
    public static final ImageDescriptor LOCK_CLOSE = TasksUiImages.create("etool12", "lock.png");
    public static final ImageDescriptor LOCK_OPEN = TasksUiImages.create("etool12", "unlock.png");
    public static final ImageDescriptor IMAGE_CAPTURE_SMALL = TasksUiImages.create("etool12", "image_capture.png");
    public static final ImageDescriptor NOTES = TasksUiImages.create("ovr16", "overlay-notes.png");

    public static Image getImageForPriority(ITask.PriorityLevel priorityLevel) {
        if (priorityLevel == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = TasksUiImages.getImageDescriptorForPriority(priorityLevel);
        if (imageDescriptor != null) {
            return CommonImages.getImage((ImageDescriptor)imageDescriptor);
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptorForPriority(ITask.PriorityLevel priorityLevel) {
        if (priorityLevel == null) {
            return null;
        }
        switch (priorityLevel) {
            case P1: {
                return CommonImages.PRIORITY_1;
            }
            case P2: {
                return CommonImages.PRIORITY_2;
            }
            case P3: {
                return CommonImages.PRIORITY_3;
            }
            case P4: {
                return CommonImages.PRIORITY_4;
            }
            case P5: {
                return CommonImages.PRIORITY_5;
            }
        }
        return null;
    }

    public static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)TasksUiImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }
}

