/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.insert;

import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.dialogs.MultilineInputDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.InsertHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.widgets.Display;

public class InsertTableElement {
    protected QueryInsertStatement insertStatement;
    protected ValueExpressionColumn insertColumn;
    protected QueryValueExpression valueExpr;
    SQLDomainModel domainModel;

    public InsertTableElement(SQLDomainModel model, QueryInsertStatement statement, ValueExpressionColumn column, QueryValueExpression value) {
        this.domainModel = model;
        this.insertStatement = statement;
        this.insertColumn = column;
        this.valueExpr = value;
    }

    public QueryInsertStatement getInsertStatement() {
        return this.insertStatement;
    }

    public ValueExpressionColumn getColumn() {
        return this.insertColumn;
    }

    public QueryValueExpression getExpression() {
        return this.valueExpr;
    }

    public void modify(Object key, Object value) {
        Object newValue = null;
        if (key == SQLBuilderConstants.P_STATEMENT_VALUE) {
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || strVal.equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || strVal.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                    newValue = this.showExpressionBuilder(this.getExpression(), false, (String)value);
                } else if (strVal.equals("DEFAULT")) {
                    newValue = ExpressionHelper.createValueExpressionDefaultValue();
                } else if (strVal.equals("NULL")) {
                    newValue = ExpressionHelper.createValueExpressionNullValue();
                } else if (strVal.equals(SQLBuilderConstants.P_EDIT_INPUT_VALUE)) {
                    newValue = this.showInputEditor(this.valueExpr.getSQL());
                }
            } else if (value instanceof QueryValueExpression) {
                newValue = value;
            }
            if (this.valueExpr == null) {
                if (newValue == null) {
                    newValue = ExpressionHelper.createExpression(this.getColumnText(1));
                }
                InsertHelper.addInsertColumnValuePair(this.insertStatement, this.insertColumn, (QueryValueExpression)newValue);
            } else {
                InsertHelper.updateInsertValueForColumn(this.insertStatement, this.insertColumn, (QueryValueExpression)newValue);
            }
        } else if (key == SQLBuilderConstants.P_STATEMENT_COLUMN) {
            if (this.insertColumn != null) {
                InsertHelper.replaceColumn(this.insertStatement, this.insertColumn, (ValueExpressionColumn)value);
            } else {
                AdapterFactoryEditingDomain editDomain = this.domainModel.getEditingDomain();
                Column col = TableHelper.getColumnForColumnExpression((TableExpression)this.insertStatement.getTargetTable(), (ValueExpressionColumn)((ValueExpressionColumn)value));
                InsertHelper.addColumn((EditingDomain)editDomain, this.insertStatement, col);
            }
        }
    }

    public String getColumnText(int columnIndex) {
        String columnText = "";
        if (columnIndex == 0) {
            if (this.insertColumn != null) {
                columnText = this.insertColumn.getName();
            }
        } else if (columnIndex == 1 && this.valueExpr != null) {
            columnText = this.valueExpr.getSQL();
        }
        return columnText;
    }

    public QueryValueExpression showExpressionBuilder(Object obj, boolean isColumn, String action) {
        ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(this.domainModel, (SQLQueryObject)this.domainModel.getSQLStatement());
        if (obj instanceof QueryValueExpression && action.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
            if (obj != null) {
                wizard.setInputExpression((QueryValueExpression)obj);
            } else {
                wizard.setInputExpression(null);
            }
        }
        wizard.setIsColumn(isColumn);
        ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return wizard.getSQLExpression();
        }
        if (obj != null) {
            return (QueryValueExpression)obj;
        }
        return null;
    }

    protected QueryValueExpression showInputEditor(String initialText) {
        MultilineInputDialog inputDialog = new MultilineInputDialog(Display.getDefault().getActiveShell(), Messages._UI_SPECIFY_VALUE_TITLE, this.insertColumn.getName());
        inputDialog.setText(initialText);
        inputDialog.open();
        String text = inputDialog.getText();
        QueryValueExpression expression = ExpressionHelper.createExpression(text);
        return expression;
    }
}

