/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.io.ByteArrayOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.actionhandler.AbstractChangeParameterActionHandler;
import org.eclipse.birt.report.service.actionhandler.BirtRunReportActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Page;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateContent;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtChangeParameterActionHandler
extends AbstractChangeParameterActionHandler {
    public BirtChangeParameterActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    @Override
    protected void runReport() throws Exception {
        BirtRunReportActionHandler handler = new BirtRunReportActionHandler(this.context, this.operation, this.response);
        handler.__execute();
    }

    @Override
    protected void doRenderPage(InputOptions options, String docName, long pageNumber, boolean useBookmark, String bookmark) throws ReportServiceException, RemoteException {
        ViewerAttributeBean attrBean = (ViewerAttributeBean)this.context.getBean();
        assert (attrBean != null);
        ArrayList activeIds = new ArrayList();
        ByteArrayOutputStream page = null;
        if (ParameterAccessor.isGetReportlet(this.context.getRequest())) {
            String __reportletId = attrBean.getReportletId();
            page = this.getReportService().getReportlet(docName, __reportletId, options, activeIds);
        } else {
            page = this.getReportService().getPage(docName, String.valueOf(pageNumber), options, activeIds);
        }
        UpdateContent content = new UpdateContent();
        content.setContent(DataUtil.toUTF8(page.toByteArray()));
        content.setTarget(this.operation.getTarget().getId());
        content.setInitializationId(this.parseReportId(activeIds));
        if (useBookmark) {
            content.setBookmark(bookmark);
        }
        Update updateDocument = new Update();
        updateDocument.setUpdateContent(content);
        UpdateData updateData = new UpdateData();
        updateData.setTarget("navigationBar");
        Page pageObj = new Page();
        pageObj.setPageNumber(String.valueOf(pageNumber));
        pageObj.setTotalPage(String.valueOf(this.getReportService().getPageCount(docName, options, new OutputOptions())));
        pageObj.setRtl(attrBean.isReportRtl());
        Data pageData = new Data();
        pageData.setPage(pageObj);
        updateData.setData(pageData);
        Update updateNavbar = new Update();
        updateNavbar.setUpdateData(updateData);
        UpdateData updateDocumentData = new UpdateData();
        updateDocumentData.setTarget("birtReportDocument");
        updateDocumentData.setData(pageData);
        updateDocument.setUpdateData(updateDocumentData);
        this.response.setUpdate(new Update[]{updateDocument, updateNavbar});
    }

    @Override
    protected IViewerReportService getReportService() {
        return BirtReportServiceFactory.getReportService();
    }
}

