/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.function;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.CloudscapeFunctionNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.FunctionNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.InformixFunctionNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.InstantDBFunctionNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.MSSQLServerFunctionNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.MySQLFunctionNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.OracleFunctionNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.OracleV9FunctionNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.SybaseFunctionNamesAndSignatures;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.function.FunctionExpressionWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.function.ParamTable;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.FunctionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.FunctionHelperDB2;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.StringUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FunctionBuilderPage
extends WizardPage
implements SelectionListener {
    private SQLDomainModel domainModel;
    private SQLQueryObject sqlStatement;
    private Composite paramPanel;
    private ValueExpressionFunction valueExprFunc;
    private int numOfParameters = 0;
    private Text previewExpressionText;
    private ParamTable paramTable;
    private Combo functionsCategoryCombo;
    private Combo functionsList;
    private Combo functionsSignaturesCombo;
    private int currentCategoryIndex = -1;
    private boolean isColumn;
    private String inputFunctionString = "";

    public FunctionBuilderPage(SQLDomainModel domainModel, SQLQueryObject sqlStatementArg, ValueExpressionFunction inExpr, boolean isColumn) {
        super(Messages._UI_WIZARD_FUNCTION_BUILDER_HEADING);
        this.setTitle(Messages._UI_WIZARD_FUNCTION_BUILDER_HEADING);
        this.setDescription(Messages._UI_WIZARD_FUNCTION_BUILDER_EXPL);
        this.setPageComplete(false);
        this.domainModel = domainModel;
        this.sqlStatement = sqlStatementArg;
        this.valueExprFunc = inExpr;
        if (this.valueExprFunc == null) {
            this.valueExprFunc = ExpressionHelper.createFunction("");
        }
        this.isColumn = isColumn;
    }

    public FunctionBuilderPage(SQLDomainModel domainModel, SQLQueryObject sqlStatementArg, ValueExpressionFunction inSqlExpr) {
        super(Messages._UI_WIZARD_FUNCTION_BUILDER_HEADING);
        this.setTitle(Messages._UI_WIZARD_FUNCTION_BUILDER_HEADING);
        this.setDescription(Messages._UI_WIZARD_FUNCTION_BUILDER_EXPL);
        this.setPageComplete(false);
        this.domainModel = domainModel;
        this.sqlStatement = sqlStatementArg;
        this.valueExprFunc = inSqlExpr;
        if (this.valueExprFunc == null) {
            this.valueExprFunc = ExpressionHelper.createFunction("");
        }
        this.isColumn = false;
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainPanel, "org.eclipse.datatools.sqltools.sqlbuilder.sqle0100");
        GridLayout mainPanelLayout = new GridLayout();
        mainPanel.setLayout((Layout)mainPanelLayout);
        mainPanel.setLayoutData((Object)ViewUtility.createFill());
        Label chooseFcnTypeLabel = new Label(mainPanel, 16640);
        chooseFcnTypeLabel.setText(Messages._UI_WIZARD_FUNCTION_BUILDER_INSTR_CAT);
        chooseFcnTypeLabel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.functionsCategoryCombo = new Combo(mainPanel, 12);
        this.functionsCategoryCombo.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.functionsCategoryCombo.addSelectionListener((SelectionListener)this);
        Label chooseFunctionLabel = new Label(mainPanel, 16640);
        chooseFunctionLabel.setText(Messages._UI_WIZARD_FUNCTION_BUILDER_INSTR_FCN);
        chooseFunctionLabel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        Composite listPanel = new Composite(mainPanel, 0);
        GridLayout listPanelLayout = new GridLayout();
        listPanelLayout.horizontalSpacing = 0;
        listPanelLayout.verticalSpacing = 0;
        listPanelLayout.marginWidth = 0;
        listPanelLayout.marginHeight = 0;
        listPanel.setLayout((Layout)listPanelLayout);
        listPanel.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.functionsList = new Combo(listPanel, 12);
        this.functionsList.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.functionsList.addSelectionListener((SelectionListener)this);
        Label selectSignatureLabel = new Label(mainPanel, 16640);
        selectSignatureLabel.setText(Messages._UI_WIZARD_FUNCTION_BUILDER_INSTR_SIG);
        this.functionsSignaturesCombo = new Combo(mainPanel, 12);
        this.functionsSignaturesCombo.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.functionsSignaturesCombo.addSelectionListener((SelectionListener)this);
        Label enterValuesLabel = new Label(mainPanel, 16640);
        enterValuesLabel.setText(Messages._UI_WIZARD_FUNCTION_BUILDER_INSTR_EXPR);
        this.paramPanel = new Composite(mainPanel, 0);
        GridLayout paramPanelLayout = new GridLayout();
        paramPanelLayout.marginWidth = 0;
        this.paramPanel.setLayout((Layout)paramPanelLayout);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.paramPanel.setLayoutData((Object)data);
        this.paramTable = new ParamTable(this, this.paramPanel, this.domainModel, this.sqlStatement);
        this.paramTable.setInput(this.valueExprFunc);
        this.paramTable.getTable().setLayoutData((Object)ViewUtility.createFill());
        Label previewFunctionLabel = new Label(this.paramPanel, 16640);
        previewFunctionLabel.setText(Messages._UI_WIZARD_FUNCTION_BUILDER_INSTR_PRE);
        this.previewExpressionText = new Text(this.paramPanel, 2632);
        this.previewExpressionText.setLayoutData((Object)ViewUtility.createFill());
        this.setControl((Control)mainPanel);
    }

    public void setParamValue(int paramNo, QueryValueExpression value) {
        EList paramList = this.valueExprFunc.getParameterList();
        if (paramNo < paramList.size() && value != null) {
            paramList.set(paramNo, value);
        }
        if (paramNo < paramList.size() && value == null) {
            QueryValueExpression expr = ExpressionHelper.createExpression();
            paramList.set(paramNo, expr);
        } else if (paramList.size() < this.numOfParameters) {
            paramList.add(value);
        }
    }

    public void insertParamValue(int paramNo, QueryValueExpression value) {
        EList paramList = this.valueExprFunc.getParameterList();
        paramList.add(paramNo, value);
    }

    public void widgetDefaultSelected(SelectionEvent se) {
    }

    public void widgetSelected(SelectionEvent se) {
        if (se.widget == this.functionsCategoryCombo) {
            if (this.currentCategoryIndex != this.functionsCategoryCombo.getSelectionIndex()) {
                this.fillFunctionsList();
                this.currentCategoryIndex = this.functionsCategoryCombo.getSelectionIndex();
                this.functionsList.select(0);
                this.functionsList.notifyListeners(13, new Event());
                this.updateFinishButton();
            }
        } else if (se.widget == this.functionsList) {
            this.populateFunctionsSignaturesCombo();
            this.functionsSignaturesCombo.select(0);
            String functionSelected = this.functionsList.getText();
            Object[][] formats = new Object[0][0];
            if (this.domainModel.getVendor().isDB2()) {
                FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
                formats = funcHelper.getFunctionSignatures(functionSelected);
                if (funcHelper.getIsFunctionAllowingStar(functionSelected)) {
                    this.paramTable.setSupportsStar(true);
                } else {
                    this.paramTable.setSupportsStar(false);
                }
            } else if (this.domainModel.getVendor().isOracle_V8()) {
                formats = OracleFunctionNamesAndSignatures.getParameterFormats(functionSelected);
                if (OracleFunctionNamesAndSignatures.isFunctionSupportingStar(functionSelected)) {
                    this.paramTable.setSupportsStar(true);
                } else {
                    this.paramTable.setSupportsStar(false);
                }
            } else if (this.domainModel.getVendor().isOracle_V9()) {
                formats = OracleV9FunctionNamesAndSignatures.getParameterFormats(functionSelected);
                if (OracleV9FunctionNamesAndSignatures.isFunctionSupportingStar(functionSelected)) {
                    this.paramTable.setSupportsStar(true);
                } else {
                    this.paramTable.setSupportsStar(false);
                }
            } else if (this.domainModel.getVendor().isMySQL()) {
                formats = MySQLFunctionNamesAndSignatures.getParameterFormats(functionSelected);
                if (MySQLFunctionNamesAndSignatures.isFunctionSupportingStar(functionSelected)) {
                    this.paramTable.setSupportsStar(true);
                } else {
                    this.paramTable.setSupportsStar(false);
                }
            } else if (this.domainModel.getVendor().isSybase()) {
                formats = SybaseFunctionNamesAndSignatures.getParameterFormats(functionSelected);
                if (SybaseFunctionNamesAndSignatures.isFunctionSupportingStar(functionSelected)) {
                    this.paramTable.setSupportsStar(true);
                } else {
                    this.paramTable.setSupportsStar(false);
                }
            } else if (this.domainModel.getVendor().isMSSQLServer()) {
                formats = MSSQLServerFunctionNamesAndSignatures.getParameterFormats(functionSelected);
                if (MSSQLServerFunctionNamesAndSignatures.isFunctionSupportingStar(functionSelected)) {
                    this.paramTable.setSupportsStar(true);
                } else {
                    this.paramTable.setSupportsStar(false);
                }
            } else if (this.domainModel.getVendor().isInformix()) {
                formats = InformixFunctionNamesAndSignatures.getParameterFormats(functionSelected);
                if (InformixFunctionNamesAndSignatures.isFunctionSupportingStar(functionSelected)) {
                    this.paramTable.setSupportsStar(true);
                } else {
                    this.paramTable.setSupportsStar(false);
                }
            } else if (this.domainModel.getVendor().isInstantDB()) {
                formats = InstantDBFunctionNamesAndSignatures.getParameterFormats(functionSelected);
                if (InstantDBFunctionNamesAndSignatures.isFunctionSupportingStar(functionSelected)) {
                    this.paramTable.setSupportsStar(true);
                } else {
                    this.paramTable.setSupportsStar(false);
                }
            } else if (this.domainModel.getVendor().isCloudscape()) {
                formats = CloudscapeFunctionNamesAndSignatures.getParameterFormats(functionSelected);
                if (CloudscapeFunctionNamesAndSignatures.isFunctionSupportingStar(functionSelected)) {
                    this.paramTable.setSupportsStar(true);
                } else {
                    this.paramTable.setSupportsStar(false);
                }
            } else {
                formats = FunctionNamesAndSignatures.getParameterFormats(functionSelected);
            }
            Object[] paramFormats = new Object[]{};
            int index = this.functionsSignaturesCombo.getSelectionIndex();
            if (index >= 0 && index < formats.length) {
                paramFormats = formats[index];
            }
            this.numOfParameters = 0;
            int i = 1;
            while (i < paramFormats.length) {
                if (paramFormats[i] != null && paramFormats[i].toString().length() > 0) {
                    ++this.numOfParameters;
                }
                ++i;
            }
            EList paramsList = this.valueExprFunc.getParameterList();
            ArrayList tempList = new ArrayList();
            tempList.addAll(paramsList);
            int size = tempList.size();
            paramsList.clear();
            int i2 = 0;
            while (i2 < this.numOfParameters) {
                QueryValueExpression expr = i2 < size && tempList.get(i2) != null ? (QueryValueExpression)tempList.get(i2) : ExpressionHelper.createExpression();
                paramsList.add(expr);
                ++i2;
            }
            this.paramTable.setInput(this.valueExprFunc);
            this.updateFinishButton();
        } else if (se.widget == this.functionsSignaturesCombo) {
            String functionSelected = this.functionsList.getText();
            Object[][] formats = new Object[0][0];
            if (this.domainModel.getVendor().isDB2()) {
                FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
                formats = funcHelper.getFunctionSignatures(functionSelected);
            } else {
                formats = this.domainModel.getVendor().isOracle_V8() ? OracleFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isOracle_V9() ? OracleV9FunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isMySQL() ? MySQLFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isSybase() ? SybaseFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isMSSQLServer() ? MSSQLServerFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isInformix() ? InformixFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isInstantDB() ? InstantDBFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isCloudscape() ? CloudscapeFunctionNamesAndSignatures.getParameterFormats(functionSelected) : FunctionNamesAndSignatures.getParameterFormats(functionSelected))))))));
            }
            Object[] paramFormats = new Object[]{};
            int index = this.functionsSignaturesCombo.getSelectionIndex();
            if (index >= 0 && index < formats.length) {
                paramFormats = formats[index];
            }
            this.numOfParameters = 0;
            int i = 1;
            while (i < paramFormats.length) {
                if (paramFormats[i] != null && paramFormats[i].toString().length() > 0) {
                    ++this.numOfParameters;
                }
                ++i;
            }
            EList paramsList = this.valueExprFunc.getParameterList();
            ArrayList tempList = new ArrayList();
            tempList.addAll(paramsList);
            int size = tempList.size();
            paramsList.clear();
            int i3 = 0;
            while (i3 < this.numOfParameters) {
                QueryValueExpression expr = i3 < size && tempList.get(i3) != null ? (QueryValueExpression)tempList.get(i3) : ExpressionHelper.createExpression();
                paramsList.add(expr);
                ++i3;
            }
            this.paramTable.setInput(this.valueExprFunc);
            this.updateFinishButton();
        }
    }

    public QueryValueExpression getExpression() {
        return this.valueExprFunc;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fillFunctionCategoriesList();
            this.functionsCategoryCombo.select(0);
            this.functionsCategoryCombo.notifyListeners(13, new Event());
            this.functionsList.select(0);
            this.functionsList.notifyListeners(13, new Event());
            this.functionsSignaturesCombo.select(0);
            this.functionsSignaturesCombo.notifyListeners(13, new Event());
            if (this.valueExprFunc != null) {
                try {
                    String functionName = this.valueExprFunc.getName();
                    this.inputFunctionString = new String(functionName);
                    int listIndex = this.functionsList.indexOf(functionName.toUpperCase());
                    if (listIndex < 0) {
                        listIndex = 0;
                    }
                    this.functionsList.select(listIndex);
                    this.functionsList.notifyListeners(13, new Event());
                    this.functionsSignaturesCombo.notifyListeners(13, new Event());
                    int index = 0;
                    if (this.numOfParameters > 0) {
                        index = 0;
                        while (index < this.functionsSignaturesCombo.getItemCount()) {
                            String testString = this.functionsSignaturesCombo.getItem(index);
                            if (this.numOfParameters == 1) {
                                if (testString.indexOf("(") >= 0) {
                                    String argString = testString.substring(testString.indexOf("(") + 1, testString.indexOf(")"));
                                    if (StringUtility.occurrenceOf(testString, ',') == 0 && argString.length() > 0) {
                                        break;
                                    }
                                }
                            } else if (this.numOfParameters > 1 && StringUtility.occurrenceOf(this.functionsSignaturesCombo.getItem(index), ',') == this.numOfParameters - 1) break;
                            ++index;
                        }
                    } else {
                        index = 0;
                    }
                    this.functionsSignaturesCombo.select(index);
                    this.paramTable.setInput(this.valueExprFunc);
                }
                catch (Exception exception) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages._ERROR_DIALOG_TITLE_EXPR_EDIT_FAILED, (String)Messages._ERROR_DIALOG_MSG_REBUILD_EXPR);
                    this.functionsCategoryCombo.notifyListeners(13, new Event());
                    this.functionsList.notifyListeners(13, new Event());
                    this.functionsSignaturesCombo.notifyListeners(13, new Event());
                }
            }
            this.updateFinishButton();
        }
    }

    public void updateFinishButton() {
        int noOfParameters;
        Object[][] formats;
        boolean isComplete = true;
        boolean isNotSupported = false;
        String functionSelected = this.functionsList.getText();
        if (this.domainModel.getVendor().isDB2()) {
            FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
            formats = funcHelper.getFunctionSignatures(functionSelected);
        } else if (this.domainModel.getVendor().isOracle_V8()) {
            formats = OracleFunctionNamesAndSignatures.getParameterFormats(functionSelected);
        } else if (this.domainModel.getVendor().isOracle_V9()) {
            formats = OracleV9FunctionNamesAndSignatures.getParameterFormats(functionSelected);
        } else if (this.domainModel.getVendor().isMySQL()) {
            formats = MySQLFunctionNamesAndSignatures.getParameterFormats(functionSelected);
            isNotSupported = MySQLFunctionNamesAndSignatures.isNotSupported(functionSelected);
        } else if (this.domainModel.getVendor().isSybase()) {
            formats = SybaseFunctionNamesAndSignatures.getParameterFormats(functionSelected);
        } else if (this.domainModel.getVendor().isMSSQLServer()) {
            formats = MSSQLServerFunctionNamesAndSignatures.getParameterFormats(functionSelected);
            isNotSupported = MSSQLServerFunctionNamesAndSignatures.isNotSupported(functionSelected);
        } else if (this.domainModel.getVendor().isInformix()) {
            formats = InformixFunctionNamesAndSignatures.getParameterFormats(functionSelected);
            isNotSupported = InformixFunctionNamesAndSignatures.isNotSupported(functionSelected);
        } else if (this.domainModel.getVendor().isInstantDB()) {
            formats = InstantDBFunctionNamesAndSignatures.getParameterFormats(functionSelected);
        } else if (this.domainModel.getVendor().isCloudscape()) {
            formats = CloudscapeFunctionNamesAndSignatures.getParameterFormats(functionSelected);
            isNotSupported = CloudscapeFunctionNamesAndSignatures.isNotSupported(functionSelected);
        } else {
            formats = FunctionNamesAndSignatures.getParameterFormats(functionSelected);
        }
        Object[] paramFormats = new Object[]{};
        int index = this.functionsSignaturesCombo.getSelectionIndex();
        if (index >= 0 && index < formats.length) {
            paramFormats = formats[index];
        }
        if ((noOfParameters = paramFormats.length - 1) > 0) {
            EList paramsList = this.valueExprFunc.getParameterList();
            int i = 0;
            while (i < paramsList.size()) {
                QueryValueExpression expr = (QueryValueExpression)paramsList.get(i);
                if (expr instanceof ValueExpressionCombined) {
                    ValueExpressionCombined combinedExpr = (ValueExpressionCombined)expr;
                    isComplete = ExpressionHelper.isComplete((QueryValueExpression)combinedExpr);
                }
                if (expr.getSQL().equals("")) {
                    isComplete = false;
                }
                ++i;
            }
        }
        if (isNotSupported) {
            isComplete = false;
            this.previewExpressionText.setText("");
        } else {
            this.updatePreviewExpressionText();
        }
        this.setPageComplete(isComplete);
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            ExpressionBuilderWizard wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setAllPagesComplete(isComplete);
            wiz.setAllPagesComplete(isComplete);
        }
    }

    public boolean performOk() {
        Wizard wiz;
        String functionSelected = this.functionsList.getText();
        Object[][] formats = new Object[0][0];
        if (this.domainModel.getVendor().isDB2()) {
            FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
            formats = funcHelper.getFunctionSignatures(functionSelected);
        } else {
            formats = this.domainModel.getVendor().isOracle_V8() ? OracleFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isOracle_V9() ? OracleV9FunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isMySQL() ? MySQLFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isSybase() ? SybaseFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isMSSQLServer() ? MSSQLServerFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isInformix() ? InformixFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isInstantDB() ? InstantDBFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isCloudscape() ? CloudscapeFunctionNamesAndSignatures.getParameterFormats(functionSelected) : FunctionNamesAndSignatures.getParameterFormats(functionSelected))))))));
        }
        Object[] paramFormats = new Object[]{};
        int index = this.functionsSignaturesCombo.getSelectionIndex();
        if (index >= 0 && index < formats.length) {
            paramFormats = formats[index];
        }
        int noOfParams = paramFormats.length - 1;
        if (functionSelected.equals(this.inputFunctionString.toUpperCase())) {
            functionSelected = this.inputFunctionString;
        }
        ValueExpressionFunction updatedFunctionExpr = null;
        if (noOfParams > 0) {
            EList params = ((ValueExpressionFunction)this.getExpression()).getParameterList();
            updatedFunctionExpr = ExpressionHelper.createFunction(functionSelected, (List)params);
        } else {
            updatedFunctionExpr = ExpressionHelper.createFunction(functionSelected, null);
            if (this.domainModel.getVendor().isDB2()) {
                FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
                List specialRegNameList = funcHelper.getSpecialRegisterNames();
                if (specialRegNameList.contains(functionSelected)) {
                    updatedFunctionExpr.setSpecialRegister(true);
                }
            } else if (this.domainModel.getVendor().isOracle_V8()) {
                if (OracleFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                    updatedFunctionExpr.setSpecialRegister(true);
                }
            } else if (this.domainModel.getVendor().isOracle_V9()) {
                if (OracleV9FunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                    updatedFunctionExpr.setSpecialRegister(true);
                }
            } else if (this.domainModel.getVendor().isMySQL()) {
                if (MySQLFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                    updatedFunctionExpr.setSpecialRegister(true);
                }
            } else if (this.domainModel.getVendor().isMSSQLServer()) {
                if (MSSQLServerFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                    updatedFunctionExpr.setSpecialRegister(true);
                }
            } else if (this.domainModel.getVendor().isInformix()) {
                if (InformixFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                    updatedFunctionExpr.setSpecialRegister(true);
                }
            } else if (this.domainModel.getVendor().isCloudscape()) {
                if (CloudscapeFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                    updatedFunctionExpr.setSpecialRegister(true);
                }
            } else if (FunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                updatedFunctionExpr.setSpecialRegister(true);
            }
        }
        if (this.getWizard() instanceof ExpressionBuilderWizard) {
            wiz = (ExpressionBuilderWizard)this.getWizard();
            wiz.setSQLExpression((QueryValueExpression)updatedFunctionExpr);
        } else if (this.getWizard() instanceof FunctionExpressionWizard) {
            wiz = (FunctionExpressionWizard)this.getWizard();
            wiz.setSQLExpression(updatedFunctionExpr);
        }
        return true;
    }

    private void fillFunctionCategoriesList() {
        this.functionsCategoryCombo.removeAll();
        if (this.domainModel.getVendor().isDB2()) {
            FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
            List catList = funcHelper.getFunctionCategories(1);
            int i = 0;
            while (i < catList.size()) {
                this.functionsCategoryCombo.add((String)catList.get(i));
                ++i;
            }
        } else if (this.domainModel.getVendor().isOracle_V8()) {
            OracleFunctionNamesAndSignatures.fillCategoryCombo(this.functionsCategoryCombo, this.isColumn);
        } else if (this.domainModel.getVendor().isOracle_V9()) {
            OracleV9FunctionNamesAndSignatures.fillCategoryCombo(this.functionsCategoryCombo, this.isColumn);
        } else if (this.domainModel.getVendor().isMySQL()) {
            MySQLFunctionNamesAndSignatures.fillCategoryCombo(this.functionsCategoryCombo, this.isColumn);
        } else if (this.domainModel.getVendor().isSybase()) {
            SybaseFunctionNamesAndSignatures.fillCategoryCombo(this.functionsCategoryCombo, this.isColumn);
        } else if (this.domainModel.getVendor().isMSSQLServer()) {
            MSSQLServerFunctionNamesAndSignatures.fillCategoryCombo(this.functionsCategoryCombo, this.isColumn);
        } else if (this.domainModel.getVendor().isInformix()) {
            InformixFunctionNamesAndSignatures.fillCategoryCombo(this.functionsCategoryCombo, this.isColumn);
        } else if (this.domainModel.getVendor().isInstantDB()) {
            InstantDBFunctionNamesAndSignatures.fillCategoryCombo(this.functionsCategoryCombo, this.isColumn);
        } else if (this.domainModel.getVendor().isCloudscape()) {
            CloudscapeFunctionNamesAndSignatures.fillCategoryCombo(this.functionsCategoryCombo, this.isColumn);
        } else {
            FunctionNamesAndSignatures.fillCategoryCombo(this.functionsCategoryCombo, this.isColumn);
        }
    }

    private void fillFunctionsList() {
        this.functionsList.removeAll();
        String category = this.functionsCategoryCombo.getText();
        if (this.domainModel.getVendor().isDB2()) {
            FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
            List funcList = funcHelper.getFunctionNames(category);
            int i = 0;
            while (i < funcList.size()) {
                this.functionsList.add((String)funcList.get(i));
                ++i;
            }
        } else if (this.domainModel.getVendor().isOracle_V8()) {
            this.fillFunctionsListBox(OracleFunctionNamesAndSignatures.getFunctionList(category, this.isColumn, this.domainModel));
        } else if (this.domainModel.getVendor().isOracle_V9()) {
            this.fillFunctionsListBox(OracleV9FunctionNamesAndSignatures.getFunctionList(category, this.isColumn, this.domainModel));
        } else if (this.domainModel.getVendor().isMySQL()) {
            this.fillFunctionsListBox(MySQLFunctionNamesAndSignatures.getFunctionList(category, this.isColumn, this.domainModel));
        } else if (this.domainModel.getVendor().isSybase()) {
            this.fillFunctionsListBox(SybaseFunctionNamesAndSignatures.getFunctionList(category, this.isColumn, this.domainModel));
        } else if (this.domainModel.getVendor().isMSSQLServer()) {
            this.fillFunctionsListBox(MSSQLServerFunctionNamesAndSignatures.getFunctionList(category, this.isColumn, this.domainModel));
        } else if (this.domainModel.getVendor().isInformix()) {
            this.fillFunctionsListBox(InformixFunctionNamesAndSignatures.getFunctionList(category, this.isColumn, this.domainModel));
        } else if (this.domainModel.getVendor().isInstantDB()) {
            this.fillFunctionsListBox(InstantDBFunctionNamesAndSignatures.getFunctionList(category, this.isColumn, this.domainModel));
        } else if (this.domainModel.getVendor().isCloudscape()) {
            this.fillFunctionsListBox(CloudscapeFunctionNamesAndSignatures.getFunctionList(category, this.isColumn, this.domainModel));
        } else {
            this.fillFunctionsListBox(FunctionNamesAndSignatures.getFunctionList(category, this.isColumn, this.domainModel));
        }
    }

    private void fillFunctionsListBox(String[] arrayList) {
        int i = 0;
        while (i < arrayList.length) {
            this.functionsList.add(arrayList[i]);
            ++i;
        }
        if (this.domainModel.getVendor().isDB2() && !this.domainModel.getVendor().isDB2UDBOS390() && this.functionsList.indexOf("TRIM") >= 0) {
            this.functionsList.remove("TRIM");
        }
    }

    private void populateFunctionsSignaturesCombo() {
        Object[][] formats;
        String functionSelected = this.functionsList.getText();
        boolean includeBrackets = true;
        String category = this.functionsCategoryCombo.getText();
        if (this.domainModel.getVendor().isDB2()) {
            if (category.equals(FunctionHelperDB2.CAT_LABEL_SPECIAL_REGISTERS)) {
                includeBrackets = false;
            }
        } else if (this.domainModel.getVendor().isOracle_V8()) {
            if (OracleFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                includeBrackets = false;
            }
        } else if (this.domainModel.getVendor().isOracle_V9()) {
            if (OracleV9FunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                includeBrackets = false;
            }
        } else if (this.domainModel.getVendor().isMySQL()) {
            if (MySQLFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                includeBrackets = false;
            }
        } else if (this.domainModel.getVendor().isMSSQLServer()) {
            if (MSSQLServerFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                includeBrackets = false;
            }
        } else if (this.domainModel.getVendor().isInformix()) {
            if (InformixFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                includeBrackets = false;
            }
        } else if (this.domainModel.getVendor().isCloudscape()) {
            if (CloudscapeFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                includeBrackets = false;
            }
        } else if (FunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
            includeBrackets = false;
        }
        this.functionsSignaturesCombo.removeAll();
        if (this.domainModel.getVendor().isDB2()) {
            FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
            formats = funcHelper.getFunctionSignatures(functionSelected);
        } else {
            formats = this.domainModel.getVendor().isOracle_V8() ? OracleFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isOracle_V9() ? OracleV9FunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isMySQL() ? MySQLFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isSybase() ? SybaseFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isMSSQLServer() ? MSSQLServerFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isInformix() ? InformixFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isInstantDB() ? InstantDBFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isCloudscape() ? CloudscapeFunctionNamesAndSignatures.getParameterFormats(functionSelected) : FunctionNamesAndSignatures.getParameterFormats(functionSelected))))))));
        }
        int i = 0;
        while (i < formats.length) {
            Object[] paramFormats = formats[i];
            String formatStr = "";
            if (includeBrackets) {
                formatStr = String.valueOf(functionSelected) + "(";
            } else if (i == 0) {
                formatStr = functionSelected;
            } else if (i > 0) {
                formatStr = String.valueOf(functionSelected) + "(";
            }
            int j = 1;
            while (j < paramFormats.length) {
                if (j != 1) {
                    formatStr = String.valueOf(formatStr) + ", ";
                }
                if (paramFormats[j] != null) {
                    formatStr = String.valueOf(formatStr) + paramFormats[j].toString();
                }
                ++j;
            }
            if (includeBrackets) {
                formatStr = String.valueOf(formatStr) + ")  -->  " + paramFormats[0].toString();
            } else {
                if (i > 0) {
                    formatStr = String.valueOf(formatStr) + ")";
                }
                formatStr = String.valueOf(formatStr) + "  -->  " + paramFormats[0].toString();
            }
            this.functionsSignaturesCombo.add(formatStr);
            ++i;
        }
    }

    public void updatePreviewExpressionText() {
        Object[][] formats;
        String functionSelected = this.functionsList.getText();
        if (this.domainModel.getVendor().isDB2()) {
            FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
            formats = funcHelper.getFunctionSignatures(functionSelected);
        } else {
            formats = this.domainModel.getVendor().isOracle_V8() ? OracleFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isOracle_V9() ? OracleV9FunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isMySQL() ? MySQLFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isSybase() ? SybaseFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isMSSQLServer() ? MSSQLServerFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isInformix() ? InformixFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isInstantDB() ? InstantDBFunctionNamesAndSignatures.getParameterFormats(functionSelected) : (this.domainModel.getVendor().isCloudscape() ? CloudscapeFunctionNamesAndSignatures.getParameterFormats(functionSelected) : FunctionNamesAndSignatures.getParameterFormats(functionSelected))))))));
        }
        Object[] paramFormats = new Object[]{};
        int index = this.functionsSignaturesCombo.getSelectionIndex();
        if (index >= 0 && index < formats.length) {
            paramFormats = formats[index];
        }
        int noOfParams = paramFormats.length - 1;
        String formatString = functionSelected;
        if (noOfParams > 0) {
            EList paramsList = this.valueExprFunc.getParameterList();
            int size = paramsList.size();
            formatString = String.valueOf(formatString) + "(";
            int i = 0;
            while (i < size) {
                QueryValueExpression param = (QueryValueExpression)paramsList.get(i);
                String exprSQL = param.getSQL();
                formatString = String.valueOf(formatString) + exprSQL;
                if (i != size - 1) {
                    formatString = String.valueOf(formatString) + ", ";
                }
                ++i;
            }
            formatString = String.valueOf(formatString) + ")";
        } else if (this.domainModel.getVendor().isDB2()) {
            FunctionHelper funcHelper = FunctionHelper.getInstance(this.domainModel.getDatabase());
            List specialRegNameList = funcHelper.getSpecialRegisterNames();
            if (!specialRegNameList.contains(functionSelected)) {
                formatString = String.valueOf(formatString) + "()";
            }
        } else if (this.domainModel.getVendor().isOracle_V8()) {
            if (!OracleFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                formatString = String.valueOf(formatString) + "()";
            }
        } else if (this.domainModel.getVendor().isOracle_V9()) {
            if (!OracleV9FunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                formatString = String.valueOf(formatString) + "()";
            }
        } else if (this.domainModel.getVendor().isMySQL()) {
            if (!MySQLFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                formatString = String.valueOf(formatString) + "()";
            }
        } else if (this.domainModel.getVendor().isMSSQLServer()) {
            if (!MSSQLServerFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                formatString = String.valueOf(formatString) + "()";
            }
        } else if (this.domainModel.getVendor().isInformix()) {
            if (!InformixFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                formatString = String.valueOf(formatString) + "()";
            }
        } else if (this.domainModel.getVendor().isCloudscape()) {
            if (!CloudscapeFunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
                formatString = String.valueOf(formatString) + "()";
            }
        } else if (!FunctionNamesAndSignatures.requiresNoBrackets(functionSelected)) {
            formatString = String.valueOf(formatString) + "()";
        }
        this.previewExpressionText.setText(formatString);
    }

    public boolean currentPage() {
        return this.isCurrentPage();
    }
}

