/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.ddl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.enablement.sybase.asa.ddl.SybaseASADdlBuilder;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseDBSpace;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;

public class SybaseASADdlGenerator
extends SybaseDdlGenerator
implements DDLGenerator,
IExecutableExtension {
    private String product;
    private String version;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.product = config.getAttribute("product");
        this.version = config.getAttribute("version");
    }

    public void createStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        super.createStatement(element, quoteIdentifiers, qualifyNames, fullSyntax, script, progressMonitor, task);
        if (element instanceof SybaseASABaseDBSpace) {
            String[] statements = ((SybaseASADdlBuilder)this.sybaseDdlBuilder).createDBSpace((SybaseASABaseDBSpace)element, quoteIdentifiers, qualifyNames, fullSyntax);
            int j = 0;
            while (j < statements.length) {
                script.addCreateDatabaseObjectStatements(statements[j]);
                ++j;
            }
        }
    }

    public void dropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, IProgressMonitor progressMonitor, int task) {
        String statement;
        super.dropStatement(element, quoteIdentifiers, qualifyNames, script, progressMonitor, task);
        if (element instanceof SybaseASABaseDBSpace && (statement = ((SybaseASADdlBuilder)this.sybaseDdlBuilder).dropDBSpace((SybaseASABaseDBSpace)element, quoteIdentifiers, qualifyNames)) != null) {
            script.addDropTableStatement(statement);
        }
    }

    protected SybaseDdlBuilder createBuilder() {
        this.sybaseDdlBuilder = SybaseASADdlBuilder.getInstance();
        return this.sybaseDdlBuilder;
    }

    public byte[] getAdditionalOptionIndices(int objectType) {
        if (objectType == 18) {
            return new byte[]{8, 9, 7, 23, 4, 16, 6, 5, 10, 15, 24};
        }
        if (objectType == 4 || objectType == 16) {
            return new byte[]{11, 12, 13, 14, 5, 7, 10};
        }
        return new byte[0];
    }

    public byte[] getGenerationOptionIndices(int objectType) {
        if (objectType == 4 || objectType == 9 || objectType == 8 || objectType == 6 || objectType == 18 || objectType == 16) {
            byte[] byArray = new byte[5];
            byArray[0] = 3;
            byArray[1] = 2;
            byArray[3] = 1;
            byArray[4] = 17;
            return byArray;
        }
        byte[] byArray = new byte[4];
        byArray[0] = 3;
        byArray[1] = 2;
        byArray[3] = 1;
        return byArray;
    }

    public byte[] getExclusiveAdditionalOptionIndices(int objectType) {
        if (objectType == 18) {
            return new byte[]{9, 23, 24};
        }
        if (objectType == 4 || objectType == 16) {
            return new byte[]{7};
        }
        return new byte[0];
    }

    public String[] dropSQLObjectsForDeltaDDL(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor) {
        return super.dropSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor);
    }

    public String[] createSQLObjectsForDeltaDDL(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, IProgressMonitor progressMonitor) {
        return super.createSQLObjects(elements, quoteIdentifiers, qualifyNames, progressMonitor);
    }
}

