/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OdaComplexDataType implements Enumerator
{
    STRUCTURE_LITERAL(0, "Structure", "Structure"),
    TABLE_LITERAL(1, "Table", "Table");

    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    public static final int STRUCTURE = 0;
    public static final int TABLE = 1;
    private static final OdaComplexDataType[] VALUES_ARRAY;
    public static final List<OdaComplexDataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OdaComplexDataType[]{STRUCTURE_LITERAL, TABLE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OdaComplexDataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OdaComplexDataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OdaComplexDataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OdaComplexDataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OdaComplexDataType get(int value) {
        switch (value) {
            case 0: {
                return STRUCTURE_LITERAL;
            }
            case 1: {
                return TABLE_LITERAL;
            }
        }
        return null;
    }

    private OdaComplexDataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

