/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editparts;

import org.eclipse.gef.EditPart;
import org.eclipse.wst.xsd.ui.internal.adapters.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAttributeGroupDefinitionAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDModelGroupAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDModelGroupDefinitionAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSchemaAdapter;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSimpleTypeDefinitionAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ADTEditPartFactory;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ColumnEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CompartmentEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.Annotation;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.ICompartmentFigure;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IFieldFigure;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IStructureFigure;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures.TypeVizFigureFactory;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.wst.xsd.ui.internal.design.editparts.AttributeGroupDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.CategoryEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ModelGroupDefinitionReferenceEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ModelGroupEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.SpaceFillerForFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.TargetConnectionSpacingFigureEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDAttributesForAnnotationEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDBaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDGroupsForAnnotationEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDSchemaEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.XSDSimpleTypeEditPart;
import org.eclipse.wst.xsd.ui.internal.design.editparts.model.SpaceFiller;
import org.eclipse.wst.xsd.ui.internal.design.editparts.model.TargetConnectionSpaceFiller;
import org.eclipse.wst.xsd.ui.internal.design.figures.IExtendedFigureFactory;
import org.eclipse.wst.xsd.ui.internal.design.figures.IModelGroupFigure;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDConcreteComponent;

public class XSDEditPartFactory
extends ADTEditPartFactory
implements IExtendedFigureFactory {
    protected IExtendedFigureFactory delegate;

    public XSDEditPartFactory() {
        this.delegate = XSDEditorPlugin.getPlugin().getXSDEditorConfiguration().getFigureFactory();
        if (this.delegate == null) {
            this.delegate = new TypeVizFigureFactory();
        }
    }

    public XSDEditPartFactory(IExtendedFigureFactory figureFactory) {
        this.delegate = figureFactory;
    }

    public EditPart doCreateEditPart(EditPart context, Object model) {
        BaseEditPart child = null;
        if (model instanceof IField) {
            if (model instanceof SpaceFiller) {
                child = new SpaceFillerForFieldEditPart();
            } else if (context instanceof CompartmentEditPart) {
                child = new XSDBaseFieldEditPart();
            }
        } else if (model instanceof XSDSchemaAdapter) {
            child = new XSDSchemaEditPart();
        } else if (model instanceof CategoryAdapter) {
            child = new CategoryEditPart();
        } else if (model instanceof XSDSimpleTypeDefinitionAdapter) {
            child = new XSDSimpleTypeEditPart();
        } else if (model instanceof XSDModelGroupAdapter) {
            child = new ModelGroupEditPart();
        } else if (model instanceof Annotation) {
            Annotation annotation = (Annotation)model;
            String kind = annotation.getCompartment().getKind();
            if (kind.equals("element")) {
                child = new XSDGroupsForAnnotationEditPart();
            } else if (kind.equals("attribute")) {
                child = new XSDAttributesForAnnotationEditPart();
            }
        } else if (!(context instanceof ColumnEditPart)) {
            if (model instanceof TargetConnectionSpaceFiller) {
                child = new TargetConnectionSpacingFigureEditPart();
            } else if (model instanceof XSDModelGroupDefinitionAdapter) {
                child = new ModelGroupDefinitionReferenceEditPart();
            } else if (model instanceof XSDAttributeGroupDefinitionAdapter) {
                child = new AttributeGroupDefinitionEditPart();
            }
        }
        if (child == null) {
            child = super.doCreateEditPart(context, model);
        }
        if (child == null) {
            child = new SpaceFillerForFieldEditPart();
        }
        return child;
    }

    public ICompartmentFigure createCompartmentFigure(Object model) {
        return this.delegate.createCompartmentFigure(model);
    }

    public IStructureFigure createStructureFigure(Object model) {
        IStructureFigure figure = this.delegate.createStructureFigure(model);
        if (model instanceof XSDBaseAdapter) {
            XSDConcreteComponent comp = (XSDConcreteComponent)((XSDBaseAdapter)model).getTarget();
            boolean isReadOnly = ((XSDBaseAdapter)model).isReadOnly();
            figure.getNameLabel().setIcon(XSDCommonUIUtils.getUpdatedImage(comp, ((XSDBaseAdapter)model).getImage(), isReadOnly));
        }
        return figure;
    }

    public IFieldFigure createFieldFigure(Object model) {
        return this.delegate.createFieldFigure(model);
    }

    public IModelGroupFigure createModelGroupFigure(Object model) {
        return this.delegate.createModelGroupFigure(model);
    }
}

