/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.expressions;

import java.util.ArrayList;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionSupport;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ExpressionSupportManager {
    private ExpressionSupportManager() {
    }

    public static IExpressionSupport[] getExpressionSupports() {
        String[] exts = ExpressionSupportManager.getScriptExtensions();
        if (exts == null || exts.length == 0) {
            return null;
        }
        ArrayList<IExpressionSupport> supports = new ArrayList<IExpressionSupport>();
        String[] stringArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String scriptName = stringArray[n2];
            Object adapter = ElementAdapterManager.getAdapter(scriptName, IExpressionSupport.class);
            if (adapter instanceof IExpressionSupport) {
                supports.add((IExpressionSupport)adapter);
            }
            ++n2;
        }
        if (supports.size() == 0) {
            return null;
        }
        return supports.toArray(new IExpressionSupport[supports.size()]);
    }

    private static String[] getScriptExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return null;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.eclipse.birt.core.ScriptEngineFactory");
        if (extensionPoint == null) {
            return null;
        }
        ArrayList<String> exts = new ArrayList<String>();
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            if (extension != null && (elements = extension.getConfigurationElements()) != null) {
                IConfigurationElement[] iConfigurationElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name;
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element != null && (name = element.getAttribute("scriptName")) != null && name.length() > 0) {
                        exts.add(name);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (exts.size() == 0) {
            return null;
        }
        return exts.toArray(new String[exts.size()]);
    }
}

