/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.querymodel;

import org.eclipse.birt.data.oda.pojo.querymodel.Column;
import org.eclipse.birt.data.oda.pojo.querymodel.ColumnReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.IColumnsMapping;
import org.eclipse.birt.data.oda.pojo.querymodel.IMappingSource;
import org.eclipse.birt.data.oda.pojo.querymodel.ReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.RelayReferenceNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OneColumnMapping
implements IColumnsMapping {
    private IMappingSource source;
    private Column column;

    public OneColumnMapping(IMappingSource source, Column column) {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        if (column == null) {
            throw new NullPointerException("column is null");
        }
        this.source = source;
        this.column = column;
    }

    @Override
    public IMappingSource getSource() {
        return this.source;
    }

    public Column getMappedColumn() {
        return this.column;
    }

    @Override
    public ReferenceNode createReferenceNode(RelayReferenceNode parent) {
        return new ColumnReferenceNode(parent, this.source, this.getMappedColumn());
    }

    @Override
    public Element createElement(Document doc) {
        Element newElement = doc.createElement("ColumnMapping");
        newElement.setAttribute("name", this.getMappedColumn().getName());
        newElement.setAttribute("odaDataType", this.getMappedColumn().getOdaType());
        newElement.setAttribute("index", String.valueOf(this.getMappedColumn().getIndex()));
        newElement.appendChild(this.getSource().createElement(doc));
        return newElement;
    }
}

