/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.internal.content.wrap.CellContentWrapper;

class TableLayout {
    private Stack<LayoutStatus> statuses = new Stack();
    private ITableContent table;
    private int[] cells;
    private int columnCount;
    private boolean hasHiddenColumn;
    private boolean[] columnHiddens;
    private ICellContent currentCell;
    private HTMLReportEmitter emitter = null;
    ICellContent insertNoneCell = null;

    TableLayout(HTMLReportEmitter emitter) {
        this.emitter = emitter;
    }

    protected void startTable(ITableContent tableContent) {
        LayoutStatus status = new LayoutStatus();
        status.table = this.table;
        status.cells = this.cells;
        status.columnCount = this.columnCount;
        status.columnHiddens = this.columnHiddens;
        status.hasHiddenColumn = this.hasHiddenColumn;
        status.currentCell = this.currentCell;
        this.statuses.push(status);
        this.table = tableContent;
        this.columnCount = tableContent.getColumnCount();
        this.cells = new int[this.columnCount];
        this.columnHiddens = new boolean[this.columnCount];
        int i = 0;
        while (i < this.columnCount) {
            boolean isHidden;
            IColumn column = tableContent.getColumn(i);
            this.columnHiddens[i] = isHidden = column.getComputedStyle().getProperty(50) == CSSValueConstants.NONE_VALUE;
            if (isHidden) {
                this.hasHiddenColumn = true;
            }
            ++i;
        }
    }

    protected void endTable(ITableContent tableContent) {
        if (!this.statuses.isEmpty()) {
            LayoutStatus status = this.statuses.pop();
            this.table = status.table;
            this.cells = status.cells;
            this.columnCount = status.columnCount;
            this.hasHiddenColumn = status.hasHiddenColumn;
            this.columnHiddens = status.columnHiddens;
            this.currentCell = status.currentCell;
        }
    }

    protected void startRow() {
    }

    protected void endRow() {
        this.addEmptyCell();
        this.currentCell = null;
        int i = 0;
        while (i < this.columnCount) {
            int n = i++;
            this.cells[n] = this.cells[n] - 1;
        }
    }

    protected void startCell(ICellContent cell) {
        if (cell == this.insertNoneCell) {
            this.insertNoneCell = null;
            return;
        }
        if (this.needAddEmptyCell(cell)) {
            this.addEmptyCell(cell);
        }
        if (!this.hasHiddenColumn) {
            return;
        }
        int column = cell.getColumn();
        int colSpan = cell.getColSpan();
        int hiddenColumnCount = 0;
        int i = 0;
        while (i < colSpan) {
            if (this.columnHiddens[column + i]) {
                ++hiddenColumnCount;
            }
            ++i;
        }
        if (hiddenColumnCount != 0) {
            if (colSpan == hiddenColumnCount) {
                cell.getStyle().setProperty(50, CSSValueConstants.NONE_VALUE);
            } else {
                this.addNoneCell(column, column + hiddenColumnCount, cell);
                cell.setColumn(column + hiddenColumnCount);
                cell.setColSpan(colSpan - hiddenColumnCount);
                cell.getStyle().setProperty(50, CSSValueConstants.BLOCK_VALUE);
            }
        }
    }

    protected void endCell(ICellContent cell) {
        this.currentCell = cell;
        int i = cell.getColumn();
        while (i < cell.getColumn() + cell.getColSpan()) {
            int n = i++;
            this.cells[n] = this.cells[n] + cell.getRowSpan();
        }
    }

    protected boolean isInvisibaleRow() {
        int i = 0;
        if (i < this.columnCount) {
            return this.cells[i] == 0;
        }
        return false;
    }

    protected void addEmptyCell() {
        if (this.isInvisibaleRow()) {
            int i = 0;
            while (i < this.columnCount) {
                int n = i++;
                this.cells[n] = this.cells[n] + 1;
            }
            return;
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.cells[i] == 0) {
                ICellContent newCell = null;
                if (this.currentCell != null) {
                    newCell = this.newCell(this.currentCell, i, i + 1);
                } else if (this.table != null) {
                    newCell = this.newCell(this.table.getReportContent().createCellContent(), i, i + 1);
                }
                if (newCell != null) {
                    this.emitter.startCell(newCell);
                    this.emitter.endCell(newCell);
                }
            }
            ++i;
        }
    }

    protected boolean needAddEmptyCell(ICellContent cell) {
        return cell.getColumn() > 0 && this.cells[cell.getColumn() - 1] == 0;
    }

    protected ICellContent newCell(ICellContent cell, int startCol, int endCol) {
        CellContentWrapper tempCell = new CellContentWrapper(cell);
        tempCell.setRowSpan(cell.getRowSpan());
        tempCell.setColumn(startCol);
        tempCell.setColSpan(endCol - startCol);
        return tempCell;
    }

    protected int getEmptyStartIndex(int columnIndex) {
        int i = 0;
        while (i < columnIndex) {
            if (this.cells[i] == 0) {
                return i;
            }
            ++i;
        }
        return columnIndex;
    }

    protected void addEmptyCell(ICellContent cell) {
        int endCol;
        int startCol = this.getEmptyStartIndex(cell.getColumn());
        if (startCol < (endCol = cell.getColumn())) {
            ICellContent newCell = this.newCell(this.currentCell == null ? cell : this.currentCell, startCol, endCol);
            this.emitter.startCell(newCell);
            this.emitter.endCell(newCell);
        }
    }

    protected void addNoneCell(int startCol, int endCol, ICellContent cell) {
        if (startCol < endCol) {
            ICellContent newCell = this.newCell(cell, startCol, endCol);
            IStyle cellStyle = newCell.getStyle();
            cellStyle.setProperty(50, CSSValueConstants.NONE_VALUE);
            this.insertNoneCell = newCell;
            this.emitter.startCell(newCell);
            this.emitter.endCell(newCell);
        }
    }

    private class LayoutStatus {
        ITableContent table;
        int[] cells;
        int columnCount;
        boolean hasHiddenColumn;
        boolean[] columnHiddens;
        ICellContent currentCell;

        private LayoutStatus() {
        }
    }
}

