/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.LogConfig;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class OdaJdbcDriver
implements IDriver {
    private static String className = OdaJdbcDriver.class.getName();
    private static Logger logger = Logger.getLogger(className);

    public IConnection getConnection(String connectionClassName) throws OdaException {
        logger.logp(Level.FINEST, className, "getConnection", "JDBCConnectionFactory.getConnection( ) connectionClassName=" + connectionClassName);
        return new Connection();
    }

    public int getMaxConnections() throws OdaException {
        return 0;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void setLogConfiguration(LogConfiguration logConfig) throws OdaException {
        LogConfig.setLogConfiguration(logConfig);
    }

    static URL getInstallDirectory() throws OdaException, IOException {
        ExtensionManifest extMF = null;
        try {
            extMF = ManifestExplorer.getInstance().getExtensionManifest("org.eclipse.birt.report.data.oda.jdbc");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (extMF != null) {
            return extMF.getDriverLocation();
        }
        return null;
    }

    public static File getDriverDirectory() throws OdaException, IOException {
        URL url = OdaJdbcDriver.getInstallDirectory();
        if (url == null) {
            return null;
        }
        File result = null;
        try {
            URI uri = new URI(url.toString());
            result = new File(uri.getPath(), "drivers");
        }
        catch (URISyntaxException e) {
            result = new File(url.getFile(), "drivers");
        }
        return result;
    }

    public static List getDriverFileList() throws OdaException, IOException {
        File driverHomeDir = OdaJdbcDriver.getDriverDirectory();
        String[] files = driverHomeDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return OdaJdbcDriver.isDriverFile(name);
            }
        });
        ArrayList<File> retList = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            retList.add(new File(driverHomeDir, files[i]));
            ++i;
        }
        return retList;
    }

    static boolean isDriverFile(String fileName) {
        String lcName = fileName.toLowerCase();
        return lcName.endsWith(".jar") || lcName.endsWith(".zip");
    }

    public static final class Constants {
        public static final String DRIVER_DIRECTORY = "drivers";
        public static final String DATA_SOURCE_ID = "org.eclipse.birt.report.data.oda.jdbc";
        public static final String DRIVER_INFO_EXTENSION = "org.eclipse.birt.report.data.oda.jdbc.driverinfo";
        public static final String DRIVER_INFO_ATTR_NAME = "name";
        public static final String DRIVER_INFO_ATTR_DRIVERCLASS = "driverClass";
        public static final String DRIVER_INFO_ATTR_URLTEMPL = "urlTemplate";
        public static final String DRIVER_INFO_ATTR_SELECTORID = "selectorId";
        public static final String DRIVER_INFO_ATTR_CONNFACTORY = "connectionFactory";
        public static final String DRIVER_INFO_ELEM_JDBCDRIVER = "jdbcDriver";
        public static final String DRIVER_INFO_ATTR_HIDE = "hide";
    }
}

