/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.aggregation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.cache.BasicCachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IAggrDefnManager;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.IAggrValueHolder;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class AggregationHelper
implements IAggrValueHolder {
    private IAggrDefnManager manager;
    private ResultSetPopulator populator;
    private List[] currentRoundAggrValue;
    private Object[][] aggrArgs;
    private int currentAggrCount;
    private AccumulatorManager[] accumulatorManagers;
    private Set invalidAggrSet;
    private Map invalidAggrMsg;
    private Set<String> aggrNames;

    public AggregationHelper(IAggrDefnManager manager, ResultSetPopulator populator) throws DataException {
        this.populator = populator;
        this.manager = manager;
        this.currentRoundAggrValue = new List[0];
        this.populateAggregations(populator.getSession().getTempDir());
    }

    private void populateAggregations(String tempDir) throws DataException {
        this.aggrNames = new HashSet<String>();
        this.currentAggrCount = this.manager.getAggrCount();
        if (this.currentAggrCount > 0) {
            this.currentRoundAggrValue = new List[this.currentAggrCount];
            this.aggrArgs = new Object[this.currentAggrCount][];
            int i = 0;
            while (i < this.currentAggrCount) {
                this.currentRoundAggrValue[i] = new BasicCachedList(tempDir, DataEngineSession.getCurrentClassLoader());
                IAggrInfo aggrInfo = this.manager.getAggrDefn(i);
                this.aggrArgs[i] = new Object[aggrInfo.getAggregation().getParameterDefn().length];
                this.aggrNames.add(this.manager.getAggrDefn(i).getName());
                ++i;
            }
            this.accumulatorManagers = new AccumulatorManager[this.currentAggrCount];
        }
        this.calculate();
    }

    private void calculate() throws DataException {
        ArrayList<Integer> validAggregations = new ArrayList<Integer>();
        boolean[] populateAggrValue = new boolean[this.currentAggrCount];
        int count = 1;
        int i = 0;
        while (i < this.currentAggrCount) {
            validAggregations.add(i);
            populateAggrValue[i] = this.getAggrInfo(i).getAggregation().getNumberOfPasses() <= 1;
            this.accumulatorManagers[i] = new AccumulatorManager(this.getAggrInfo(i).getAggregation());
            ++i;
        }
        while (validAggregations.size() > 0) {
            int[] validAggregationArray = new int[validAggregations.size()];
            int i2 = 0;
            while (i2 < validAggregations.size()) {
                validAggregationArray[i2] = (Integer)validAggregations.get(i2);
                ++i2;
            }
            assert (this.getCurrentResult() == null || this.getCurrentResultIndex() == 0);
            if (this.getCurrentResult() == null) {
                i2 = 0;
                while (i2 < this.accumulatorManagers.length) {
                    Accumulator a = this.accumulatorManagers[i2].getCurrentAccumulator();
                    a.start();
                    a.finish();
                    this.currentRoundAggrValue[i2].add(a.getValue());
                    ++i2;
                }
                return;
            }
            this.pass(populateAggrValue, validAggregationArray);
            this.first(0);
            this.prepareNextIteration(validAggregations, populateAggrValue, ++count);
        }
    }

    private void pass(boolean[] populateAggrValue, int[] validAggregationArray) throws DataException {
        do {
            int startingGroupLevel = this.getStartingGroupLevel();
            int endingGroupLevel = this.getEndingGroupLevel();
            int i = 0;
            while (i < validAggregationArray.length) {
                int index = validAggregationArray[i];
                if (this.invalidAggrSet != null && this.invalidAggrSet.contains(index)) {
                    this.addInvalidAggrMsg(index, endingGroupLevel);
                } else if (!this.onRow(index, startingGroupLevel, endingGroupLevel, populateAggrValue[index])) {
                    this.addInvalidAggrMsg(index, endingGroupLevel);
                    if (this.invalidAggrSet == null) {
                        this.invalidAggrSet = new HashSet();
                    }
                    this.invalidAggrSet.add(index);
                }
                ++i;
            }
        } while (this.populator.getResultIterator().next());
    }

    private void addInvalidAggrMsg(int index, int endingGroupLevel) throws DataException {
        assert (this.invalidAggrMsg != null);
        if (this.getAggrInfo(index).getAggregation().getType() == 1 || endingGroupLevel <= this.getAggrInfo(index).getGroupLevel() || this.getAggrInfo(index).getGroupLevel() == 0) {
            this.currentRoundAggrValue[index].add(this.invalidAggrMsg.get(index));
        }
    }

    private boolean onRow(int aggrIndex, int startingGroupLevel, int endingGroupLevel, boolean populateValue) throws DataException {
        boolean isRunning;
        IAggrInfo aggrInfo = this.getAggrInfo(aggrIndex);
        Accumulator acc = null;
        boolean newGroup = false;
        IParameterDefn[] argDefs = aggrInfo.getAggregation().getParameterDefn();
        if (startingGroupLevel <= aggrInfo.getGroupLevel()) {
            acc = this.accumulatorManagers[aggrIndex].next();
            acc.start();
            newGroup = true;
        } else {
            acc = this.accumulatorManagers[aggrIndex].getCurrentAccumulator();
        }
        boolean accepted = true;
        if (aggrInfo.getFilter() != null) {
            try {
                Object filterResult = ExprEvaluateUtil.evaluateValue(aggrInfo.getFilter(), this.populator.getCache().getCurrentIndex(), this.populator.getCache().getCurrentResult(), this.populator.getQuery().getExprProcessor().getScope(), this.populator.getSession().getEngineContext().getScriptContext());
                accepted = filterResult == null ? true : DataTypeUtil.toBoolean(filterResult);
            }
            catch (BirtException e) {
                if (this.invalidAggrMsg == null) {
                    this.invalidAggrMsg = new HashMap();
                }
                this.invalidAggrMsg.put(aggrIndex, e);
                return false;
            }
        }
        if (aggrInfo.getCalcualteLevel() > 0 && startingGroupLevel > aggrInfo.getCalcualteLevel()) {
            accepted = false;
        }
        if (accepted) {
            block20: {
                IBaseExpression[] arguments = aggrInfo.getArgument();
                if (!this.isFunctionCount(aggrInfo) && arguments == null) {
                    DataException e = new DataException("data.engine.WrongNumAggrArgs", aggrInfo.getName());
                    this.wrapException(aggrIndex, e);
                    return false;
                }
                try {
                    int optionalAgrsNum = 0;
                    int i = 0;
                    while (i < argDefs.length) {
                        if (argDefs[i].isOptional()) {
                            ++optionalAgrsNum;
                        }
                        if (aggrInfo.getArgument() == null || i >= arguments.length + optionalAgrsNum) {
                            throw new DataException("data.aggregation.argumentError", new Object[]{argDefs[i].getName(), aggrInfo.getName()});
                        }
                        if (this.isEmptyAggrArgument(aggrInfo)) {
                            this.aggrArgs[aggrIndex] = null;
                        } else {
                            this.evaluateArgsValue(aggrIndex, aggrInfo, i, argDefs[i]);
                        }
                        ++i;
                    }
                    if (aggrInfo.getArgument() != null && this.isValidArgumentNumber(aggrInfo.getArgument().length, argDefs.length, optionalAgrsNum)) break block20;
                    DataException e = new DataException("data.engine.WrongNumAggrArgs", aggrInfo.getName());
                    this.wrapException(aggrIndex, e);
                    return false;
                }
                catch (DataException e) {
                    this.wrapException(aggrIndex, e);
                    return false;
                }
            }
            acc.onRow(this.aggrArgs[aggrIndex]);
            newGroup = false;
        }
        boolean bl = isRunning = aggrInfo.getAggregation().getType() == 1;
        if (isRunning && populateValue) {
            Object value = acc.getValue();
            this.currentRoundAggrValue[aggrIndex].add(value);
        }
        if (endingGroupLevel <= aggrInfo.getGroupLevel()) {
            acc.finish();
            if (!isRunning && populateValue) {
                Object value = acc.getValue();
                this.currentRoundAggrValue[aggrIndex].add(value);
            }
        }
        return true;
    }

    private boolean isValidArgumentNumber(int aggrArgNumb, int argDefsLength, int optionalNum) {
        return aggrArgNumb >= argDefsLength - optionalNum && aggrArgNumb <= argDefsLength;
    }

    private boolean isEmptyAggrArgument(IAggrInfo aggrInfo) {
        return aggrInfo.getArgument().length == 0 || aggrInfo.getArgument()[0] == null || ((IScriptExpression)aggrInfo.getArgument()[0]).getText() == null || ((IScriptExpression)aggrInfo.getArgument()[0]).getText().trim().length() == 0;
    }

    private void evaluateArgsValue(int aggrIndex, IAggrInfo aggrInfo, int i, IParameterDefn paramDefn) throws DataException {
        if (i >= aggrInfo.getArgument().length) {
            return;
        }
        IBaseExpression argExpr = aggrInfo.getArgument()[i];
        if (!paramDefn.isOptional()) {
            if (!this.isFunctionCount(aggrInfo) && this.isEmptyScriptExpression(argExpr)) {
                throw new DataException("data.engine.AggregationBinding.EmptyArgument", new Object[]{paramDefn.getName(), aggrInfo.getName()});
            }
        } else if (argExpr == null || ((IScriptExpression)argExpr).getText() == null || ((IScriptExpression)argExpr).getText().trim().length() == 0) {
            this.aggrArgs[aggrIndex][i] = null;
            return;
        }
        try {
            this.aggrArgs[aggrIndex][i] = ExprEvaluateUtil.evaluateValue(argExpr, this.populator.getCache().getCurrentIndex(), this.populator.getCache().getCurrentResult(), this.populator.getQuery().getExprProcessor().getScope(), this.populator.getSession().getEngineContext().getScriptContext());
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private void wrapException(int aggrIndex, DataException e) {
        if (this.invalidAggrMsg == null) {
            this.invalidAggrMsg = new HashMap();
        }
        this.invalidAggrMsg.put(aggrIndex, e);
    }

    private boolean isEmptyScriptExpression(IBaseExpression argExpr) {
        IScriptExpression expr = (IScriptExpression)argExpr;
        return expr == null || expr.getText() == null || expr.getText().trim().length() == 0;
    }

    private boolean isFunctionCount(IAggrInfo aggrInfo) {
        return aggrInfo.getAggregation().getParameterDefn().length == 0;
    }

    private void prepareNextIteration(List validAggregations, boolean[] populateAggrValue, int count) throws DataException {
        validAggregations.clear();
        int i = 0;
        while (i < this.currentAggrCount) {
            this.accumulatorManagers[i].restart();
            IAggrFunction aggrFunc = this.getAggrInfo(i).getAggregation();
            populateAggrValue[i] = false;
            int passesNumber = aggrFunc.getNumberOfPasses();
            if (count <= passesNumber) {
                validAggregations.add(i);
                if (count == passesNumber) {
                    populateAggrValue[i] = true;
                }
            }
            ++i;
        }
    }

    private IAggrInfo getAggrInfo(int i) throws DataException {
        return this.manager.getAggrDefn(i);
    }

    private int getStartingGroupLevel() throws DataException {
        return this.populator.getResultIterator().getStartingGroupLevel();
    }

    private int getEndingGroupLevel() throws DataException {
        return this.populator.getResultIterator().getEndingGroupLevel();
    }

    private int getCurrentGroupIndex(int groupLevel) throws DataException {
        return this.populator.getResultIterator().getCurrentGroupIndex(groupLevel);
    }

    private int getCurrentResultIndex() throws DataException {
        return this.populator.getResultIterator().getCurrentResultIndex();
    }

    private IResultObject getCurrentResult() throws DataException {
        return this.populator.getResultIterator().getCurrentResult();
    }

    private void first(int groupLevel) throws DataException {
        this.populator.getResultIterator().first(groupLevel);
    }

    @Override
    public Object getAggrValue(String name) throws DataException {
        IAggrInfo aggrInfo = this.manager.getAggrDefn(name);
        if (this.populator.getCache().getCount() == 0) {
            return aggrInfo.getAggregation().getDefaultValue();
        }
        int groupIndex = aggrInfo.getAggregation().getType() == 0 ? (aggrInfo.getGroupLevel() == 0 ? 0 : this.getCurrentGroupIndex(aggrInfo.getGroupLevel())) : this.getCurrentResultIndex();
        return this.currentRoundAggrValue[this.manager.getAggrDefnIndex(name)].get(groupIndex);
    }

    @Override
    public List getAggrValues(String name) throws DataException {
        return this.currentRoundAggrValue[this.manager.getAggrDefnIndex(name)];
    }

    public boolean hasAggr(String name) throws DataException {
        return this.manager.getAggrDefnIndex(name) != -1;
    }

    @Override
    public Set<String> getAggrNames() throws DataException {
        return this.aggrNames;
    }

    @Override
    public IAggrInfo getAggrInfo(String aggrName) throws DataException {
        if (this.hasAggr(aggrName)) {
            return this.manager.getAggrDefn(aggrName);
        }
        return null;
    }

    private static class AccumulatorManager {
        private IAggrFunction aggregation;
        private int cursor;
        private List cachedAcc;
        private Accumulator accumulator;

        AccumulatorManager(IAggrFunction aggregation) {
            this.aggregation = aggregation;
            this.cursor = -1;
            int passNum = aggregation.getNumberOfPasses();
            if (passNum < 2) {
                this.accumulator = aggregation.newAccumulator();
            } else {
                this.cachedAcc = new ArrayList();
            }
        }

        Accumulator getCurrentAccumulator() {
            if (this.accumulator != null) {
                return this.accumulator;
            }
            if (this.cachedAcc.size() == 0) {
                this.cachedAcc.add(this.aggregation.newAccumulator());
                ++this.cursor;
            }
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        Accumulator next() {
            if (this.accumulator != null) {
                return this.accumulator;
            }
            ++this.cursor;
            if (this.cachedAcc.size() > this.cursor) {
                return (Accumulator)this.cachedAcc.get(this.cursor);
            }
            this.cachedAcc.add(this.aggregation.newAccumulator());
            return (Accumulator)this.cachedAcc.get(this.cursor);
        }

        void restart() {
            this.cursor = -1;
        }
    }
}

