/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.rank.DataComparisonException;
import org.eclipse.birt.data.aggregation.impl.rank.DummyObject;
import org.eclipse.birt.data.aggregation.impl.rank.NullObject;
import org.eclipse.birt.data.aggregation.impl.rank.ValueComparator;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

final class RankAggregationUtil {
    private static DummyObject dummy = new DummyObject();
    private static NullObject nullObject = new NullObject();

    RankAggregationUtil() {
    }

    static int getNextTopIndex(List cachedValues) throws DataException {
        return RankAggregationUtil.getIndex(cachedValues, true);
    }

    static int getNextBottomIndex(List cachedValues) throws DataException {
        return RankAggregationUtil.getIndex(cachedValues, false);
    }

    private static int getIndex(List cachedValues, boolean top) throws DataException {
        int result = -1;
        int i = 0;
        while (i < cachedValues.size()) {
            if (cachedValues.get(i).getClass() != DummyObject.class) {
                if (result == -1) {
                    result = i;
                } else if (top ? RankAggregationUtil.compareTop(cachedValues.get(result), cachedValues.get(i)) : RankAggregationUtil.compareBottom(cachedValues.get(result), cachedValues.get(i))) {
                    result = i;
                }
            }
            ++i;
        }
        cachedValues.set(result, dummy);
        return result;
    }

    private static boolean compareTop(Object value1, Object value2) throws DataException {
        if (value1.getClass() == DummyObject.class || value2.getClass() == DummyObject.class) {
            return false;
        }
        if (value1.getClass() == NullObject.class) {
            return true;
        }
        if (value2.getClass() == NullObject.class) {
            return false;
        }
        return Boolean.parseBoolean(ScriptEvalUtil.evalConditionalExpr(value1, 3, value2, null).toString());
    }

    private static boolean compareBottom(Object value1, Object value2) throws DataException {
        if (value1.getClass() == DummyObject.class || value2.getClass() == DummyObject.class || value1.getClass() == NullObject.class) {
            return false;
        }
        if (value2.getClass() == NullObject.class) {
            return true;
        }
        return Boolean.parseBoolean(ScriptEvalUtil.evalConditionalExpr(value1, 6, value2, null).toString());
    }

    static Double getNumericValue(Object o) throws DataException {
        try {
            if (o instanceof Date) {
                return new Double(((Date)o).getTime());
            }
            return new Double(o.toString());
        }
        catch (NumberFormatException e) {
            throw DataException.wrap(new AggrException("aggregation.DataConversionError", e));
        }
    }

    static NullObject getNullObject() {
        return nullObject;
    }

    static void sortArray(Object[] objs) throws DataException {
        try {
            Arrays.sort(objs, new ValueComparator());
        }
        catch (DataComparisonException e) {
            throw e.getWrappedException();
        }
    }
}

